/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.vec.internal;

import java.io.IOException;
import java.lang.foreign.MemorySegment;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.quantization.ScalarQuantizedVectorSimilarity;
import org.elasticsearch.vec.internal.AbstractScalarQuantizedVectorScorer;

public final class DotProduct
extends AbstractScalarQuantizedVectorScorer {
    public DotProduct(int dims, int maxOrd, float scoreCorrectionConstant, IndexInput input) {
        super(dims, maxOrd, scoreCorrectionConstant, input, ScalarQuantizedVectorSimilarity.fromVectorSimilarity((VectorSimilarityFunction)VectorSimilarityFunction.DOT_PRODUCT, (float)scoreCorrectionConstant));
    }

    @Override
    public float score(int firstOrd, int secondOrd) throws IOException {
        this.checkOrdinal(firstOrd);
        this.checkOrdinal(secondOrd);
        int length = this.dims;
        long firstByteOffset = (long)firstOrd * (long)(length + 4);
        long secondByteOffset = (long)secondOrd * (long)(length + 4);
        MemorySegment firstSeg = this.segmentSlice(firstByteOffset, length);
        this.input.seek(firstByteOffset + (long)length);
        float firstOffset = Float.intBitsToFloat(this.input.readInt());
        MemorySegment secondSeg = this.segmentSlice(secondByteOffset, length);
        this.input.seek(secondByteOffset + (long)length);
        float secondOffset = Float.intBitsToFloat(this.input.readInt());
        if (firstSeg != null && secondSeg != null) {
            int dotProduct = DotProduct.dotProduct(firstSeg, secondSeg, length);
            float adjustedDistance = (float)dotProduct * this.scoreCorrectionConstant + firstOffset + secondOffset;
            return (1.0f + adjustedDistance) / 2.0f;
        }
        return this.fallbackScore(firstByteOffset, secondByteOffset);
    }

    @Override
    public DotProduct copy() {
        return new DotProduct(this.dims, this.maxOrd, this.scoreCorrectionConstant, this.input.clone());
    }
}

