/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.vec;

import java.io.IOException;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.elasticsearch.vec.VectorScorer;

public final class VectorScorerSupplierAdapter
implements RandomVectorScorerSupplier {
    private final VectorScorer scorer;

    public VectorScorerSupplierAdapter(VectorScorer scorer) {
        this.scorer = scorer;
    }

    public RandomVectorScorer scorer(final int ord) throws IOException {
        return new RandomVectorScorer(){
            final int firstOrd;
            {
                this.firstOrd = ord;
            }

            public float score(int otherOrd) throws IOException {
                return VectorScorerSupplierAdapter.this.scorer.score(this.firstOrd, otherOrd);
            }

            public int maxOrd() {
                return VectorScorerSupplierAdapter.this.scorer.maxOrd();
            }
        };
    }

    public RandomVectorScorerSupplier copy() throws IOException {
        return new VectorScorerSupplierAdapter(this.scorer.copy());
    }
}

