/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xcontent;

import java.io.IOException;
import org.elasticsearch.xcontent.FilterXContentParserWrapper;
import org.elasticsearch.xcontent.XContentParser;

public class XContentSubParser
extends FilterXContentParserWrapper {
    private int level;
    private boolean closed;

    public XContentSubParser(XContentParser parser) {
        super(parser);
        XContentParser.Token token = parser.currentToken();
        if (token != XContentParser.Token.START_OBJECT && token != XContentParser.Token.START_ARRAY) {
            throw new IllegalStateException("The sub parser has to be created on the start of an object or array");
        }
        this.level = 1;
    }

    @Override
    public XContentParser.Token nextToken() throws IOException {
        if (this.level > 0) {
            XContentParser.Token token = super.nextToken();
            if (token == XContentParser.Token.START_OBJECT || token == XContentParser.Token.START_ARRAY) {
                ++this.level;
            } else if (token == XContentParser.Token.END_OBJECT || token == XContentParser.Token.END_ARRAY) {
                --this.level;
            }
            return token;
        }
        return null;
    }

    @Override
    public void skipChildren() throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token != XContentParser.Token.START_OBJECT && token != XContentParser.Token.START_ARRAY) {
            return;
        }
        int backToLevel = this.level - 1;
        while (this.nextToken() != null) {
            if (this.level > backToLevel) continue;
            return;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            while (this.nextToken() != null) {
            }
            return;
        }
    }
}

