/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xcontent;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public interface XContentGenerator
extends Closeable,
Flushable {
    public XContentType contentType();

    public void usePrettyPrint();

    public boolean isPrettyPrint();

    public void usePrintLineFeedAtEnd();

    public void writeStartObject() throws IOException;

    public void writeEndObject() throws IOException;

    public void writeStartArray() throws IOException;

    public void writeEndArray() throws IOException;

    public void writeFieldName(String var1) throws IOException;

    public void writeNull() throws IOException;

    public void writeNullField(String var1) throws IOException;

    public void writeBooleanField(String var1, boolean var2) throws IOException;

    public void writeBoolean(boolean var1) throws IOException;

    public void writeNumberField(String var1, double var2) throws IOException;

    public void writeNumber(double var1) throws IOException;

    public void writeNumberField(String var1, float var2) throws IOException;

    public void writeNumber(float var1) throws IOException;

    public void writeNumberField(String var1, int var2) throws IOException;

    public void writeNumber(int var1) throws IOException;

    public void writeNumberField(String var1, long var2) throws IOException;

    public void writeNumber(long var1) throws IOException;

    public void writeNumber(short var1) throws IOException;

    public void writeNumber(BigInteger var1) throws IOException;

    public void writeNumberField(String var1, BigInteger var2) throws IOException;

    public void writeNumber(BigDecimal var1) throws IOException;

    public void writeNumberField(String var1, BigDecimal var2) throws IOException;

    public void writeStringField(String var1, String var2) throws IOException;

    public void writeString(String var1) throws IOException;

    public void writeStringArray(String[] var1) throws IOException;

    public void writeString(char[] var1, int var2, int var3) throws IOException;

    public void writeUTF8String(byte[] var1, int var2, int var3) throws IOException;

    public void writeBinaryField(String var1, byte[] var2) throws IOException;

    public void writeBinary(byte[] var1) throws IOException;

    public void writeBinary(byte[] var1, int var2, int var3) throws IOException;

    @Deprecated
    public void writeRawField(String var1, InputStream var2) throws IOException;

    public void writeRawField(String var1, InputStream var2, XContentType var3) throws IOException;

    public void writeRawValue(InputStream var1, XContentType var2) throws IOException;

    public void writeRawValue(String var1) throws IOException;

    public void copyCurrentStructure(XContentParser var1) throws IOException;

    public void writeDirectField(String var1, CheckedConsumer<OutputStream, IOException> var2) throws IOException;

    default public void copyCurrentEvent(XContentParser parser) throws IOException {
        block0 : switch (parser.currentToken()) {
            case START_OBJECT: {
                this.writeStartObject();
                break;
            }
            case END_OBJECT: {
                this.writeEndObject();
                break;
            }
            case START_ARRAY: {
                this.writeStartArray();
                break;
            }
            case END_ARRAY: {
                this.writeEndArray();
                break;
            }
            case FIELD_NAME: {
                this.writeFieldName(parser.currentName());
                break;
            }
            case VALUE_STRING: {
                if (parser.hasTextCharacters()) {
                    this.writeString(parser.textCharacters(), parser.textOffset(), parser.textLength());
                    break;
                }
                this.writeString(parser.text());
                break;
            }
            case VALUE_NUMBER: {
                switch (parser.numberType()) {
                    case INT: {
                        this.writeNumber(parser.intValue());
                        break block0;
                    }
                    case LONG: {
                        this.writeNumber(parser.longValue());
                        break block0;
                    }
                    case FLOAT: {
                        this.writeNumber(parser.floatValue());
                        break block0;
                    }
                    case DOUBLE: {
                        this.writeNumber(parser.doubleValue());
                        break block0;
                    }
                    case BIG_INTEGER: {
                        this.writeNumber((BigInteger)parser.numberValue());
                        break block0;
                    }
                }
                if (!1.$assertionsDisabled) {
                    throw new AssertionError((Object)("missing xcontent number handling for type [" + String.valueOf((Object)parser.numberType()) + "]"));
                }
                break;
            }
            case VALUE_BOOLEAN: {
                this.writeBoolean(parser.booleanValue());
                break;
            }
            case VALUE_NULL: {
                this.writeNull();
                break;
            }
            case VALUE_EMBEDDED_OBJECT: {
                this.writeBinary(parser.binaryValue());
                break;
            }
            default: {
                if (!1.$assertionsDisabled) {
                    throw new AssertionError((Object)("missing xcontent token handling for token [" + parser.text() + "]"));
                }
                break;
            }
        }
    }

    public boolean isClosed();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

