/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.test;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.tasks.Input;
import org.gradle.process.CommandLineArgumentProvider;

public class SystemPropertyCommandLineArgumentProvider
implements CommandLineArgumentProvider {
    private final Map<String, Object> systemProperties = new LinkedHashMap<String, Object>();

    public void systemProperty(String key, Supplier<String> value) {
        this.systemProperties.put(key, value);
    }

    public void systemProperty(String key, Object value) {
        this.systemProperties.put(key, value);
    }

    public Iterable<String> asArguments() {
        return this.systemProperties.entrySet().stream().map(entry -> "-D" + (String)entry.getKey() + "=" + (entry.getValue() instanceof Supplier ? ((Supplier)entry.getValue()).get() : entry.getValue())).collect(Collectors.toList());
    }

    @Input
    public Iterable<String> getPropertyNames() {
        return this.systemProperties.keySet();
    }
}

