/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testclusters;

import java.util.Collection;
import org.elasticsearch.gradle.testclusters.ElasticsearchCluster;
import org.elasticsearch.gradle.testclusters.TestClustersException;
import org.gradle.api.Task;
import org.gradle.api.tasks.Nested;

public interface TestClustersAware
extends Task {
    @Nested
    public Collection<ElasticsearchCluster> getClusters();

    default public void useCluster(ElasticsearchCluster cluster) {
        if (!cluster.getPath().equals(this.getProject().getPath())) {
            throw new TestClustersException("Task " + this.getPath() + " can't use test cluster from another project " + cluster);
        }
        cluster.getNodes().stream().map(node -> node::getBwcJdk).forEach(xva$0 -> this.dependsOn(new Object[]{xva$0}));
        cluster.getNodes().all(node -> node.getDistributions().stream().forEach(distro -> this.dependsOn(new Object[]{this.getProject().provider(() -> distro.maybeFreeze())})));
        cluster.getNodes().all(node -> {
            Object[] objectArray = new Object[1];
            objectArray[0] = node::getPluginAndModuleConfigurations;
            this.dependsOn(objectArray);
        });
        this.getClusters().add(cluster);
    }

    default public void beforeStart() {
    }
}

