/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import java.util.Comparator;
import javax.inject.Inject;
import org.elasticsearch.gradle.DistributionDependency;
import org.elasticsearch.gradle.DistributionResolution;
import org.elasticsearch.gradle.ElasticsearchDistribution;
import org.elasticsearch.gradle.Version;
import org.elasticsearch.gradle.distribution.ElasticsearchDistributionTypes;
import org.elasticsearch.gradle.transform.SymbolicLinkPreservingUntarTransform;
import org.elasticsearch.gradle.transform.UnzipTransform;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;

public class DistributionDownloadPlugin
implements Plugin<Project> {
    static final String RESOLUTION_CONTAINER_NAME = "elasticsearch_distributions_resolutions";
    private static final String CONTAINER_NAME = "elasticsearch_distributions";
    private static final String FAKE_IVY_GROUP = "elasticsearch-distribution";
    private static final String FAKE_SNAPSHOT_IVY_GROUP = "elasticsearch-distribution-snapshot";
    private static final String DOWNLOAD_REPO_NAME = "elasticsearch-downloads";
    private static final String SNAPSHOT_REPO_NAME = "elasticsearch-snapshots";
    public static final String DISTRO_EXTRACTED_CONFIG_PREFIX = "es_distro_extracted_";
    private NamedDomainObjectContainer<ElasticsearchDistribution> distributionsContainer;
    private NamedDomainObjectContainer<DistributionResolution> distributionsResolutionStrategiesContainer;
    private Property<Boolean> dockerAvailability;

    @Inject
    public DistributionDownloadPlugin(ObjectFactory objectFactory) {
        this.dockerAvailability = objectFactory.property(Boolean.class).value((Object)false);
    }

    public void setDockerAvailability(Provider<Boolean> dockerAvailability) {
        this.dockerAvailability.set(dockerAvailability);
    }

    public void apply(Project project) {
        project.getDependencies().registerTransform(UnzipTransform.class, transformSpec -> {
            transformSpec.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"zip");
            transformSpec.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"directory");
        });
        ArtifactTypeDefinition tarArtifactTypeDefinition = (ArtifactTypeDefinition)project.getDependencies().getArtifactTypes().maybeCreate("tar.gz");
        project.getDependencies().registerTransform(SymbolicLinkPreservingUntarTransform.class, transformSpec -> {
            transformSpec.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)tarArtifactTypeDefinition.getName());
            transformSpec.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"directory");
        });
        this.setupResolutionsContainer(project);
        this.setupDistributionContainer(project, this.dockerAvailability);
        DistributionDownloadPlugin.setupDownloadServiceRepo(project);
    }

    private void setupDistributionContainer(Project project, Property<Boolean> dockerAvailable) {
        this.distributionsContainer = project.container(ElasticsearchDistribution.class, name -> {
            Configuration fileConfiguration = (Configuration)project.getConfigurations().create("es_distro_file_" + name);
            Configuration extractedConfiguration = (Configuration)project.getConfigurations().create(DISTRO_EXTRACTED_CONFIG_PREFIX + name);
            extractedConfiguration.getAttributes().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"directory");
            return new ElasticsearchDistribution(name, project.getObjects(), this.dockerAvailability, fileConfiguration, extractedConfiguration, (Action<ElasticsearchDistribution>)((Action)dist -> this.finalizeDistributionDependencies(project, (ElasticsearchDistribution)dist)));
        });
        project.getExtensions().add(CONTAINER_NAME, this.distributionsContainer);
    }

    private void setupResolutionsContainer(Project project) {
        this.distributionsResolutionStrategiesContainer = project.container(DistributionResolution.class);
        this.distributionsResolutionStrategiesContainer.whenObjectAdded(resolveDependencyNotation -> resolveDependencyNotation.setPriority(this.distributionsResolutionStrategiesContainer.size()));
        project.getExtensions().add(RESOLUTION_CONTAINER_NAME, this.distributionsResolutionStrategiesContainer);
    }

    public static NamedDomainObjectContainer<ElasticsearchDistribution> getContainer(Project project) {
        return (NamedDomainObjectContainer)project.getExtensions().getByName(CONTAINER_NAME);
    }

    public static NamedDomainObjectContainer<DistributionResolution> getRegistrationsContainer(Project project) {
        return (NamedDomainObjectContainer)project.getExtensions().getByName(RESOLUTION_CONTAINER_NAME);
    }

    private void finalizeDistributionDependencies(Project project, ElasticsearchDistribution distribution) {
        DependencyHandler dependencies = project.getDependencies();
        DistributionDependency distributionDependency = this.resolveDependencyNotation(project, distribution);
        dependencies.add(distribution.configuration.getName(), distributionDependency.getDefaultNotation());
        if (distribution.getType().shouldExtract()) {
            dependencies.add(distribution.getExtracted().getName(), distributionDependency.getExtractedNotation());
        }
    }

    private DistributionDependency resolveDependencyNotation(Project p, ElasticsearchDistribution distribution) {
        return this.distributionsResolutionStrategiesContainer.stream().sorted(Comparator.comparingInt(DistributionResolution::getPriority)).map(r -> r.getResolver().resolve(p, distribution)).filter(d -> d != null).findFirst().orElseGet(() -> DistributionDependency.of(this.dependencyNotation(distribution)));
    }

    private static void addIvyRepo(Project project, String name, String url, String group) {
        IvyArtifactRepository ivyRepo = project.getRepositories().ivy(repo -> {
            repo.setName(name);
            repo.setUrl((Object)url);
            repo.metadataSources(IvyArtifactRepository.MetadataSources::artifact);
            repo.patternLayout(layout -> layout.artifact("/downloads/elasticsearch/[module]-[revision](-[classifier]).[ext]"));
        });
        project.getRepositories().exclusiveContent(exclusiveContentRepository -> {
            exclusiveContentRepository.filter(config -> config.includeGroup(group));
            exclusiveContentRepository.forRepositories(new ArtifactRepository[]{ivyRepo});
        });
    }

    private static void setupDownloadServiceRepo(Project project) {
        if (project.getRepositories().findByName(DOWNLOAD_REPO_NAME) != null) {
            return;
        }
        DistributionDownloadPlugin.addIvyRepo(project, DOWNLOAD_REPO_NAME, "https://artifacts-no-kpi.elastic.co", FAKE_IVY_GROUP);
        DistributionDownloadPlugin.addIvyRepo(project, SNAPSHOT_REPO_NAME, "https://snapshots-no-kpi.elastic.co", FAKE_SNAPSHOT_IVY_GROUP);
    }

    private String dependencyNotation(ElasticsearchDistribution distribution) {
        if (distribution.getType() == ElasticsearchDistributionTypes.INTEG_TEST_ZIP) {
            return "org.elasticsearch.distribution.integ-test-zip:elasticsearch:" + distribution.getVersion() + "@zip";
        }
        Version distroVersion = Version.fromString(distribution.getVersion());
        String extension = distribution.getType().getExtension(distribution.getPlatform());
        String classifier = distribution.getType().getClassifier(distribution.getPlatform(), distroVersion);
        String group = distribution.getVersion().endsWith("-SNAPSHOT") ? FAKE_SNAPSHOT_IVY_GROUP : FAKE_IVY_GROUP;
        return group + ":elasticsearch:" + distribution.getVersion() + classifier + "@" + extension;
    }
}

