/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

public enum Architecture {
    X64("x86_64"),
    AARCH64("aarch64");

    public final String classifier;

    private Architecture(String classifier) {
        this.classifier = classifier;
    }

    public static Architecture current() {
        String architecture;
        switch (architecture = System.getProperty("os.arch", "")) {
            case "amd64": 
            case "x86_64": {
                return X64;
            }
            case "aarch64": {
                return AARCH64;
            }
        }
        throw new IllegalArgumentException("can not determine architecture from [" + architecture + "]");
    }
}

