/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.plugin;

import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.elasticsearch.gradle.Version;
import org.elasticsearch.gradle.VersionProperties;
import org.elasticsearch.gradle.dependencies.CompileOnlyResolvePlugin;
import org.elasticsearch.gradle.jarhell.JarHellPlugin;
import org.elasticsearch.gradle.plugin.PluginPropertiesExtension;
import org.elasticsearch.gradle.plugin.PluginType;
import org.elasticsearch.gradle.test.GradleTestPolicySetupPlugin;
import org.elasticsearch.gradle.testclusters.ElasticsearchCluster;
import org.elasticsearch.gradle.testclusters.RunTask;
import org.elasticsearch.gradle.testclusters.TestClustersPlugin;
import org.elasticsearch.gradle.util.GradleUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.plugins.MavenPublishPlugin;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.jvm.tasks.Jar;

public class PluginBuildPlugin
implements Plugin<Project> {
    public static final String BUNDLE_PLUGIN_TASK_NAME = "bundlePlugin";
    public static final String PLUGIN_EXTENSION_NAME = "esplugin";

    public void apply(Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        project.getPluginManager().apply(TestClustersPlugin.class);
        project.getPluginManager().apply(CompileOnlyResolvePlugin.class);
        project.getPluginManager().apply(JarHellPlugin.class);
        project.getPluginManager().apply(GradleTestPolicySetupPlugin.class);
        PluginPropertiesExtension extension = (PluginPropertiesExtension)project.getExtensions().create(PLUGIN_EXTENSION_NAME, PluginPropertiesExtension.class, new Object[]{project});
        PluginBuildPlugin.configureDependencies(project);
        TaskProvider<Zip> bundleTask = PluginBuildPlugin.createBundleTasks(project, extension);
        project.afterEvaluate(project1 -> {
            PluginPropertiesExtension extension1 = (PluginPropertiesExtension)project1.getExtensions().getByType(PluginPropertiesExtension.class);
            PluginBuildPlugin.configurePublishing(project1, extension1);
            String name = extension1.getName();
            project1.setProperty("archivesBaseName", (Object)name);
            project1.setDescription(extension1.getDescription());
            if (extension1.getName() == null) {
                throw new InvalidUserDataException("name is a required setting for esplugin");
            }
            if (extension1.getDescription() == null) {
                throw new InvalidUserDataException("description is a required setting for esplugin");
            }
            if (!extension1.getType().equals((Object)PluginType.BOOTSTRAP) && extension1.getClassname() == null) {
                throw new InvalidUserDataException("classname is a required setting for esplugin");
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(12);
            map.put("name", extension1.getName());
            map.put("description", extension1.getDescription());
            map.put("version", extension1.getVersion());
            map.put("elasticsearchVersion", Version.fromString(VersionProperties.getElasticsearch()).toString());
            map.put("javaVersion", ((JavaPluginExtension)project1.getExtensions().getByType(JavaPluginExtension.class)).getTargetCompatibility().toString());
            map.put("classname", extension1.getType().equals((Object)PluginType.BOOTSTRAP) ? "" : extension1.getClassname());
            map.put("extendedPlugins", extension1.getExtendedPlugins().stream().collect(Collectors.joining(",")));
            map.put("hasNativeController", extension1.isHasNativeController());
            map.put("requiresKeystore", extension1.isRequiresKeystore());
            map.put("type", extension1.getType().toString());
            map.put("javaOpts", extension1.getJavaOpts());
            map.put("licensed", extension1.isLicensed());
            project1.getTasks().withType(Copy.class).named("pluginProperties").configure(copy -> {
                copy.expand(map);
                copy.getInputs().properties(map);
            });
        });
        project.getConfigurations().getByName("default").extendsFrom(new Configuration[]{project.getConfigurations().getByName("runtimeClasspath")});
        NamedDomainObjectContainer<ElasticsearchCluster> testClusters = PluginBuildPlugin.testClusters(project, "testClusters");
        NamedDomainObjectProvider runCluster = testClusters.register("runTask", c -> {
            if (GradleUtils.isModuleProject(project.getPath())) {
                c.module((Provider<RegularFile>)bundleTask.flatMap(zip -> zip.getArchiveFile()));
            } else {
                c.plugin((Provider<RegularFile>)bundleTask.flatMap(zip -> zip.getArchiveFile()));
            }
        });
        project.getTasks().register("run", RunTask.class, r -> {
            r.useCluster((ElasticsearchCluster)runCluster.get());
            r.dependsOn(new Object[]{project.getTasks().named(BUNDLE_PLUGIN_TASK_NAME)});
        });
    }

    private static NamedDomainObjectContainer<ElasticsearchCluster> testClusters(Project project, String extensionName) {
        return (NamedDomainObjectContainer)project.getExtensions().getByName(extensionName);
    }

    private static void configurePublishing(Project project, PluginPropertiesExtension extension) {
        if (project.getPlugins().hasPlugin(MavenPublishPlugin.class)) {
            PublishingExtension publishingExtension = (PublishingExtension)project.getExtensions().getByType(PublishingExtension.class);
            MavenPublication elastic = (MavenPublication)publishingExtension.getPublications().maybeCreate("elastic", MavenPublication.class);
            if (extension.isHasClientJar()) {
                project.getTasks().withType(Jar.class).configureEach(jar -> jar.getArchiveBaseName().set((Object)((String)jar.getArchiveBaseName().get() + "-client")));
                project.getTasks().withType(GenerateMavenPom.class).configureEach(pomTask -> {
                    String archivesBaseName = ((BasePluginConvention)project.getConvention().getPlugin(BasePluginConvention.class)).getArchivesBaseName();
                    pomTask.setDestination(new File(project.getBuildDir(), "/distributions/" + archivesBaseName + "-client-" + project.getVersion() + ".pom"));
                });
                elastic.setArtifactId(extension.getName() + "-client");
            } else {
                elastic.setArtifactId(extension.getName());
            }
        }
    }

    private static void configureDependencies(Project project) {
        DependencyHandler dependencies = project.getDependencies();
        dependencies.add("compileOnly", (Object)("org.elasticsearch:elasticsearch:" + VersionProperties.getElasticsearch()));
        dependencies.add("testImplementation", (Object)("org.elasticsearch.test:framework:" + VersionProperties.getElasticsearch()));
        dependencies.add("testImplementation", (Object)("org.apache.logging.log4j:log4j-core:" + VersionProperties.getVersions().get("log4j")));
        dependencies.add("compileOnly", (Object)("org.locationtech.spatial4j:spatial4j:" + VersionProperties.getVersions().get("spatial4j")));
        dependencies.add("compileOnly", (Object)("org.locationtech.jts:jts-core:" + VersionProperties.getVersions().get("jts")));
        dependencies.add("compileOnly", (Object)("org.apache.logging.log4j:log4j-api:" + VersionProperties.getVersions().get("log4j")));
        dependencies.add("compileOnly", (Object)("org.apache.logging.log4j:log4j-core:" + VersionProperties.getVersions().get("log4j")));
        dependencies.add("compileOnly", (Object)("net.java.dev.jna:jna:" + VersionProperties.getVersions().get("jna")));
    }

    private static TaskProvider<Zip> createBundleTasks(final Project project, PluginPropertiesExtension extension) {
        File pluginMetadata = project.file((Object)"src/main/plugin-metadata");
        final File templateFile = new File(project.getBuildDir(), "templates/plugin-descriptor.properties");
        TaskProvider copyPluginPropertiesTemplate = project.getTasks().register("copyPluginPropertiesTemplate", (Action)new Action<Task>(){

            public void execute(Task task) {
                task.getOutputs().file((Object)templateFile);
                task.doLast((Action)new Action<Task>(){

                    public void execute(Task task) {
                        InputStream resourceTemplate = PluginBuildPlugin.class.getResourceAsStream("/" + templateFile.getName());
                        try {
                            String templateText = IOUtils.toString((InputStream)resourceTemplate, (String)StandardCharsets.UTF_8.name());
                            FileUtils.write((File)templateFile, (CharSequence)templateText, (String)"UTF-8");
                        }
                        catch (IOException e) {
                            throw new GradleException("Unable to copy plugin properties", (Throwable)e);
                        }
                    }
                });
            }
        });
        TaskProvider buildProperties = project.getTasks().register("pluginProperties", Copy.class, copy -> {
            copy.dependsOn(new Object[]{copyPluginPropertiesTemplate});
            copy.from(new Object[]{templateFile});
            copy.into((Object)new File(project.getBuildDir(), "generated-resources"));
        });
        SourceSet testSourceSet = (SourceSet)((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("test");
        Map<String, TaskProvider> map = Map.of("builtBy", buildProperties);
        testSourceSet.getOutput().dir(map, (Object)new File(project.getBuildDir(), "generated-resources"));
        testSourceSet.getResources().srcDir((Object)pluginMetadata);
        TaskProvider bundle = project.getTasks().register(BUNDLE_PLUGIN_TASK_NAME, Zip.class, zip -> {
            zip.from(new Object[]{buildProperties});
            zip.from((Object)pluginMetadata, copySpec -> copySpec.exclude(new String[]{"plugin-security.codebases"}));
            zip.from(new Object[]{new Closure<Object>(null, null){

                public Object doCall(Object it) {
                    return project.getPluginManager().hasPlugin("com.github.johnrengelman.shadow") ? project.getTasks().named("shadowJar") : project.getTasks().named("jar");
                }

                public Object doCall() {
                    return this.doCall(null);
                }
            }});
            zip.from(new Object[]{project.getConfigurations().getByName("runtimeClasspath").minus((FileCollection)project.getConfigurations().getByName("resolveableCompileOnly"))});
            zip.from(new Object[]{"src/main/packaging"});
            zip.from((Object)"src/main", copySpec -> {
                copySpec.include(new String[]{"config/**"});
                copySpec.include(new String[]{"bin/**"});
            });
        });
        project.getTasks().named("assemble").configure(task -> task.dependsOn(new Object[]{bundle}));
        Configuration configuration = (Configuration)project.getConfigurations().create("zip");
        configuration.getAttributes().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"zip");
        project.getArtifacts().add("zip", (Object)bundle);
        return bundle;
    }
}

