/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.transform;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Function;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.internal.UncheckedException;

public interface UnpackTransform
extends TransformAction<Parameters> {
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputArtifact
    public Provider<FileSystemLocation> getArchiveFile();

    default public void transform(TransformOutputs outputs) {
        File archiveFile = ((FileSystemLocation)this.getArchiveFile().get()).getAsFile();
        File extractedDir = outputs.dir((Object)archiveFile.getName());
        try {
            Logging.getLogger(UnpackTransform.class).info("Unpacking " + archiveFile.getName() + " using " + this.getClass().getSimpleName() + ".");
            this.unpack(archiveFile, extractedDir, outputs, ((Parameters)this.getParameters()).getAsFiletreeOutput());
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public void unpack(File var1, File var2, TransformOutputs var3, boolean var4) throws IOException;

    default public Function<String, Path> pathResolver() {
        List<String> keepPatterns = ((Parameters)this.getParameters()).getKeepStructureFor();
        String trimmedPrefixPattern = ((Parameters)this.getParameters()).getTrimmedPrefixPattern();
        return trimmedPrefixPattern != null ? i -> UnpackTransform.trimArchiveExtractPath(keepPatterns, trimmedPrefixPattern, i) : i -> Paths.get(i, new String[0]);
    }

    public static Path trimArchiveExtractPath(List<String> keepPatterns, String ignoredPattern, String relativePath) {
        int index;
        Path entryName = Paths.get(relativePath, new String[0]);
        if (keepPatterns != null && keepPatterns.stream().anyMatch(keepPattern -> entryName.getName(0).toString().matches((String)keepPattern))) {
            if (entryName.getNameCount() == 1) {
                return null;
            }
            return entryName.subpath(1, entryName.getNameCount());
        }
        for (index = 0; index < entryName.getNameCount() && !entryName.getName(index).toString().matches(ignoredPattern); ++index) {
        }
        if (index + 1 >= entryName.getNameCount()) {
            return null;
        }
        return entryName.subpath(index + 1, entryName.getNameCount());
    }

    public static interface Parameters
    extends TransformParameters {
        @Input
        @Optional
        public String getTrimmedPrefixPattern();

        public void setTrimmedPrefixPattern(String var1);

        @Input
        @Optional
        public List<String> getKeepStructureFor();

        @Input
        public boolean getAsFiletreeOutput();

        public void setAsFiletreeOutput(boolean var1);

        @Internal
        public File getTargetDirectory();

        public void setTargetDirectory(File var1);

        public void setKeepStructureFor(List<String> var1);
    }
}

