/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import java.util.Arrays;
import org.elasticsearch.gradle.Jdk;
import org.elasticsearch.gradle.transform.SymbolicLinkPreservingUntarTransform;
import org.elasticsearch.gradle.transform.UnzipTransform;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Attribute;

public class JdkDownloadPlugin
implements Plugin<Project> {
    public static final String VENDOR_ADOPTIUM = "adoptium";
    public static final String VENDOR_OPENJDK = "openjdk";
    private static final String REPO_NAME_PREFIX = "jdk_repo_";
    private static final String EXTENSION_NAME = "jdks";
    public static final String JDK_TRIMMED_PREFIX = "(jdk-?\\d.*)|(zulu-?\\d.+).jdk";
    public static final String ZULU_LINUX_AARCH_PATTERN = "zulu.*linux_aarch64";

    public void apply(Project project) {
        Attribute jdkAttribute = Attribute.of((String)"jdk", Boolean.class);
        project.getDependencies().getAttributesSchema().attribute(jdkAttribute);
        project.getDependencies().getArtifactTypes().maybeCreate("zip");
        project.getDependencies().registerTransform(UnzipTransform.class, transformSpec -> {
            transformSpec.getFrom().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"zip").attribute(jdkAttribute, (Object)true);
            transformSpec.getTo().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"directory").attribute(jdkAttribute, (Object)true);
            transformSpec.parameters(parameters -> parameters.setTrimmedPrefixPattern(JDK_TRIMMED_PREFIX));
        });
        ArtifactTypeDefinition tarArtifactTypeDefinition = (ArtifactTypeDefinition)project.getDependencies().getArtifactTypes().maybeCreate("tar.gz");
        project.getDependencies().registerTransform(SymbolicLinkPreservingUntarTransform.class, transformSpec -> {
            transformSpec.getFrom().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)tarArtifactTypeDefinition.getName()).attribute(jdkAttribute, (Object)true);
            transformSpec.getTo().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"directory").attribute(jdkAttribute, (Object)true);
            transformSpec.parameters(parameters -> {
                parameters.setTrimmedPrefixPattern(JDK_TRIMMED_PREFIX);
                parameters.setKeepStructureFor(Arrays.asList(ZULU_LINUX_AARCH_PATTERN));
            });
        });
        NamedDomainObjectContainer jdksContainer = project.container(Jdk.class, name -> {
            Configuration configuration = (Configuration)project.getConfigurations().create("jdk_" + name);
            configuration.setCanBeConsumed(false);
            configuration.getAttributes().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"directory");
            configuration.getAttributes().attribute(jdkAttribute, (Object)true);
            Jdk jdk = new Jdk(name, configuration, project.getObjects());
            configuration.defaultDependencies(dependencies -> {
                jdk.finalizeValues();
                this.setupRepository(project, jdk);
                dependencies.add((Object)project.getDependencies().create((Object)JdkDownloadPlugin.dependencyNotation(jdk)));
            });
            return jdk;
        });
        project.getExtensions().add(EXTENSION_NAME, (Object)jdksContainer);
    }

    private void setupRepository(Project project, Jdk jdk) {
        String artifactPattern;
        String repoUrl;
        RepositoryHandler repositories = project.getRepositories();
        String repoName = REPO_NAME_PREFIX + jdk.getVendor() + "_" + jdk.getVersion();
        if (jdk.getVendor().equals(VENDOR_ADOPTIUM)) {
            repoUrl = "https://api.adoptium.net/v3/binary/version/";
            artifactPattern = jdk.getMajor().equals("8") ? "jdk" + jdk.getBaseVersion() + "-" + jdk.getBuild() + "/[module]/[classifier]/jdk/hotspot/normal/adoptium" : "jdk-" + jdk.getBaseVersion() + "+" + jdk.getBuild() + "/[module]/[classifier]/jdk/hotspot/normal/adoptium";
        } else if (jdk.getVendor().equals(VENDOR_OPENJDK)) {
            repoUrl = "https://download.oracle.com";
            artifactPattern = jdk.getHash() != null ? "java/GA/jdk" + jdk.getBaseVersion() + "/" + jdk.getHash() + "/" + jdk.getBuild() + "/GPL/openjdk-[revision]_[module]-[classifier]_bin.[ext]" : "java/GA/jdk" + jdk.getMajor() + "/" + jdk.getBuild() + "/GPL/openjdk-[revision]_[module]-[classifier]_bin.[ext]";
        } else {
            throw new GradleException("Unknown JDK vendor [" + jdk.getVendor() + "]");
        }
        if (repositories.findByName(repoName) == null) {
            repositories.ivy(repo -> {
                repo.setName(repoName);
                repo.setUrl((Object)repoUrl);
                repo.metadataSources(IvyArtifactRepository.MetadataSources::artifact);
                repo.patternLayout(layout -> layout.artifact(artifactPattern));
                repo.content(repositoryContentDescriptor -> repositoryContentDescriptor.includeGroup(JdkDownloadPlugin.groupName(jdk)));
            });
        }
    }

    public static NamedDomainObjectContainer<Jdk> getContainer(Project project) {
        return (NamedDomainObjectContainer)project.getExtensions().getByName(EXTENSION_NAME);
    }

    private static String dependencyNotation(Jdk jdk) {
        String platformDep = jdk.getPlatform().equals("darwin") || jdk.getPlatform().equals("mac") ? (jdk.getVendor().equals(VENDOR_ADOPTIUM) ? "mac" : "osx") : jdk.getPlatform();
        String extension = jdk.getPlatform().equals("windows") ? "zip" : "tar.gz";
        return JdkDownloadPlugin.groupName(jdk) + ":" + platformDep + ":" + jdk.getBaseVersion() + ":" + jdk.getArchitecture() + "@" + extension;
    }

    private static String groupName(Jdk jdk) {
        return jdk.getVendor() + "_" + jdk.getMajor();
    }
}

