/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.transform;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.elasticsearch.gradle.transform.UnpackTransform;
import org.elasticsearch.gradle.util.PermissionUtils;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.logging.Logging;

public abstract class UnzipTransform
implements UnpackTransform {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpack(File zipFile, File targetDir, TransformOutputs outputs, boolean asFiletreeOutput) throws IOException {
        Logging.getLogger(UnzipTransform.class).info("Unpacking " + zipFile.getName() + " using " + UnzipTransform.class.getSimpleName() + ".");
        Function<String, Path> pathModifier = this.pathResolver();
        try (ZipFile zip = new ZipFile(zipFile);){
            Enumeration entries = zip.getEntries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)entries.nextElement();
                Path child = pathModifier.apply(zipEntry.getName());
                if (child == null) continue;
                Path outputPath = targetDir.toPath().resolve(child);
                if (zipEntry.isDirectory()) {
                    outputPath.toFile().mkdirs();
                    PermissionUtils.chmod(outputPath, zipEntry.getUnixMode());
                    continue;
                }
                try (FileOutputStream outputStream = new FileOutputStream(outputPath.toFile());){
                    IOUtils.copyLarge((InputStream)zip.getInputStream(zipEntry), (OutputStream)outputStream);
                }
                PermissionUtils.chmod(outputPath, zipEntry.getUnixMode());
                if (!asFiletreeOutput) continue;
                outputs.file((Object)outputPath.toFile());
            }
        }
    }
}

