/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testclusters;

import java.util.Collection;
import org.elasticsearch.gradle.testclusters.ElasticsearchCluster;
import org.elasticsearch.gradle.testclusters.ElasticsearchNode;
import org.elasticsearch.gradle.testclusters.TestClustersException;
import org.gradle.api.Task;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Nested;

public interface TestClustersAware
extends Task {
    @Nested
    public Collection<ElasticsearchCluster> getClusters();

    default public void useCluster(ElasticsearchCluster cluster) {
        if (!cluster.getPath().equals(this.getProject().getPath())) {
            throw new TestClustersException("Task " + this.getPath() + " can't use test cluster from another project " + cluster);
        }
        cluster.getNodes().stream().map(node -> node::getBwcJdk).forEach(xva$0 -> this.dependsOn(new Object[]{xva$0}));
        cluster.getNodes().all(node -> node.getDistributions().stream().forEach(distro -> this.dependsOn(new Object[]{this.getProject().provider(() -> distro.maybeFreeze())})));
        cluster.getNodes().all(node -> {
            Object[] objectArray = new Object[1];
            objectArray[0] = node::getPluginAndModuleConfigurations;
            this.dependsOn(objectArray);
        });
        this.getClusters().add(cluster);
    }

    default public void useCluster(Provider<ElasticsearchCluster> cluster) {
        this.useCluster((ElasticsearchCluster)cluster.get());
    }

    default public void beforeStart() {
    }

    default public void enableDebug() {
        int debugPort = 5007;
        for (ElasticsearchCluster cluster : this.getClusters()) {
            for (ElasticsearchNode node : cluster.getNodes()) {
                this.getLogger().lifecycle("Running elasticsearch in debug mode, {} expecting running debug server on port {}", new Object[]{node, debugPort});
                node.jvmArgs("-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=" + debugPort);
                ++debugPort;
            }
        }
    }
}

