/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.gradle.OS;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.internal.jvm.Jvm;

public abstract class ReaperService
implements BuildService<Params>,
AutoCloseable {
    private static final String REAPER_CLASS = "org/elasticsearch/gradle/reaper/Reaper.class";
    private static final Pattern REAPER_JAR_PATH_PATTERN = Pattern.compile("file:(.*)!/org/elasticsearch/gradle/reaper/Reaper.class");
    private volatile Process reaperProcess;
    private final Logger logger = Logging.getLogger(this.getClass());

    public void registerPid(String serviceId, long pid) {
        String[] killPidCommand = OS.conditional().onWindows(() -> new String[]{"Taskkill", "/F", "/PID", String.valueOf(pid)}).onUnix(() -> new String[]{"kill", "-9", String.valueOf(pid)}).supply();
        this.registerCommand(serviceId, killPidCommand);
    }

    public void registerCommand(String serviceId, String ... command) {
        this.ensureReaperStarted();
        try (FileWriter writer = new FileWriter(this.getCmdFile(serviceId).toFile());){
            writer.write(String.join((CharSequence)" ", command));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Path getCmdFile(String serviceId) {
        return ((Directory)((Params)this.getParameters()).getInputDir().get()).getAsFile().toPath().resolve(serviceId.replaceAll("[^a-zA-Z0-9]", "-") + ".cmd");
    }

    public void unregister(String serviceId) {
        try {
            Files.deleteIfExists(this.getCmdFile(serviceId));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void shutdown() {
        if (this.reaperProcess != null) {
            this.ensureReaperAlive();
            try {
                this.reaperProcess.getOutputStream().close();
                this.logger.info("Waiting for reaper to exit normally");
                if (this.reaperProcess.waitFor() != 0) {
                    Path inputDir = ((Directory)((Params)this.getParameters()).getInputDir().get()).getAsFile().toPath();
                    throw new GradleException("Reaper process failed. Check log at " + inputDir.resolve("error.log") + " for details");
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private synchronized void ensureReaperStarted() {
        if (this.reaperProcess == null) {
            try {
                Path jarPath = this.locateReaperJar();
                Path inputDir = ((Directory)((Params)this.getParameters()).getInputDir().get()).getAsFile().toPath();
                Files.createDirectories(inputDir, new FileAttribute[0]);
                ProcessBuilder builder = new ProcessBuilder(Jvm.current().getJavaExecutable().toString(), "-Xms4m", "-Xmx16m", "-jar", jarPath.toString(), inputDir.toString());
                this.logger.info("Launching reaper: " + String.join((CharSequence)" ", builder.command()));
                builder.redirectInput(ProcessBuilder.Redirect.PIPE);
                File logFile = this.logFilePath().toFile();
                builder.redirectOutput(logFile);
                builder.redirectError(logFile);
                this.reaperProcess = builder.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.ensureReaperAlive();
        }
    }

    private Path logFilePath() {
        return ((Directory)((Params)this.getParameters()).getInputDir().get()).getAsFile().toPath().resolve("reaper.log");
    }

    private Path locateReaperJar() {
        if (((Params)this.getParameters()).getInternal().booleanValue()) {
            URL main = this.getClass().getClassLoader().getResource(REAPER_CLASS);
            String mainPath = main.getFile();
            Matcher matcher = REAPER_JAR_PATH_PATTERN.matcher(mainPath);
            if (matcher.matches()) {
                String path = matcher.group(1);
                return Paths.get(OS.conditional().onWindows(() -> path.substring(1)).onUnix(() -> path).supply(), new String[0]);
            }
            throw new RuntimeException("Unable to locate org/elasticsearch/gradle/reaper/Reaper.class on build classpath.");
        }
        Path jarPath = ((Directory)((Params)this.getParameters()).getBuildDir().get()).getAsFile().toPath().resolve("reaper").resolve("reaper.jar");
        try {
            Files.createDirectories(jarPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to create reaper JAR output directory " + jarPath.getParent(), e);
        }
        try (OutputStream out = Files.newOutputStream(jarPath, new OpenOption[0]);
             InputStream jarInput = this.getClass().getResourceAsStream("/META-INF/reaper.jar");){
            this.logger.info("Copying reaper.jar...");
            jarInput.transferTo(out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return jarPath;
    }

    private void ensureReaperAlive() {
        if (!this.reaperProcess.isAlive()) {
            throw new IllegalStateException("Reaper process died unexpectedly! Check the log at " + this.logFilePath().toString());
        }
    }

    @Override
    public void close() throws Exception {
        this.shutdown();
    }

    public static interface Params
    extends BuildServiceParameters {
        public Boolean getInternal();

        public void setInternal(Boolean var1);

        public DirectoryProperty getBuildDir();

        public DirectoryProperty getInputDir();
    }
}

