/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.jarhell;

import org.elasticsearch.gradle.jarhell.JarHellTask;
import org.elasticsearch.gradle.util.GradleUtils;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;

public class JarHellPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        TaskProvider<? extends Task> jarHellTask = this.createTask(project);
        project.getPluginManager().withPlugin("lifecycle-base", p -> project.getTasks().named("check").configure(t -> t.dependsOn(new Object[]{jarHellTask})));
    }

    private TaskProvider<? extends Task> createTask(Project project) {
        Configuration jarHellConfig = (Configuration)project.getConfigurations().create("jarHell");
        TaskProvider jarHell = project.getTasks().register("jarHell", JarHellTask.class);
        jarHell.configure(t -> {
            SourceSet testSourceSet = JarHellPlugin.getJavaTestSourceSet(project);
            t.setClasspath(testSourceSet.getRuntimeClasspath());
            t.setJarHellRuntimeClasspath((FileCollection)jarHellConfig);
        });
        return jarHell;
    }

    private static SourceSet getJavaTestSourceSet(Project project) {
        return (SourceSet)GradleUtils.getJavaSourceSets(project).findByName("test");
    }
}

