/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.test;

import org.elasticsearch.gradle.VersionProperties;
import org.elasticsearch.gradle.plugin.PluginBuildPlugin;
import org.elasticsearch.gradle.test.GradleTestPolicySetupPlugin;
import org.elasticsearch.gradle.test.SystemPropertyCommandLineArgumentProvider;
import org.elasticsearch.gradle.testclusters.ElasticsearchCluster;
import org.elasticsearch.gradle.testclusters.StandaloneRestIntegTestTask;
import org.elasticsearch.gradle.testclusters.TestClustersPlugin;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Zip;

public class JavaRestTestPlugin
implements Plugin<Project> {
    public static final String JAVA_REST_TEST = "javaRestTest";

    public void apply(Project project) {
        project.getPluginManager().apply(GradleTestPolicySetupPlugin.class);
        project.getPluginManager().apply(TestClustersPlugin.class);
        project.getPluginManager().apply(JavaBasePlugin.class);
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        SourceSet testSourceSet = (SourceSet)sourceSets.maybeCreate(JAVA_REST_TEST);
        Configuration javaRestTestImplementation = project.getConfigurations().getByName(testSourceSet.getImplementationConfigurationName());
        String elasticsearchVersion = VersionProperties.getElasticsearch();
        javaRestTestImplementation.defaultDependencies(deps -> deps.add((Object)project.getDependencies().create((Object)("org.elasticsearch.test:framework:" + elasticsearchVersion))));
        NamedDomainObjectContainer testClusters = (NamedDomainObjectContainer)project.getExtensions().getByName("testClusters");
        NamedDomainObjectProvider clusterProvider = testClusters.register(JAVA_REST_TEST);
        TaskProvider javaRestTestTask = project.getTasks().register(JAVA_REST_TEST, StandaloneRestIntegTestTask.class, task -> {
            task.useCluster((Provider)clusterProvider);
            task.setTestClassesDirs(testSourceSet.getOutput().getClassesDirs());
            task.setClasspath(testSourceSet.getRuntimeClasspath());
            ElasticsearchCluster cluster = (ElasticsearchCluster)clusterProvider.get();
            SystemPropertyCommandLineArgumentProvider nonInputProperties = new SystemPropertyCommandLineArgumentProvider();
            nonInputProperties.systemProperty("tests.rest.cluster", () -> String.join((CharSequence)",", cluster.getAllHttpSocketURI()));
            nonInputProperties.systemProperty("tests.cluster", () -> String.join((CharSequence)",", cluster.getAllTransportPortURI()));
            nonInputProperties.systemProperty("tests.clustername", () -> cluster.getName());
            task.getJvmArgumentProviders().add(nonInputProperties);
        });
        project.getPlugins().withType(PluginBuildPlugin.class, p -> {
            TaskProvider bundle = project.getTasks().withType(Zip.class).named("bundlePlugin");
            clusterProvider.configure(c -> c.plugin((Provider<RegularFile>)bundle.flatMap(AbstractArchiveTask::getArchiveFile)));
            javaRestTestTask.configure(t -> t.dependsOn(new Object[]{bundle}));
        });
        project.getTasks().named("check").configure(check -> check.dependsOn(new Object[]{javaRestTestTask}));
    }
}

