/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.test;

import java.io.File;
import org.elasticsearch.gradle.VersionProperties;
import org.elasticsearch.gradle.plugin.BasePluginBuildPlugin;
import org.elasticsearch.gradle.test.GradleTestPolicySetupPlugin;
import org.elasticsearch.gradle.test.SystemPropertyCommandLineArgumentProvider;
import org.elasticsearch.gradle.testclusters.ElasticsearchCluster;
import org.elasticsearch.gradle.testclusters.StandaloneRestIntegTestTask;
import org.elasticsearch.gradle.testclusters.TestClustersPlugin;
import org.elasticsearch.gradle.transform.UnzipTransform;
import org.elasticsearch.gradle.util.GradleUtils;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Zip;

public class YamlRestTestPlugin
implements Plugin<Project> {
    public static final String REST_TEST_SPECS_CONFIGURATION_NAME = "restTestSpecs";
    public static final String YAML_REST_TEST = "yamlRestTest";

    public void apply(Project project) {
        project.getPluginManager().apply(GradleTestPolicySetupPlugin.class);
        project.getPluginManager().apply(TestClustersPlugin.class);
        project.getPluginManager().apply(JavaBasePlugin.class);
        Attribute restAttribute = Attribute.of((String)"restSpecs", Boolean.class);
        project.getDependencies().getAttributesSchema().attribute(restAttribute);
        project.getDependencies().getArtifactTypes().maybeCreate("jar");
        project.getDependencies().registerTransform(UnzipTransform.class, transformSpec -> {
            transformSpec.getFrom().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar").attribute(restAttribute, (Object)true);
            transformSpec.getTo().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"directory").attribute(restAttribute, (Object)true);
        });
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration restTestSpecs = (Configuration)configurations.create(REST_TEST_SPECS_CONFIGURATION_NAME);
        restTestSpecs.getAttributes().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"directory");
        restTestSpecs.getAttributes().attribute(restAttribute, (Object)true);
        TaskProvider copyRestTestSpecs = project.getTasks().register("copyRestTestSpecs", Copy.class, t -> {
            t.from(new Object[]{restTestSpecs});
            t.into((Object)new File(project.getBuildDir(), "restResources/restspec"));
        });
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        SourceSet testSourceSet = (SourceSet)sourceSets.maybeCreate(YAML_REST_TEST);
        NamedDomainObjectContainer testClusters = (NamedDomainObjectContainer)project.getExtensions().getByName("testClusters");
        testSourceSet.getOutput().dir((Object)copyRestTestSpecs.map(Task::getOutputs));
        Configuration yamlRestTestImplementation = configurations.getByName(testSourceSet.getImplementationConfigurationName());
        YamlRestTestPlugin.setupDefaultDependencies(project.getDependencies(), restTestSpecs, yamlRestTestImplementation);
        NamedDomainObjectProvider cluster = testClusters.register(YAML_REST_TEST);
        TaskProvider<StandaloneRestIntegTestTask> yamlRestTestTask = this.setupTestTask(project, testSourceSet, (NamedDomainObjectProvider<ElasticsearchCluster>)cluster);
        project.getPlugins().withType(BasePluginBuildPlugin.class, p -> {
            if (GradleUtils.isModuleProject(project.getPath())) {
                TaskProvider bundle = project.getTasks().withType(Sync.class).named("explodedBundlePlugin");
                cluster.configure(c -> c.module((TaskProvider<Sync>)bundle));
            } else {
                TaskProvider bundle = project.getTasks().withType(Zip.class).named("bundlePlugin");
                cluster.configure(c -> c.plugin((TaskProvider<Zip>)bundle));
            }
        });
        project.getTasks().named("check").configure(check -> check.dependsOn(new Object[]{yamlRestTestTask}));
    }

    private static void setupDefaultDependencies(DependencyHandler dependencyHandler, Configuration restTestSpecs, Configuration yamlRestTestImplementation) {
        String elasticsearchVersion = VersionProperties.getElasticsearch();
        yamlRestTestImplementation.defaultDependencies(deps -> deps.add((Object)dependencyHandler.create((Object)("org.elasticsearch.test:yaml-rest-runner:" + elasticsearchVersion))));
        restTestSpecs.defaultDependencies(deps -> deps.add((Object)dependencyHandler.create((Object)("org.elasticsearch:rest-api-spec:" + elasticsearchVersion))));
    }

    private TaskProvider<StandaloneRestIntegTestTask> setupTestTask(Project project, SourceSet testSourceSet, NamedDomainObjectProvider<ElasticsearchCluster> clusterProvider) {
        return project.getTasks().register(YAML_REST_TEST, StandaloneRestIntegTestTask.class, task -> {
            task.useCluster((ElasticsearchCluster)clusterProvider.get());
            task.setTestClassesDirs(testSourceSet.getOutput().getClassesDirs());
            task.setClasspath(testSourceSet.getRuntimeClasspath());
            ElasticsearchCluster cluster = (ElasticsearchCluster)clusterProvider.get();
            SystemPropertyCommandLineArgumentProvider nonInputProperties = new SystemPropertyCommandLineArgumentProvider();
            nonInputProperties.systemProperty("tests.rest.cluster", () -> String.join((CharSequence)",", cluster.getAllHttpSocketURI()));
            nonInputProperties.systemProperty("tests.cluster", () -> String.join((CharSequence)",", cluster.getAllTransportPortURI()));
            nonInputProperties.systemProperty("tests.clustername", () -> cluster.getName());
            task.getJvmArgumentProviders().add(nonInputProperties);
            task.systemProperty("tests.rest.load_packaged", Boolean.FALSE.toString());
        });
    }
}

