/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testclusters;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.gradle.FileSupplier;
import org.elasticsearch.gradle.PropertyNormalization;
import org.elasticsearch.gradle.ReaperService;
import org.elasticsearch.gradle.Version;
import org.elasticsearch.gradle.testclusters.ElasticsearchNode;
import org.elasticsearch.gradle.testclusters.TestClusterConfiguration;
import org.elasticsearch.gradle.testclusters.TestClustersException;
import org.elasticsearch.gradle.testclusters.TestClustersPlugin;
import org.elasticsearch.gradle.testclusters.TestDistribution;
import org.elasticsearch.gradle.testclusters.WaitForHttpResource;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.process.ExecOperations;

public class ElasticsearchCluster
implements TestClusterConfiguration,
Named {
    private static final Logger LOGGER = Logging.getLogger(ElasticsearchNode.class);
    private static final int CLUSTER_UP_TIMEOUT = 40;
    private static final TimeUnit CLUSTER_UP_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private final AtomicBoolean configurationFrozen = new AtomicBoolean(false);
    private final String path;
    private final String clusterName;
    private final NamedDomainObjectContainer<ElasticsearchNode> nodes;
    private final FileOperations fileOperations;
    private final File workingDirBase;
    private final LinkedHashMap<String, Predicate<TestClusterConfiguration>> waitConditions = new LinkedHashMap();
    private final transient Project project;
    private final Provider<ReaperService> reaper;
    private final FileSystemOperations fileSystemOperations;
    private final ArchiveOperations archiveOperations;
    private final ExecOperations execOperations;
    private final Provider<File> runtimeJava;
    private final Function<Version, Boolean> isReleasedVersion;
    private int nodeIndex = 0;
    private final ConfigurableFileCollection pluginAndModuleConfiguration;
    private boolean shared = false;
    private final Map<String, Configuration> pluginAndModuleConfigurations = new HashMap<String, Configuration>();

    public ElasticsearchCluster(String path, String clusterName, Project project, Provider<ReaperService> reaper, FileSystemOperations fileSystemOperations, ArchiveOperations archiveOperations, ExecOperations execOperations, FileOperations fileOperations, File workingDirBase, Provider<File> runtimeJava, Function<Version, Boolean> isReleasedVersion) {
        this.path = path;
        this.clusterName = clusterName;
        this.project = project;
        this.reaper = reaper;
        this.fileSystemOperations = fileSystemOperations;
        this.archiveOperations = archiveOperations;
        this.execOperations = execOperations;
        this.fileOperations = fileOperations;
        this.workingDirBase = workingDirBase;
        this.runtimeJava = runtimeJava;
        this.isReleasedVersion = isReleasedVersion;
        this.nodes = project.container(ElasticsearchNode.class);
        this.pluginAndModuleConfiguration = project.getObjects().fileCollection();
        this.nodes.add((Object)new ElasticsearchNode(this.safeName(clusterName), path, clusterName + "-0", project, reaper, fileSystemOperations, archiveOperations, execOperations, fileOperations, workingDirBase, runtimeJava, isReleasedVersion));
        this.addWaitForClusterHealth();
    }

    @Internal
    public boolean isShared() {
        return this.shared;
    }

    protected void setShared(boolean shared) {
        this.shared = shared;
    }

    @Classpath
    public FileCollection getInstalledClasspath() {
        return this.pluginAndModuleConfiguration.getAsFileTree().filter(f -> f.getName().endsWith(".jar"));
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getInstalledFiles() {
        return this.pluginAndModuleConfiguration.getAsFileTree().filter(f -> !f.getName().endsWith(".jar"));
    }

    public void setNumberOfNodes(int numberOfNodes) {
        this.checkFrozen();
        if (numberOfNodes < 1) {
            throw new IllegalArgumentException("Number of nodes should be >= 1 but was " + numberOfNodes + " for " + this);
        }
        if (numberOfNodes < this.nodes.size()) {
            throw new IllegalArgumentException("Cannot shrink " + this + " to have " + numberOfNodes + " nodes as it already has " + this.getNumberOfNodes());
        }
        for (int i = this.nodes.size(); i < numberOfNodes; ++i) {
            this.nodes.add((Object)new ElasticsearchNode(this.safeName(this.clusterName), this.path, this.clusterName + "-" + i, this.project, this.reaper, this.fileSystemOperations, this.archiveOperations, this.execOperations, this.fileOperations, this.workingDirBase, this.runtimeJava, this.isReleasedVersion));
        }
    }

    public void setReadinessEnabled(boolean enabled) {
        if (enabled) {
            for (ElasticsearchNode node : this.nodes) {
                node.setting("readiness.port", "0");
            }
        }
    }

    @Internal
    public ElasticsearchNode getFirstNode() {
        return (ElasticsearchNode)this.nodes.getAt(this.clusterName + "-0");
    }

    @Internal
    public ElasticsearchNode getLastNode() {
        int index = this.nodes.size() - 1;
        return (ElasticsearchNode)this.nodes.getAt(this.clusterName + "-" + index);
    }

    @Internal
    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    @Internal
    public String getName() {
        return this.clusterName;
    }

    @Internal
    public String getPath() {
        return this.path;
    }

    @Override
    public void setVersion(String version) {
        this.nodes.all(each -> each.setVersion(version));
    }

    @Override
    public void setVersions(List<String> version) {
        this.nodes.all(each -> each.setVersions(version));
    }

    @Override
    public void setTestDistribution(TestDistribution distribution) {
        this.nodes.all(each -> each.setTestDistribution(distribution));
    }

    private void registerExtractedConfig(Provider<RegularFile> pluginProvider) {
        Dependency pluginDependency = this.project.getDependencies().create((Object)this.project.files(new Object[]{pluginProvider}));
        Configuration extractedConfig = this.project.getConfigurations().detachedConfiguration(new Dependency[]{pluginDependency});
        extractedConfig.getAttributes().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"directory");
        extractedConfig.getAttributes().attribute(TestClustersPlugin.BUNDLE_ATTRIBUTE, (Object)true);
        this.pluginAndModuleConfiguration.from(new Object[]{extractedConfig});
    }

    @Override
    public void plugin(String pluginProjectPath) {
        this.plugin(this.maybeCreatePluginOrModuleDependency(pluginProjectPath, "zip"));
    }

    @Override
    public void plugin(TaskProvider<Zip> plugin) {
        this.plugin((Provider<RegularFile>)plugin.flatMap(AbstractArchiveTask::getArchiveFile));
    }

    @Override
    public void plugin(Provider<RegularFile> plugin) {
        this.registerExtractedConfig(plugin);
        this.nodes.all(each -> each.plugin(plugin));
    }

    @Override
    public void module(Provider<RegularFile> module) {
        this.registerExtractedConfig(module);
        this.nodes.all(each -> each.module(module));
    }

    @Override
    public void module(TaskProvider<Sync> module) {
        this.module((Provider<RegularFile>)this.project.getLayout().file(module.map(Sync::getDestinationDir)));
    }

    @Override
    public void module(String moduleProjectPath) {
        this.module(this.maybeCreatePluginOrModuleDependency(moduleProjectPath, "explodedBundleZip"));
    }

    @Internal
    Collection<Configuration> getPluginAndModuleConfigurations() {
        return this.pluginAndModuleConfigurations.values();
    }

    private Provider<RegularFile> maybeCreatePluginOrModuleDependency(String path, String consumingConfiguration) {
        Configuration configuration = this.pluginAndModuleConfigurations.computeIfAbsent(path, key -> {
            Dependency bundleDependency = this.project.getDependencies().project(Map.of("path", path, "configuration", consumingConfiguration));
            return this.project.getConfigurations().detachedConfiguration(new Dependency[]{bundleDependency});
        });
        Provider fileProvider = configuration.getElements().map(s -> ((FileSystemLocation)s.stream().findFirst().orElseThrow(() -> new IllegalStateException(consumingConfiguration + " configuration of project " + path + " had no files"))).getAsFile());
        return this.project.getLayout().file(fileProvider);
    }

    @Override
    public void keystore(String key, String value) {
        this.nodes.all(each -> each.keystore(key, value));
    }

    @Override
    public void keystore(String key, Supplier<CharSequence> valueSupplier) {
        this.nodes.all(each -> each.keystore(key, valueSupplier));
    }

    @Override
    public void keystore(String key, File value) {
        this.nodes.all(each -> each.keystore(key, value));
    }

    @Override
    public void keystore(String key, File value, PropertyNormalization normalization) {
        this.nodes.all(each -> each.keystore(key, value, normalization));
    }

    @Override
    public void keystore(String key, FileSupplier valueSupplier) {
        this.nodes.all(each -> each.keystore(key, valueSupplier));
    }

    @Override
    public void keystorePassword(String password) {
        this.nodes.all(each -> each.keystorePassword(password));
    }

    @Override
    public void cliSetup(String binTool, CharSequence ... args) {
        this.nodes.all(each -> each.cliSetup(binTool, args));
    }

    @Override
    public void setting(String key, String value) {
        this.nodes.all(each -> each.setting(key, value));
    }

    @Override
    public void setting(String key, String value, PropertyNormalization normalization) {
        this.nodes.all(each -> each.setting(key, value, normalization));
    }

    @Override
    public void setting(String key, Supplier<CharSequence> valueSupplier) {
        this.nodes.all(each -> each.setting(key, valueSupplier));
    }

    @Override
    public void setting(String key, Supplier<CharSequence> valueSupplier, PropertyNormalization normalization) {
        this.nodes.all(each -> each.setting(key, valueSupplier, normalization));
    }

    @Override
    public void systemProperty(String key, String value) {
        this.nodes.all(each -> each.systemProperty(key, value));
    }

    @Override
    public void systemProperty(String key, Supplier<CharSequence> valueSupplier) {
        this.nodes.all(each -> each.systemProperty(key, valueSupplier));
    }

    @Override
    public void systemProperty(String key, Supplier<CharSequence> valueSupplier, PropertyNormalization normalization) {
        this.nodes.all(each -> each.systemProperty(key, valueSupplier, normalization));
    }

    @Override
    public void environment(String key, String value) {
        this.nodes.all(each -> each.environment(key, value));
    }

    @Override
    public void environment(String key, Supplier<CharSequence> valueSupplier) {
        this.nodes.all(each -> each.environment(key, valueSupplier));
    }

    @Override
    public void environment(String key, Supplier<CharSequence> valueSupplier, PropertyNormalization normalization) {
        this.nodes.all(each -> each.environment(key, valueSupplier, normalization));
    }

    @Override
    public void jvmArgs(String ... values) {
        this.nodes.all(each -> each.jvmArgs(values));
    }

    @Override
    @Internal
    public boolean isPreserveDataDir() {
        return this.nodes.stream().anyMatch(node -> node.isPreserveDataDir());
    }

    @Override
    public void setPreserveDataDir(boolean preserveDataDir) {
        this.nodes.all(each -> each.setPreserveDataDir(preserveDataDir));
    }

    @Override
    public void freeze() {
        this.nodes.forEach(ElasticsearchNode::freeze);
        this.configurationFrozen.set(true);
    }

    private void checkFrozen() {
        if (this.configurationFrozen.get()) {
            throw new IllegalStateException("Configuration for " + this + " can not be altered, already locked");
        }
    }

    @Override
    public void start() {
        this.commonNodeConfig();
        this.nodes.forEach(ElasticsearchNode::start);
    }

    private void commonNodeConfig() {
        String nodeNames = this.nodes.stream().map(ElasticsearchNode::getName).anyMatch(name -> name == null) ? null : this.nodes.stream().map(ElasticsearchNode::getName).map(this::safeName).collect(Collectors.joining(","));
        ElasticsearchNode firstNode = null;
        for (ElasticsearchNode node : this.nodes) {
            if (node.getTestDistribution().equals((Object)TestDistribution.INTEG_TEST)) {
                node.defaultConfig.put("xpack.security.enabled", "false");
            } else if (node.getVersion().onOrAfter("7.16.0")) {
                node.defaultConfig.put("cluster.deprecation_indexing.enabled", "false");
            }
            if (nodeNames != null) {
                assert (node.getVersion().onOrAfter("7.0.0")) : node.getVersion();
                assert (node.defaultConfig.keySet().stream().noneMatch(name -> name.startsWith("discovery.zen.")));
                node.defaultConfig.put("cluster.initial_master_nodes", "[" + nodeNames + "]");
                node.defaultConfig.put("discovery.seed_providers", "file");
                node.defaultConfig.put("discovery.seed_hosts", "[]");
            }
            if (firstNode != null) continue;
            firstNode = node;
        }
    }

    @Override
    public void restart() {
        this.nodes.forEach(ElasticsearchNode::restart);
    }

    public void goToNextVersion() {
        this.stop(false);
        this.nodes.all(ElasticsearchNode::goToNextVersion);
        this.start();
        this.writeUnicastHostsFiles();
    }

    public void nextNodeToNextVersion() {
        if (this.nodeIndex + 1 > this.nodes.size()) {
            throw new TestClustersException("Ran out of nodes to take to the next version");
        }
        ElasticsearchNode node = (ElasticsearchNode)this.nodes.getByName(this.clusterName + "-" + this.nodeIndex);
        node.stop(false);
        node.goToNextVersion();
        this.commonNodeConfig();
        ++this.nodeIndex;
        if (node.getTestDistribution().equals((Object)TestDistribution.DEFAULT) && node.getVersion().onOrAfter("7.16.0")) {
            node.setting("cluster.deprecation_indexing.enabled", "false");
        }
        node.start();
    }

    @Override
    public void extraConfigFile(String destination, File from) {
        this.nodes.all(node -> node.extraConfigFile(destination, from));
    }

    @Override
    public void extraConfigFile(String destination, File from, PropertyNormalization normalization) {
        this.nodes.all(node -> node.extraConfigFile(destination, from, normalization));
    }

    @Override
    public void extraJarFiles(FileCollection from) {
        this.nodes.all(node -> node.extraJarFiles(from));
    }

    @Override
    public void user(Map<String, String> userSpec) {
        this.nodes.all(node -> node.user(userSpec));
    }

    @Override
    public void rolesFile(File rolesYml) {
        this.nodes.all(node -> node.rolesFile(rolesYml));
    }

    @Override
    public void requiresFeature(String feature, Version from) {
        this.nodes.all(node -> node.requiresFeature(feature, from));
    }

    @Override
    public void requiresFeature(String feature, Version from, Version until) {
        this.nodes.all(node -> node.requiresFeature(feature, from, until));
    }

    public void writeUnicastHostsFiles() {
        String unicastUris = this.nodes.stream().flatMap(node -> node.getAllTransportPortURI().stream()).collect(Collectors.joining("\n"));
        this.nodes.forEach(node -> {
            try {
                Files.write(node.getConfigDir().resolve("unicast_hosts.txt"), unicastUris.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to write unicast_hosts for " + this, e);
            }
        });
    }

    @Override
    @Internal
    public String getHttpSocketURI() {
        this.waitForAllConditions();
        return this.getFirstNode().getHttpSocketURI();
    }

    @Override
    @Internal
    public String getTransportPortURI() {
        this.waitForAllConditions();
        return this.getFirstNode().getTransportPortURI();
    }

    @Override
    @Internal
    public String getReadinessPortURI() {
        this.waitForAllConditions();
        return this.getFirstNode().getReadinessPortURI();
    }

    @Override
    @Internal
    public List<String> getAllHttpSocketURI() {
        this.waitForAllConditions();
        return this.nodes.stream().flatMap(each -> each.getAllHttpSocketURI().stream()).collect(Collectors.toList());
    }

    @Override
    @Internal
    public List<String> getAllTransportPortURI() {
        this.waitForAllConditions();
        return this.nodes.stream().flatMap(each -> each.getAllTransportPortURI().stream()).collect(Collectors.toList());
    }

    @Override
    @Internal
    public List<String> getAllReadinessPortURI() {
        this.waitForAllConditions();
        return this.nodes.stream().flatMap(each -> each.getAllReadinessPortURI().stream()).collect(Collectors.toList());
    }

    @Override
    @Internal
    public List<String> getAllRemoteAccessPortURI() {
        this.waitForAllConditions();
        return this.nodes.stream().flatMap(each -> each.getAllRemoteAccessPortURI().stream()).collect(Collectors.toList());
    }

    public void waitForAllConditions() {
        this.writeUnicastHostsFiles();
        LOGGER.info("Starting to wait for cluster to form");
        this.waitForConditions(this.waitConditions, System.currentTimeMillis(), 40L, CLUSTER_UP_TIMEOUT_UNIT, this);
    }

    @Override
    public void stop(boolean tailLogs) {
        this.nodes.forEach(each -> each.stop(tailLogs));
    }

    @Override
    public void setNameCustomization(Function<String, String> nameCustomization) {
        this.nodes.all(each -> each.setNameCustomization(nameCustomization));
    }

    @Override
    @Internal
    public boolean isProcessAlive() {
        return this.nodes.stream().noneMatch(node -> !node.isProcessAlive());
    }

    public ElasticsearchNode singleNode() {
        if (this.nodes.size() != 1) {
            throw new IllegalStateException("Can't treat " + this + " as single node as it has " + this.nodes.size() + " nodes");
        }
        return this.getFirstNode();
    }

    private void addWaitForClusterHealth() {
        this.waitConditions.put("cluster health yellow", node -> {
            try {
                boolean httpSslEnabled = this.getFirstNode().isHttpSslEnabled();
                WaitForHttpResource wait = new WaitForHttpResource(httpSslEnabled ? "https" : "http", this.getFirstNode().getHttpSocketURI(), this.nodes.size());
                if (httpSslEnabled) {
                    this.getFirstNode().configureHttpWait(wait);
                }
                List<Map<String, String>> credentials = this.getFirstNode().getCredentials();
                if (!this.getFirstNode().getCredentials().isEmpty()) {
                    wait.setUsername(credentials.get(0).get("useradd"));
                    wait.setPassword(credentials.get(0).get("-p"));
                }
                return wait.wait(500);
            }
            catch (IOException e) {
                throw new UncheckedIOException("IO error while waiting cluster", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new TestClustersException("Interrupted while waiting for " + this, e);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("security exception", e);
            }
        });
    }

    @Nested
    public NamedDomainObjectContainer<ElasticsearchNode> getNodes() {
        return this.nodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElasticsearchCluster that = (ElasticsearchCluster)o;
        return Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.clusterName, this.path);
    }

    public String toString() {
        return "cluster{" + this.path + ":" + this.clusterName + "}";
    }
}

