/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testclusters;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.elasticsearch.gradle.Architecture;
import org.elasticsearch.gradle.DistributionDownloadPlugin;
import org.elasticsearch.gradle.ElasticsearchDistribution;
import org.elasticsearch.gradle.FileSupplier;
import org.elasticsearch.gradle.LazyPropertyList;
import org.elasticsearch.gradle.LazyPropertyMap;
import org.elasticsearch.gradle.LoggedExec;
import org.elasticsearch.gradle.OS;
import org.elasticsearch.gradle.PropertyNormalization;
import org.elasticsearch.gradle.ReaperService;
import org.elasticsearch.gradle.Version;
import org.elasticsearch.gradle.VersionProperties;
import org.elasticsearch.gradle.distribution.ElasticsearchDistributionTypes;
import org.elasticsearch.gradle.testclusters.TestClusterConfiguration;
import org.elasticsearch.gradle.testclusters.TestClustersException;
import org.elasticsearch.gradle.testclusters.TestDistribution;
import org.elasticsearch.gradle.testclusters.WaitForHttpResource;
import org.elasticsearch.gradle.util.Pair;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecSpec;

public class ElasticsearchNode
implements TestClusterConfiguration {
    private static final Logger LOGGER = Logging.getLogger(ElasticsearchNode.class);
    private static final int ES_DESTROY_TIMEOUT = 20;
    private static final TimeUnit ES_DESTROY_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private static final int NODE_UP_TIMEOUT = 2;
    private static final TimeUnit NODE_UP_TIMEOUT_UNIT = TimeUnit.MINUTES;
    private static final int ADDITIONAL_CONFIG_TIMEOUT = 15;
    private static final TimeUnit ADDITIONAL_CONFIG_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private static final List<String> OVERRIDABLE_SETTINGS = Arrays.asList("path.repo", "discovery.seed_providers", "cluster.deprecation_indexing.enabled", "cluster.initial_master_nodes", "xpack.security.enabled");
    private static final int TAIL_LOG_MESSAGES_COUNT = 40;
    private static final List<String> MESSAGES_WE_DONT_CARE_ABOUT = Arrays.asList("Option UseConcMarkSweepGC was deprecated", "is a pre-release version of Elasticsearch", "max virtual memory areas vm.max_map_count");
    private static final String HOSTNAME_OVERRIDE = "LinuxDarwinHostname";
    private static final String COMPUTERNAME_OVERRIDE = "WindowsComputername";
    private final String path;
    private final String name;
    private final transient Project project;
    private final Provider<ReaperService> reaperServiceProvider;
    private final FileSystemOperations fileSystemOperations;
    private final ArchiveOperations archiveOperations;
    private final ExecOperations execOperations;
    private final FileOperations fileOperations;
    private final AtomicBoolean configurationFrozen = new AtomicBoolean(false);
    private final Path workingDir;
    private final LinkedHashMap<String, Predicate<TestClusterConfiguration>> waitConditions = new LinkedHashMap();
    private final List<Provider<File>> plugins = new ArrayList<Provider<File>>();
    private final List<Provider<File>> modules = new ArrayList<Provider<File>>();
    private final LazyPropertyMap<String, CharSequence> settings = new LazyPropertyMap("Settings", this);
    private final LazyPropertyMap<String, CharSequence> keystoreSettings = new LazyPropertyMap("Keystore", this);
    private final LazyPropertyMap<String, File> keystoreFiles = new LazyPropertyMap<String, File>("Keystore files", this, FileEntry::new);
    private final LazyPropertyList<CliEntry> cliSetup = new LazyPropertyList("CLI setup commands", this);
    private final LazyPropertyMap<String, CharSequence> systemProperties = new LazyPropertyMap("System properties", this);
    private final LazyPropertyMap<String, CharSequence> environment = new LazyPropertyMap("Environment", this);
    private final LazyPropertyList<CharSequence> jvmArgs = new LazyPropertyList("JVM arguments", this);
    private final LazyPropertyList<CharSequence> cliJvmArgs = new LazyPropertyList("CLI JVM arguments", this);
    private final LazyPropertyMap<String, File> extraConfigFiles = new LazyPropertyMap<String, File>("Extra config files", this, FileEntry::new);
    private final LazyPropertyList<FileCollection> extraJarConfigurations = new LazyPropertyList("Extra jar files", this);
    private final List<Map<String, String>> credentials = new ArrayList<Map<String, String>>();
    private final List<File> roleFiles = new ArrayList<File>();
    private final List<FeatureFlag> featureFlags = new ArrayList<FeatureFlag>();
    final LinkedHashMap<String, String> defaultConfig = new LinkedHashMap();
    private final Path confPathRepo;
    private final Path configFile;
    private final Path confPathLogs;
    private final Path transportPortFile;
    private final Path httpPortsFile;
    private final Path readinessPortsFile;
    private final Path remoteAccessPortsFile;
    private final Path esOutputFile;
    private final Path esInputFile;
    private final Path tmpDir;
    private final Provider<File> runtimeJava;
    private final Function<Version, Boolean> isReleasedVersion;
    private final List<ElasticsearchDistribution> distributions = new ArrayList<ElasticsearchDistribution>();
    private int currentDistro = 0;
    private TestDistribution testDistribution;
    private volatile Process esProcess;
    private Function<String, String> nameCustomization = s -> s;
    private boolean isWorkingDirConfigured = false;
    private String httpPort = "0";
    private String transportPort = "0";
    private Path confPathData;
    private String keystorePassword = "";
    private boolean preserveDataDir = false;
    private static final int RETRY_DELETE_MILLIS = OS.current() == OS.WINDOWS ? 500 : 0;
    private static final int MAX_RETRY_DELETE_TIMES = OS.current() == OS.WINDOWS ? 15 : 0;

    ElasticsearchNode(String clusterName, String path, String name, Project project, Provider<ReaperService> reaperServiceProvider, FileSystemOperations fileSystemOperations, ArchiveOperations archiveOperations, ExecOperations execOperations, FileOperations fileOperations, File workingDirBase, Provider<File> runtimeJava, Function<Version, Boolean> isReleasedVersion) {
        this.path = path;
        this.name = name;
        this.project = project;
        this.reaperServiceProvider = reaperServiceProvider;
        this.fileSystemOperations = fileSystemOperations;
        this.archiveOperations = archiveOperations;
        this.execOperations = execOperations;
        this.fileOperations = fileOperations;
        this.runtimeJava = runtimeJava;
        this.isReleasedVersion = isReleasedVersion;
        this.workingDir = workingDirBase.toPath().resolve(this.safeName(name)).toAbsolutePath();
        this.confPathRepo = this.workingDir.resolve("repo");
        this.configFile = this.workingDir.resolve("config/elasticsearch.yml");
        this.confPathData = this.workingDir.resolve("data");
        this.confPathLogs = this.workingDir.resolve("logs");
        this.transportPortFile = this.confPathLogs.resolve("transport.ports");
        this.httpPortsFile = this.confPathLogs.resolve("http.ports");
        this.readinessPortsFile = this.confPathLogs.resolve("readiness.ports");
        this.remoteAccessPortsFile = this.confPathLogs.resolve("remote_cluster.ports");
        this.esOutputFile = this.confPathLogs.resolve("es.out");
        this.esInputFile = this.workingDir.resolve("es.in");
        this.tmpDir = this.workingDir.resolve("tmp");
        this.waitConditions.put("ports files", this::checkPortsFilesExistWithDelay);
        this.defaultConfig.put("cluster.name", clusterName);
        this.setTestDistribution(TestDistribution.INTEG_TEST);
        this.setVersion(VersionProperties.getElasticsearch());
    }

    @Input
    @Optional
    public String getName() {
        return this.nameCustomization.apply(this.name);
    }

    @Internal
    public Version getVersion() {
        return Version.fromString(this.distributions.get(this.currentDistro).getVersion());
    }

    @Override
    public void setVersion(String version) {
        Objects.requireNonNull(version, "null version passed when configuring test cluster `" + this + "`");
        this.checkFrozen();
        this.distributions.clear();
        this.doSetVersion(version);
    }

    @Override
    public void setVersions(List<String> versions) {
        Objects.requireNonNull(versions, "null version list passed when configuring test cluster `" + this + "`");
        this.distributions.clear();
        for (String version : versions) {
            this.doSetVersion(version);
        }
    }

    private void doSetVersion(String version) {
        String distroName = "testclusters" + this.path.replace(":", "-") + "-" + this.name + "-" + version;
        NamedDomainObjectContainer<ElasticsearchDistribution> container = DistributionDownloadPlugin.getContainer(this.project);
        if (container.findByName(distroName) == null) {
            container.create(distroName);
        }
        ElasticsearchDistribution distro = (ElasticsearchDistribution)container.getByName(distroName);
        distro.setVersion(version);
        distro.setArchitecture(Architecture.current());
        this.setDistributionType(distro, this.testDistribution);
        this.distributions.add(distro);
    }

    @Internal
    public TestDistribution getTestDistribution() {
        return this.testDistribution;
    }

    @Internal
    List<ElasticsearchDistribution> getDistributions() {
        return this.distributions;
    }

    @Override
    public void setTestDistribution(TestDistribution testDistribution) {
        Objects.requireNonNull(testDistribution, "null distribution passed when configuring test cluster `" + this + "`");
        this.checkFrozen();
        this.testDistribution = testDistribution;
        for (ElasticsearchDistribution distribution : this.distributions) {
            this.setDistributionType(distribution, testDistribution);
        }
    }

    private void setDistributionType(ElasticsearchDistribution distribution, TestDistribution testDistribution) {
        if (testDistribution == TestDistribution.INTEG_TEST) {
            distribution.setType(ElasticsearchDistributionTypes.INTEG_TEST_ZIP);
            distribution.setPlatform(null);
            distribution.setBundledJdk(null);
        } else {
            distribution.setType(ElasticsearchDistributionTypes.ARCHIVE);
        }
    }

    @Override
    public void plugin(Provider<RegularFile> plugin) {
        this.checkFrozen();
        this.plugins.add((Provider<File>)plugin.map(RegularFile::getAsFile));
    }

    @Override
    public void plugin(String pluginProjectPath) {
        throw new UnsupportedOperationException("Not Supported API");
    }

    @Override
    public void plugin(TaskProvider<Zip> plugin) {
        throw new UnsupportedOperationException("Not Supported API");
    }

    @Override
    public void module(Provider<RegularFile> module) {
        this.checkFrozen();
        this.modules.add((Provider<File>)module.map(RegularFile::getAsFile));
    }

    @Override
    public void module(TaskProvider<Sync> module) {
        throw new IllegalStateException("Not Supported API");
    }

    @Override
    public void module(String moduleProjectPath) {
        throw new IllegalStateException("Not Supported API");
    }

    @Override
    public void keystore(String key, String value) {
        this.keystoreSettings.put(key, value);
    }

    @Override
    public void keystore(String key, Supplier<CharSequence> valueSupplier) {
        this.keystoreSettings.put(key, valueSupplier);
    }

    @Override
    public void keystore(String key, File value) {
        this.keystoreFiles.put(key, value);
    }

    @Override
    public void keystore(String key, File value, PropertyNormalization normalization) {
        this.keystoreFiles.put(key, value, normalization);
    }

    @Override
    public void keystore(String key, FileSupplier valueSupplier) {
        this.keystoreFiles.put(key, valueSupplier);
    }

    @Override
    public void keystorePassword(String password) {
        this.keystorePassword = password;
    }

    @Override
    public void cliSetup(String binTool, CharSequence ... args) {
        this.cliSetup.add(new CliEntry(binTool, args));
    }

    @Override
    public void setting(String key, String value) {
        this.settings.put(key, value);
    }

    @Override
    public void setting(String key, String value, PropertyNormalization normalization) {
        this.settings.put(key, value, normalization);
    }

    @Override
    public void setting(String key, Supplier<CharSequence> valueSupplier) {
        this.settings.put(key, valueSupplier);
    }

    @Override
    public void setting(String key, Supplier<CharSequence> valueSupplier, PropertyNormalization normalization) {
        this.settings.put(key, valueSupplier, normalization);
    }

    @Override
    public void systemProperty(String key, String value) {
        this.systemProperties.put(key, value);
    }

    @Override
    public void systemProperty(String key, Supplier<CharSequence> valueSupplier) {
        this.systemProperties.put(key, valueSupplier);
    }

    @Override
    public void systemProperty(String key, Supplier<CharSequence> valueSupplier, PropertyNormalization normalization) {
        this.systemProperties.put(key, valueSupplier, normalization);
    }

    @Override
    public void environment(String key, String value) {
        this.environment.put(key, value);
    }

    @Override
    public void environment(String key, Supplier<CharSequence> valueSupplier) {
        this.environment.put(key, valueSupplier);
    }

    @Override
    public void environment(String key, Supplier<CharSequence> valueSupplier, PropertyNormalization normalization) {
        this.environment.put(key, valueSupplier, normalization);
    }

    @Override
    public void jvmArgs(String ... values) {
        this.jvmArgs.addAll((Collection<CharSequence>)Arrays.asList(values));
    }

    public void cliJvmArgs(String ... values) {
        this.cliJvmArgs.addAll((Collection<CharSequence>)Arrays.asList(values));
    }

    @Internal
    public Path getConfigDir() {
        return this.configFile.getParent();
    }

    @Override
    @Input
    public boolean isPreserveDataDir() {
        return this.preserveDataDir;
    }

    @Override
    public void setPreserveDataDir(boolean preserveDataDir) {
        this.preserveDataDir = preserveDataDir;
    }

    @Override
    public void freeze() {
        Objects.requireNonNull(this.testDistribution, "null testDistribution passed when configuring test cluster `" + this + "`");
        LOGGER.info("Locking configuration of `{}`", (Object)this);
        this.distributions.forEach(ElasticsearchDistribution::maybeFreeze);
        this.configurationFrozen.set(true);
    }

    private static String throwableToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    @Override
    public synchronized void start() {
        LOGGER.info("Starting `{}`", (Object)this);
        if (!Files.exists(this.getExtractedDistributionDir(), new LinkOption[0])) {
            throw new TestClustersException("Can not start " + this + ", missing: " + this.getExtractedDistributionDir());
        }
        if (!Files.isDirectory(this.getExtractedDistributionDir(), new LinkOption[0])) {
            throw new TestClustersException("Can not start " + this + ", is not a directory: " + this.getExtractedDistributionDir());
        }
        try {
            if (!this.isWorkingDirConfigured) {
                this.logToProcessStdout("Configuring working directory: " + this.workingDir);
                if (Files.exists(this.workingDir, new LinkOption[0])) {
                    if (this.preserveDataDir) {
                        try (Stream<Path> files = Files.list(this.workingDir);){
                            files.filter(path -> !path.equals(this.confPathData)).forEach(this::uncheckedDeleteWithRetry);
                        }
                    } else {
                        this.deleteWithRetry(this.workingDir);
                    }
                }
                this.isWorkingDirConfigured = true;
            }
            this.setupNodeDistribution(this.getExtractedDistributionDir());
            this.createWorkingDir();
        }
        catch (IOException e) {
            String string = "Failed to create working directory for " + this + ", with: " + e + ElasticsearchNode.throwableToString(e);
            this.logToProcessStdout(string);
            throw new UncheckedIOException(string, e);
        }
        catch (org.gradle.api.UncheckedIOException e) {
            String string = "Failed to create working directory for " + this + ", with: " + e + ElasticsearchNode.throwableToString(e);
            this.logToProcessStdout(string);
            throw e;
        }
        this.copyExtraJars();
        this.copyExtraConfigFiles();
        this.createConfiguration();
        if (!this.plugins.isEmpty()) {
            if (this.getVersion().onOrAfter("7.6.0")) {
                this.logToProcessStdout("installing " + this.plugins.size() + " plugins in a single transaction");
                CharSequence[] arguments = (String[])Stream.concat(Stream.of("install", "--batch"), this.plugins.stream().map(Provider::get).map(p -> p.toURI().toString())).toArray(String[]::new);
                this.runElasticsearchBinScript("elasticsearch-plugin", arguments);
            } else {
                this.logToProcessStdout("installing " + this.plugins.size() + " plugins sequentially");
                this.plugins.forEach(plugin -> this.runElasticsearchBinScript("elasticsearch-plugin", "install", "--batch", plugin.toString()));
            }
            this.logToProcessStdout("installed plugins");
        }
        this.logToProcessStdout("Creating elasticsearch keystore with password set to [" + this.keystorePassword + "]");
        if (this.keystorePassword.length() > 0) {
            this.runElasticsearchBinScriptWithInput(this.keystorePassword + "\n" + this.keystorePassword, "elasticsearch-keystore", "create", "-p");
        } else {
            this.runElasticsearchBinScript("elasticsearch-keystore", "-v", "create");
        }
        if (!this.keystoreSettings.isEmpty() || !this.keystoreFiles.isEmpty()) {
            this.logToProcessStdout("Adding " + this.keystoreSettings.size() + " keystore settings and " + this.keystoreFiles.size() + " keystore files");
            this.keystoreSettings.forEach((key, value) -> this.runKeystoreCommandWithPassword(this.keystorePassword, value.toString(), "add", (CharSequence)key));
            for (Map.Entry<String, File> entry : this.keystoreFiles.entrySet()) {
                File file = entry.getValue();
                Objects.requireNonNull(file, "supplied keystoreFile was null when configuring " + this);
                if (!file.exists()) {
                    throw new TestClustersException("supplied keystore file " + file + " does not exist, require for " + this);
                }
                this.runKeystoreCommandWithPassword(this.keystorePassword, "", "add-file", entry.getKey(), file.getAbsolutePath());
            }
        }
        this.installModules();
        if (this.isSettingTrue("xpack.security.enabled") && this.credentials.isEmpty()) {
            this.user(Collections.emptyMap());
        }
        this.configureSecurity();
        if (!this.cliSetup.isEmpty()) {
            this.logToProcessStdout("Running " + this.cliSetup.size() + " setup commands");
            for (CliEntry cliEntry : this.cliSetup) {
                this.runElasticsearchBinScript(cliEntry.executable, cliEntry.args);
            }
        }
        this.logToProcessStdout("Starting Elasticsearch process");
        this.startElasticsearchProcess();
    }

    private boolean canUseSharedDistribution() {
        return OS.current() != OS.WINDOWS && this.extraJarConfigurations.size() == 0 && this.modules.size() == 0 && this.plugins.size() == 0;
    }

    private void logToProcessStdout(String message) {
        try {
            if (!Files.exists(this.esOutputFile.getParent(), new LinkOption[0])) {
                Files.createDirectories(this.esOutputFile.getParent(), new FileAttribute[0]);
            }
            Files.writeString(this.esOutputFile, (CharSequence)("[" + Instant.now().toString() + "] [BUILD] " + message + "\n"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void restart() {
        LOGGER.info("Restarting {}", (Object)this);
        this.stop(false);
        this.start();
    }

    void goToNextVersion() {
        if (this.currentDistro + 1 >= this.distributions.size()) {
            throw new TestClustersException("Ran out of versions to go to for " + this);
        }
        this.logToProcessStdout("Switch version from " + this.getVersion() + " to " + this.distributions.get(this.currentDistro + 1).getVersion());
        ++this.currentDistro;
        this.setting("node.attr.upgraded", "true");
    }

    private boolean isSettingTrue(String name) {
        return Boolean.parseBoolean(this.settings.getOrDefault(name, "false").toString());
    }

    private void copyExtraConfigFiles() {
        if (!this.extraConfigFiles.isEmpty()) {
            this.logToProcessStdout("Setting up " + this.extraConfigFiles.size() + " additional config files");
        }
        this.extraConfigFiles.forEach((destination, from) -> {
            if (!Files.exists(from.toPath(), new LinkOption[0])) {
                throw new TestClustersException("Can't create extra config file from " + from + " for " + this + " as it does not exist");
            }
            Path dst = this.configFile.getParent().resolve((String)destination);
            try {
                Files.createDirectories(dst.getParent(), new FileAttribute[0]);
                Files.copy(from.toPath(), dst, StandardCopyOption.REPLACE_EXISTING);
                LOGGER.info("Added extra config file {} for {}", destination, (Object)this);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Can't create extra config file for", e);
            }
        });
    }

    private void copyExtraJars() {
        List extraJarFiles = this.extraJarConfigurations.stream().flatMap(fileCollection -> fileCollection.getFiles().stream()).toList();
        if (!extraJarFiles.isEmpty()) {
            this.logToProcessStdout("Setting up " + this.extraJarConfigurations.size() + " additional jar dependencies");
        }
        extraJarFiles.forEach(from -> {
            if (!from.getName().endsWith(".jar")) {
                throw new IllegalArgumentException("extra jar file " + from + " doesn't appear to be a JAR");
            }
            Path destination = this.getDistroDir().resolve("lib").resolve(from.getName());
            try {
                Files.copy(from.toPath(), destination, StandardCopyOption.REPLACE_EXISTING);
                LOGGER.info("Added extra jar {} to {}", (Object)from.getName(), (Object)destination);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Can't copy extra jar dependency " + from.getName() + " to " + destination, e);
            }
        });
    }

    private void configureSecurity() {
        if (!this.credentials.isEmpty()) {
            this.logToProcessStdout("Setting up " + this.credentials.size() + " users");
            this.credentials.forEach(paramMap -> this.runElasticsearchBinScript(this.getVersion().onOrAfter("6.3.0") ? "elasticsearch-users" : "x-pack/users", (CharSequence[])paramMap.entrySet().stream().flatMap(entry -> Stream.of((String)entry.getKey(), (String)entry.getValue())).toArray(String[]::new)));
            this.rolesFile(this.getBuildPluginFile("/roles.yml"));
        }
        if (!this.roleFiles.isEmpty()) {
            this.logToProcessStdout("Setting up roles.yml");
            Path dst = this.configFile.getParent().resolve("roles.yml");
            this.roleFiles.forEach(from -> {
                if (!Files.exists(from.toPath(), new LinkOption[0])) {
                    throw new TestClustersException("Can't create roles.yml config file from " + from + " for " + this + " as it does not exist");
                }
                try {
                    Path source = from.toPath();
                    String content = Files.readString(source, StandardCharsets.UTF_8);
                    Files.writeString(dst, (CharSequence)(content + System.lineSeparator()), StandardCharsets.UTF_8, StandardOpenOption.APPEND);
                    LOGGER.info("Appended roles file {} to {}", (Object)source, (Object)dst);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Can't append roles file " + from + " to " + dst, e);
                }
            });
        }
    }

    private void installModules() {
        this.logToProcessStdout("Installing " + this.modules.size() + " modules");
        for (Provider<File> module : this.modules) {
            Path destination = this.getDistroDir().resolve("modules").resolve(((File)module.get()).getName().replace(".zip", "").replace("-" + this.getVersion(), "").replace("-SNAPSHOT", ""));
            if (Files.exists(destination, new LinkOption[0])) continue;
            this.fileSystemOperations.copy(spec -> {
                if (((File)module.get()).getName().toLowerCase().endsWith(".zip")) {
                    spec.from(new Object[]{this.archiveOperations.zipTree((Object)module)});
                } else if (((File)module.get()).isDirectory()) {
                    spec.from(new Object[]{module});
                } else {
                    throw new IllegalArgumentException("Not a valid module " + module + " for " + this);
                }
                spec.into((Object)destination);
            });
        }
    }

    @Override
    public void extraConfigFile(String destination, File from) {
        if (destination.contains("..")) {
            throw new IllegalArgumentException("extra config file destination can't be relative, was " + destination + " for " + this);
        }
        this.extraConfigFiles.put(destination, from);
    }

    @Override
    public void extraConfigFile(String destination, File from, PropertyNormalization normalization) {
        if (destination.contains("..")) {
            throw new IllegalArgumentException("extra config file destination can't be relative, was " + destination + " for " + this);
        }
        this.extraConfigFiles.put(destination, from, normalization);
    }

    @Override
    public void extraJarFiles(FileCollection from) {
        this.extraJarConfigurations.add(from);
    }

    @Override
    public void user(Map<String, String> userSpec) {
        HashSet<String> keys = new HashSet<String>(userSpec.keySet());
        keys.remove("username");
        keys.remove("password");
        keys.remove("role");
        if (!keys.isEmpty()) {
            throw new TestClustersException("Unknown keys in user definition " + keys + " for " + this);
        }
        LinkedHashMap<String, String> cred = new LinkedHashMap<String, String>();
        cred.put("useradd", userSpec.getOrDefault("username", "test_user"));
        cred.put("-p", userSpec.getOrDefault("password", "x-pack-test-password"));
        cred.put("-r", userSpec.getOrDefault("role", "_es_test_root"));
        this.credentials.add(cred);
    }

    private File getBuildPluginFile(String name) {
        URL resource = this.getClass().getResource(name);
        return this.fileOperations.getResources().getText().fromUri((Object)resource).asFile();
    }

    @Override
    public void rolesFile(File rolesYml) {
        this.roleFiles.add(rolesYml);
    }

    @Override
    public void requiresFeature(String feature, Version from) {
        this.featureFlags.add(new FeatureFlag(feature, from, null));
    }

    @Override
    public void requiresFeature(String feature, Version from, Version until) {
        this.featureFlags.add(new FeatureFlag(feature, from, until));
    }

    private void runElasticsearchBinScriptWithInput(String input, String tool, CharSequence ... args) {
        if (!Files.exists(this.getDistroDir().resolve("bin").resolve(tool), new LinkOption[0]) && !Files.exists(this.getDistroDir().resolve("bin").resolve(tool + ".bat"), new LinkOption[0])) {
            throw new TestClustersException("Can't run bin script: `" + tool + "` does not exist. Is this the distribution you expect it to be ?");
        }
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));){
            LoggedExec.exec(this.execOperations, (Action<ExecSpec>)((Action)spec -> {
                spec.setEnvironment(this.getESEnvironment());
                spec.workingDir((Object)this.getDistroDir());
                spec.executable((Object)OS.conditionalString().onUnix(() -> "./bin/" + tool).onWindows(() -> "cmd").supply());
                spec.args((Iterable)OS.conditional().onWindows(() -> {
                    ArrayList<Object> result = new ArrayList<Object>();
                    result.add("/c");
                    result.add("bin\\" + tool + ".bat");
                    Collections.addAll(result, args);
                    return result;
                }).onUnix(() -> Arrays.asList(args)).supply());
                spec.setStandardInput(byteArrayInputStream);
            }));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to run " + tool + " for " + this, e);
        }
    }

    private void runKeystoreCommandWithPassword(String keystorePassword, String input, CharSequence ... args) {
        String actualInput = keystorePassword.length() > 0 ? keystorePassword + "\n" + input : input;
        this.runElasticsearchBinScriptWithInput(actualInput, "elasticsearch-keystore", args);
    }

    private void runElasticsearchBinScript(String tool, CharSequence ... args) {
        this.runElasticsearchBinScriptWithInput("", tool, args);
    }

    private Map<String, String> getESEnvironment() {
        HashMap<String, String> defaultEnv = new HashMap<String, String>();
        if (this.getTestDistribution() == TestDistribution.INTEG_TEST || this.getVersion().equals(VersionProperties.getElasticsearchVersion())) {
            defaultEnv.put("ES_JAVA_HOME", ((File)this.runtimeJava.get()).getAbsolutePath());
        }
        defaultEnv.put("ES_PATH_CONF", this.configFile.getParent().toString());
        Object systemPropertiesString = "";
        if (!this.systemProperties.isEmpty()) {
            systemPropertiesString = " " + this.systemProperties.entrySet().stream().peek(entry -> {
                if (((String)entry.getKey()).contains("feature_flag")) {
                    throw new TestClustersException("Invalid system property `" + (String)entry.getKey() + "`. Use `requiresFeature` instead.");
                }
            }).map(entry -> "-D" + (String)entry.getKey() + "=" + entry.getValue()).map(p -> p.replace("${ES_PATH_CONF}", this.configFile.getParent().toString())).collect(Collectors.joining(" "));
        }
        if (!this.systemProperties.containsKey("io.netty.leakDetection.level")) {
            systemPropertiesString = (String)systemPropertiesString + " -Dio.netty.leakDetection.level=paranoid";
        }
        String featureFlagsString = "";
        if (!this.featureFlags.isEmpty() && this.isReleasedVersion.apply(this.getVersion()).booleanValue()) {
            featureFlagsString = this.featureFlags.stream().filter(f -> this.getVersion().onOrAfter(f.getFrom()) && (f.getUntil() == null || this.getVersion().before(f.getUntil()))).map(f -> "-D" + f.getFeature() + "=true").collect(Collectors.joining(" "));
        }
        Object jvmArgsString = "";
        if (!this.jvmArgs.isEmpty()) {
            jvmArgsString = " " + this.jvmArgs.stream().peek(argument -> {
                if (argument.toString().startsWith("-D")) {
                    throw new TestClustersException("Invalid jvm argument `" + argument + "` configure as systemProperty instead for " + this);
                }
            }).collect(Collectors.joining(" "));
        }
        String heapSize = System.getProperty("tests.heap.size", "512m");
        defaultEnv.put("ES_JAVA_OPTS", "-Xms" + heapSize + " -Xmx" + heapSize + " -ea -esa " + (String)systemPropertiesString + " " + featureFlagsString + " " + (String)jvmArgsString + " " + System.getProperty("tests.jvm.argline", ""));
        defaultEnv.put("ES_TMPDIR", this.tmpDir.toString());
        defaultEnv.put("TMP", this.tmpDir.toString());
        defaultEnv.put("HOSTNAME", HOSTNAME_OVERRIDE);
        defaultEnv.put("COMPUTERNAME", COMPUTERNAME_OVERRIDE);
        HashSet<String> commonKeys = new HashSet<String>(this.environment.keySet());
        commonKeys.retainAll(defaultEnv.keySet());
        if (!commonKeys.isEmpty()) {
            throw new IllegalStateException("testcluster does not allow overwriting the following env vars " + commonKeys + " for " + this);
        }
        this.environment.forEach((key, value) -> defaultEnv.put((String)key, value.toString()));
        return defaultEnv;
    }

    private void startElasticsearchProcess() {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        Path effectiveDistroDir = this.getDistroDir();
        List command = OS.conditional().onUnix(() -> List.of(effectiveDistroDir.resolve("./bin/elasticsearch").toString())).onWindows(() -> Arrays.asList("cmd", "/c", effectiveDistroDir.resolve("bin\\elasticsearch.bat").toString())).supply();
        processBuilder.command(command);
        processBuilder.directory(this.workingDir.toFile());
        Map<String, String> environment = processBuilder.environment();
        environment.clear();
        environment.putAll(this.getESEnvironment());
        if (!this.cliJvmArgs.isEmpty()) {
            String cliJvmArgsString = String.join((CharSequence)" ", this.cliJvmArgs);
            environment.put("CLI_JAVA_OPTS", cliJvmArgsString);
        }
        processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(this.esOutputFile.toFile()));
        processBuilder.redirectErrorStream(true);
        if (this.keystorePassword != null && this.keystorePassword.length() > 0) {
            try {
                Files.writeString(this.esInputFile, (CharSequence)(this.keystorePassword + "\n"), StandardOpenOption.CREATE);
                processBuilder.redirectInput(this.esInputFile.toFile());
            }
            catch (IOException e) {
                throw new TestClustersException("Failed to set the keystore password for " + this, e);
            }
        }
        LOGGER.info("Running `{}` in `{}` for {} env: {}", new Object[]{command, this.workingDir, this, environment});
        try {
            this.esProcess = processBuilder.start();
        }
        catch (IOException e) {
            throw new TestClustersException("Failed to start ES process for " + this, e);
        }
        ((ReaperService)this.reaperServiceProvider.get()).registerPid(this.toString(), this.esProcess.pid());
    }

    @Internal
    public Path getDistroDir() {
        return this.canUseSharedDistribution() ? this.getExtractedDistributionDir().toFile().listFiles()[0].toPath() : this.workingDir.resolve("distro").resolve(this.getVersion() + "-" + this.testDistribution);
    }

    @Override
    @Internal
    public String getHttpSocketURI() {
        return this.getHttpPortInternal().get(0);
    }

    @Override
    @Internal
    public String getTransportPortURI() {
        return this.getTransportPortInternal().get(0);
    }

    @Override
    @Internal
    public String getReadinessPortURI() {
        return this.getReadinessPortInternal().get(0);
    }

    @Override
    @Internal
    public List<String> getAllHttpSocketURI() {
        this.waitForAllConditions();
        return this.getHttpPortInternal();
    }

    @Override
    @Internal
    public List<String> getAllTransportPortURI() {
        this.waitForAllConditions();
        return this.getTransportPortInternal();
    }

    @Override
    @Internal
    public List<String> getAllReadinessPortURI() {
        this.waitForAllConditions();
        return this.getReadinessPortInternal();
    }

    @Override
    @Internal
    public List<String> getAllRemoteAccessPortURI() {
        this.waitForAllConditions();
        return this.getRemoteAccessPortInternal();
    }

    @Internal
    public File getServerLog() {
        return this.confPathLogs.resolve(this.defaultConfig.get("cluster.name") + "_server.json").toFile();
    }

    @Internal
    public File getAuditLog() {
        return this.confPathLogs.resolve(this.defaultConfig.get("cluster.name") + "_audit.json").toFile();
    }

    @Override
    public synchronized void stop(boolean tailLogs) {
        this.logToProcessStdout("Stopping node");
        try {
            if (Files.exists(this.httpPortsFile, new LinkOption[0])) {
                Files.delete(this.httpPortsFile);
            }
            if (Files.exists(this.transportPortFile, new LinkOption[0])) {
                Files.delete(this.transportPortFile);
            }
            if (Files.exists(this.readinessPortsFile, new LinkOption[0])) {
                Files.delete(this.readinessPortsFile);
            }
            if (Files.exists(this.remoteAccessPortsFile, new LinkOption[0])) {
                Files.delete(this.remoteAccessPortsFile);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (this.esProcess == null && tailLogs) {
            return;
        }
        LOGGER.info("Stopping `{}`, tailLogs: {}", (Object)this, (Object)tailLogs);
        Objects.requireNonNull(this.esProcess, "Can't stop `" + this + "` as it was not started or already stopped.");
        this.stopHandle(this.esProcess.toHandle(), true);
        ((ReaperService)this.reaperServiceProvider.get()).unregister(this.toString());
        this.esProcess = null;
        try {
            if (Files.exists(this.httpPortsFile, new LinkOption[0])) {
                Files.delete(this.httpPortsFile);
            }
            if (Files.exists(this.transportPortFile, new LinkOption[0])) {
                Files.delete(this.transportPortFile);
            }
            if (Files.exists(this.readinessPortsFile, new LinkOption[0])) {
                Files.delete(this.readinessPortsFile);
            }
            if (Files.exists(this.remoteAccessPortsFile, new LinkOption[0])) {
                Files.delete(this.remoteAccessPortsFile);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.logFileContents("Log output of node", this.esOutputFile, tailLogs);
    }

    @Override
    public void setNameCustomization(Function<String, String> nameCustomizer) {
        this.nameCustomization = nameCustomizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopHandle(ProcessHandle processHandle, boolean forcibly) {
        if (!processHandle.isAlive()) {
            LOGGER.info("Process was not running when we tried to terminate it.");
            return;
        }
        List<ProcessHandle> children = processHandle.children().toList();
        try {
            this.logProcessInfo("Terminating elasticsearch process" + (forcibly ? " forcibly " : "gracefully") + ":", processHandle.info());
            if (forcibly) {
                processHandle.destroyForcibly();
            } else {
                processHandle.destroy();
                this.waitForProcessToExit(processHandle);
                if (!processHandle.isAlive()) {
                    return;
                }
                LOGGER.info("process did not terminate after {} {}, stopping it forcefully", (Object)20, (Object)ES_DESTROY_TIMEOUT_UNIT);
                processHandle.destroyForcibly();
            }
            this.waitForProcessToExit(processHandle);
            if (processHandle.isAlive()) {
                throw new TestClustersException("Was not able to terminate elasticsearch process for " + this);
            }
        }
        finally {
            children.forEach(each -> this.stopHandle((ProcessHandle)each, forcibly));
        }
    }

    private void logProcessInfo(String prefix, ProcessHandle.Info info) {
        LOGGER.info(prefix + " commandLine:`{}` command:`{}` args:`{}`", new Object[]{info.commandLine().orElse("-"), info.command().orElse("-"), Arrays.stream(info.arguments().orElse(new String[0])).map(each -> "'" + each + "'").collect(Collectors.joining(" "))});
    }

    private void logFileContents(String description, Path from, boolean tailLogs) {
        LinkedHashMap<String, Pair> errorsAndWarnings = new LinkedHashMap<String, Pair>();
        LinkedList<String> ring = new LinkedList<String>();
        try (LineNumberReader reader = new LineNumberReader(Files.newBufferedReader(from));){
            String line2 = reader.readLine();
            while (line2 != null) {
                Object lineToAdd;
                if (ring.isEmpty()) {
                    lineToAdd = line2;
                } else if (line2.startsWith("[")) {
                    lineToAdd = line2;
                    String normalizedMessage = this.normalizeLogLine((String)ring.getLast());
                    if (MESSAGES_WE_DONT_CARE_ABOUT.stream().noneMatch(normalizedMessage::contains) && (normalizedMessage.contains("ERROR") || normalizedMessage.contains("WARN"))) {
                        errorsAndWarnings.put(normalizedMessage, Pair.of((String)ring.getLast(), java.util.Optional.ofNullable((Pair)errorsAndWarnings.get(normalizedMessage)).map(p -> (Integer)p.right() + 1).orElse(1)));
                    }
                } else {
                    lineToAdd = (String)ring.removeLast() + "\n" + line2;
                }
                ring.add((String)lineToAdd);
                if (ring.size() >= 40) {
                    ring.removeFirst();
                }
                line2 = reader.readLine();
            }
        }
        catch (IOException e) {
            if (tailLogs) {
                throw new UncheckedIOException("Failed to tail log " + this, e);
            }
            return;
        }
        boolean foundNettyLeaks = false;
        for (String logLine : errorsAndWarnings.keySet()) {
            if (!logLine.contains("ResourceLeakDetector]")) continue;
            tailLogs = true;
            foundNettyLeaks = true;
            break;
        }
        if (tailLogs) {
            if (!errorsAndWarnings.isEmpty() || !ring.isEmpty()) {
                LOGGER.lifecycle("\n=== {} `{}` ===", new Object[]{description, this});
            }
            if (!errorsAndWarnings.isEmpty()) {
                LOGGER.lifecycle("\n\u00bb    \u2193 errors and warnings from " + from + " \u2193");
                errorsAndWarnings.forEach((key, pair) -> {
                    LOGGER.lifecycle("\u00bb " + ((String)pair.left()).replace("\n", "\n\u00bb  "));
                    if ((Integer)pair.right() > 1) {
                        LOGGER.lifecycle("\u00bb   \u2191 repeated " + pair.right() + " times \u2191");
                    }
                });
            }
            ring.removeIf(line -> MESSAGES_WE_DONT_CARE_ABOUT.stream().anyMatch(line::contains));
            if (!ring.isEmpty()) {
                LOGGER.lifecycle("\u00bb   \u2193 last 40 non error or warning messages from " + from + " \u2193");
                ring.forEach(message -> {
                    if (!errorsAndWarnings.containsKey(this.normalizeLogLine((String)message))) {
                        LOGGER.lifecycle("\u00bb " + message.replace("\n", "\n\u00bb  "));
                    }
                });
            }
        }
        if (foundNettyLeaks) {
            throw new TestClustersException("Found Netty ByteBuf leaks in node logs.");
        }
    }

    private String normalizeLogLine(String line) {
        if (line.contains("ERROR")) {
            return line.substring(line.indexOf("ERROR"));
        }
        if (line.contains("WARN")) {
            return line.substring(line.indexOf("WARN"));
        }
        return line;
    }

    private void waitForProcessToExit(ProcessHandle processHandle) {
        try {
            processHandle.onExit().get(20L, ES_DESTROY_TIMEOUT_UNIT);
        }
        catch (InterruptedException e) {
            LOGGER.info("[{}] Interrupted while waiting for ES process", (Object)this.name, (Object)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOGGER.info("[{}] Failure while waiting for process to exist", (Object)this.name, (Object)e);
        }
        catch (TimeoutException e) {
            LOGGER.info("[{}] Timed out waiting for process to exit", (Object)this.name, (Object)e);
        }
    }

    void deleteWithRetry(Path path) throws IOException {
        try {
            this.deleteWithRetry0(path);
        }
        catch (InterruptedException x) {
            throw new IOException("Interrupted while deleting.", x);
        }
    }

    void uncheckedDeleteWithRetry(Path path) {
        try {
            this.deleteWithRetry0(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException x) {
            throw new UncheckedIOException("Interrupted while deleting.", new IOException());
        }
    }

    private void deleteWithRetry0(Path path) throws IOException, InterruptedException {
        int times = 0;
        Throwable ioe = null;
        while (true) {
            try {
                this.fileSystemOperations.delete(d -> d.delete(new Object[]{path}));
                ++times;
                while (!Files.notExists(path, new LinkOption[0])) {
                    if (times > MAX_RETRY_DELETE_TIMES) {
                        throw new IOException("File still exists after " + times + " waits.");
                    }
                    Thread.sleep(RETRY_DELETE_MILLIS);
                    this.fileSystemOperations.delete(d -> d.delete(new Object[]{path}));
                    ++times;
                }
            }
            catch (NoSuchFileException ignore) {
            }
            catch (IOException | org.gradle.api.UncheckedIOException x) {
                if (x.getCause() instanceof NoSuchFileException) break;
                ++times;
                if (ioe == null) {
                    ioe = new IOException();
                }
                ioe.addSuppressed(x);
                if (times > MAX_RETRY_DELETE_TIMES) {
                    throw ioe;
                }
                Thread.sleep(RETRY_DELETE_MILLIS);
                continue;
            }
            break;
        }
    }

    private void createWorkingDir() throws IOException {
        this.deleteWithRetry(this.configFile.getParent());
        Files.createDirectories(this.configFile.getParent(), new FileAttribute[0]);
        Files.createDirectories(this.confPathRepo, new FileAttribute[0]);
        Files.createDirectories(this.confPathData, new FileAttribute[0]);
        Files.createDirectories(this.confPathLogs, new FileAttribute[0]);
        Files.createDirectories(this.tmpDir, new FileAttribute[0]);
    }

    private void setupNodeDistribution(Path distroExtractDir) throws IOException {
        if (!this.canUseSharedDistribution()) {
            this.logToProcessStdout("Configuring custom cluster specific distro directory: " + this.getDistroDir());
            if (!Files.exists(this.getDistroDir(), new LinkOption[0])) {
                try {
                    this.syncWithLinks(distroExtractDir, this.getDistroDir());
                }
                catch (LinkCreationException e) {
                    LOGGER.info("Failed to create working dir using hard links. Falling back to copy", (Throwable)e);
                    FileUtils.deleteDirectory((File)this.getDistroDir().toFile());
                    this.syncWithCopy(distroExtractDir, this.getDistroDir());
                }
            }
        }
    }

    private void syncWithLinks(Path sourceRoot, Path destinationRoot) {
        this.sync(sourceRoot, destinationRoot, (d, s) -> {
            try {
                Files.createLink(d, s);
            }
            catch (IOException e) {
                throw new LinkCreationException("Failed to create hard link " + d + " pointing to " + s, e);
            }
        });
    }

    private void syncWithCopy(Path sourceRoot, Path destinationRoot) {
        this.sync(sourceRoot, destinationRoot, (d, s) -> {
            try {
                Files.copy(s, d, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to copy " + s + " to " + d, e);
            }
        });
    }

    private void sync(Path sourceRoot, Path destinationRoot, BiConsumer<Path, Path> syncMethod) {
        assert (!Files.exists(destinationRoot, new LinkOption[0]));
        try (Stream<Path> stream = Files.walk(sourceRoot, new FileVisitOption[0]);){
            stream.forEach(source -> {
                Path relativeDestination = sourceRoot.relativize((Path)source);
                if (relativeDestination.getNameCount() <= 1) {
                    return;
                }
                relativeDestination = relativeDestination.subpath(1, relativeDestination.getNameCount());
                Path destination = destinationRoot.resolve(relativeDestination);
                if (Files.isDirectory(source, new LinkOption[0])) {
                    try {
                        Files.createDirectories(destination, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Can't create directory " + destination.getParent(), e);
                    }
                }
                try {
                    Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Can't create directory " + destination.getParent(), e);
                }
                syncMethod.accept(destination, (Path)source);
            });
        }
        catch (UncheckedIOException e) {
            IOException iOException = e.getCause();
            if (iOException instanceof NoSuchFileException) {
                NoSuchFileException cause = (NoSuchFileException)iOException;
                if (cause.getFile() == null || !cause.getFile().contains(".attach_pid")) {
                    throw new UncheckedIOException(cause);
                }
            }
            throw e;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't walk source " + sourceRoot, e);
        }
    }

    private void createConfiguration() {
        String nodeName = this.nameCustomization.apply(this.safeName(this.name));
        HashMap<String, String> baseConfig = new HashMap<String, String>(this.defaultConfig);
        if (nodeName != null) {
            baseConfig.put("node.name", nodeName);
        }
        baseConfig.put("path.repo", this.confPathRepo.toAbsolutePath().toString());
        baseConfig.put("path.data", this.confPathData.toAbsolutePath().toString());
        baseConfig.put("path.logs", this.confPathLogs.toAbsolutePath().toString());
        baseConfig.put("node.attr.testattr", "test");
        baseConfig.put("node.portsfile", "true");
        baseConfig.put("http.port", this.httpPort);
        if (this.getVersion().onOrAfter(Version.fromString("6.7.0"))) {
            baseConfig.put("transport.port", this.transportPort);
        } else {
            baseConfig.put("transport.tcp.port", this.transportPort);
        }
        baseConfig.put("cluster.routing.allocation.disk.watermark.low", "1b");
        baseConfig.put("cluster.routing.allocation.disk.watermark.high", "1b");
        if (this.getVersion().onOrAfter("7.9.0")) {
            baseConfig.put("script.disable_max_compilations_rate", "true");
        } else {
            baseConfig.put("script.max_compilations_rate", "2048/1m");
        }
        if (this.getVersion().getMajor() >= 6) {
            baseConfig.put("cluster.routing.allocation.disk.watermark.flood_stage", "1b");
        }
        if (this.getVersion().getMajor() >= 7) {
            baseConfig.put("indices.breaker.total.use_real_memory", "false");
        }
        baseConfig.put("discovery.initial_state_timeout", "0s");
        if (this.getVersion().getMajor() >= 8) {
            baseConfig.put("cluster.service.slow_task_logging_threshold", "5s");
            baseConfig.put("cluster.service.slow_master_task_logging_threshold", "5s");
        }
        baseConfig.put("action.destructive_requires_name", "false");
        HashSet overriden = new HashSet(baseConfig.keySet());
        overriden.retainAll(this.settings.keySet());
        overriden.removeAll(OVERRIDABLE_SETTINGS);
        if (!overriden.isEmpty()) {
            throw new IllegalArgumentException("Testclusters does not allow the following settings to be changed:" + overriden + " for " + this);
        }
        this.settings.keySet().stream().filter(OVERRIDABLE_SETTINGS::contains).forEach(baseConfig::remove);
        Path configFileRoot = this.configFile.getParent();
        try {
            List configFiles;
            Files.writeString(this.configFile, (CharSequence)Stream.concat(this.settings.entrySet().stream(), baseConfig.entrySet().stream()).map(entry -> (String)entry.getKey() + ": " + entry.getValue()).collect(Collectors.joining("\n")), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            try (Stream<Path> stream = Files.list(this.getDistroDir().resolve("config"));){
                configFiles = stream.collect(Collectors.toList());
            }
            this.logToProcessStdout("Copying additional config files from distro " + configFiles);
            for (Path file : configFiles) {
                Path dest = this.configFile.getParent().resolve(file.getFileName());
                if (Files.exists(dest, new LinkOption[0])) continue;
                Files.copy(file, dest, new CopyOption[0]);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not write config file: " + this.configFile, e);
        }
        this.tweakJvmOptions(configFileRoot);
        LOGGER.info("Written config file:{} for {}", (Object)this.configFile, (Object)this);
    }

    private void tweakJvmOptions(Path configFileRoot) {
        LOGGER.info("Tweak jvm options {}.", (Object)configFileRoot.resolve("jvm.options"));
        Path jvmOptions = configFileRoot.resolve("jvm.options");
        try {
            String content = new String(Files.readAllBytes(jvmOptions));
            Map<String, String> expansions = this.jvmOptionExpansions();
            for (String origin : expansions.keySet()) {
                if (!content.contains(origin)) {
                    throw new IOException("template property " + origin + " not found in template.");
                }
                content = content.replace(origin, expansions.get(origin));
            }
            Files.write(jvmOptions, content.getBytes(), new OpenOption[0]);
        }
        catch (IOException ioException) {
            throw new UncheckedIOException(ioException);
        }
    }

    private Map<String, String> jvmOptionExpansions() {
        HashMap<String, String> expansions = new HashMap<String, String>();
        Version version = this.getVersion();
        String heapDumpOrigin = this.getVersion().onOrAfter("6.3.0") ? "-XX:HeapDumpPath=data" : "-XX:HeapDumpPath=/heap/dump/path";
        expansions.put(heapDumpOrigin, "-XX:HeapDumpPath=" + this.confPathLogs);
        if (version.onOrAfter("6.2.0")) {
            expansions.put("logs/gc.log", this.confPathLogs.resolve("gc.log").toString());
        }
        if (this.getVersion().getMajor() >= 7) {
            expansions.put("-XX:ErrorFile=logs/hs_err_pid%p.log", "-XX:ErrorFile=" + this.confPathLogs.resolve("hs_err_pid%p.log"));
        }
        return expansions;
    }

    private void checkFrozen() {
        if (this.configurationFrozen.get()) {
            throw new IllegalStateException("Configuration for " + this + " can not be altered, already locked");
        }
    }

    private List<String> getTransportPortInternal() {
        try {
            return this.readPortsFile(this.transportPortFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read transport ports file: " + this.transportPortFile + " for " + this, e);
        }
    }

    private List<String> getHttpPortInternal() {
        try {
            return this.readPortsFile(this.httpPortsFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read http ports file: " + this.httpPortsFile + " for " + this, e);
        }
    }

    private List<String> getReadinessPortInternal() {
        try {
            return this.readPortsFile(this.readinessPortsFile);
        }
        catch (IOException e) {
            return new ArrayList<String>();
        }
    }

    private List<String> getRemoteAccessPortInternal() {
        try {
            return this.readPortsFile(this.remoteAccessPortsFile);
        }
        catch (IOException e) {
            return new ArrayList<String>();
        }
    }

    private List<String> readPortsFile(Path file) throws IOException {
        try (Stream<String> lines = Files.lines(file, StandardCharsets.UTF_8);){
            List<String> list = lines.map(String::trim).collect(Collectors.toList());
            return list;
        }
    }

    private Path getExtractedDistributionDir() {
        return this.distributions.get(this.currentDistro).getExtracted().getSingleFile().toPath();
    }

    @Classpath
    public List<FileTree> getDistributionClasspath() {
        return this.getDistributionFiles((Action<PatternFilterable>)((Action)filter -> filter.include(new String[]{"**/*.jar"})));
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public List<FileTree> getDistributionFiles() {
        return this.getDistributionFiles((Action<PatternFilterable>)((Action)filter -> filter.exclude(new String[]{"**/*.jar"})));
    }

    private List<FileTree> getDistributionFiles(Action<PatternFilterable> patternFilter) {
        ArrayList<FileTree> files = new ArrayList<FileTree>();
        for (ElasticsearchDistribution distribution : this.distributions) {
            files.add(distribution.getExtracted().getAsFileTree().matching(patternFilter));
        }
        return files;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public List<File> getRoleFiles() {
        return this.roleFiles;
    }

    @Nested
    public List<?> getKeystoreSettings() {
        return this.keystoreSettings.getNormalizedCollection();
    }

    @Nested
    public List<?> getKeystoreFiles() {
        return this.keystoreFiles.getNormalizedCollection();
    }

    @Nested
    public List<?> getCliSetup() {
        return this.cliSetup.getFlatNormalizedCollection();
    }

    @Nested
    public List<?> getSettings() {
        return this.settings.getNormalizedCollection();
    }

    @Internal
    Set<String> getSettingKeys() {
        return this.settings.keySet();
    }

    @Nested
    public List<?> getSystemProperties() {
        return this.systemProperties.getNormalizedCollection();
    }

    @Nested
    public List<?> getEnvironment() {
        return this.environment.getNormalizedCollection();
    }

    @Nested
    public List<?> getJvmArgs() {
        return this.jvmArgs.getNormalizedCollection();
    }

    @Nested
    public List<?> getExtraConfigFiles() {
        return this.extraConfigFiles.getNormalizedCollection();
    }

    @Nested
    public List<FeatureFlag> getFeatureFlags() {
        return this.featureFlags;
    }

    @Override
    @Internal
    public boolean isProcessAlive() {
        Objects.requireNonNull(this.esProcess, "Can't wait for `" + this + "` as it's not started. Does the task have `useCluster` ?");
        return this.esProcess.isAlive();
    }

    void waitForAllConditions() {
        this.waitForConditions(this.waitConditions, System.currentTimeMillis(), NODE_UP_TIMEOUT_UNIT.toMillis(2L) + ADDITIONAL_CONFIG_TIMEOUT_UNIT.toMillis(15 * (this.plugins.size() + this.keystoreFiles.size() + this.keystoreSettings.size() + this.credentials.size())), TimeUnit.MILLISECONDS, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElasticsearchNode that = (ElasticsearchNode)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.path);
    }

    public String toString() {
        return "node{" + this.path + ":" + this.name + "}";
    }

    @Input
    List<Map<String, String>> getCredentials() {
        return this.credentials;
    }

    private boolean checkPortsFilesExistWithDelay(TestClusterConfiguration node) {
        if (Files.exists(this.httpPortsFile, new LinkOption[0]) && Files.exists(this.transportPortFile, new LinkOption[0])) {
            return true;
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TestClustersException("Interrupted while waiting for ports files", e);
        }
        return Files.exists(this.httpPortsFile, new LinkOption[0]) && Files.exists(this.transportPortFile, new LinkOption[0]);
    }

    @Internal
    public boolean isHttpSslEnabled() {
        return Boolean.parseBoolean(this.settings.getOrDefault("xpack.security.http.ssl.enabled", "false").toString());
    }

    void configureHttpWait(WaitForHttpResource wait) {
        if (this.settings.containsKey("xpack.security.http.ssl.certificate")) {
            wait.setServerCertificate(this.getConfigDir().resolve(this.settings.get("xpack.security.http.ssl.certificate").toString()).toFile());
        } else {
            if (this.settings.containsKey("xpack.security.http.ssl.keystore.path")) {
                wait.setServerKeystoreFile(this.getConfigDir().resolve(this.settings.get("xpack.security.http.ssl.keystore.path").toString()).toFile());
            }
            if (this.keystoreSettings.containsKey("xpack.security.http.ssl.keystore.secure_password")) {
                wait.setServerKeystorePassword(this.keystoreSettings.get("xpack.security.http.ssl.keystore.secure_password").toString());
            }
        }
    }

    void setHttpPort(String httpPort) {
        this.httpPort = httpPort;
    }

    void setTransportPort(String transportPort) {
        this.transportPort = transportPort;
    }

    void setDataPath(Path dataPath) {
        this.confPathData = dataPath;
    }

    @Internal
    Path getEsOutputFile() {
        return this.esOutputFile;
    }

    private static class CliEntry {
        private final String executable;
        private CharSequence[] args;

        CliEntry(String executable, CharSequence[] args) {
            this.executable = executable;
            this.args = args;
        }

        @Input
        public String getExecutable() {
            return this.executable;
        }

        @Input
        public CharSequence[] getArgs() {
            return this.args;
        }
    }

    private record FeatureFlag(String feature, Version from, Version until) {
        @Input
        public String getFeature() {
            return this.feature;
        }

        @Input
        public Version getFrom() {
            return this.from;
        }

        @Input
        @Optional
        public Version getUntil() {
            return this.until;
        }
    }

    private static class LinkCreationException
    extends UncheckedIOException {
        LinkCreationException(String message, IOException cause) {
            super(message, cause);
        }
    }

    private static class FileEntry
    implements Named {
        private String name;
        private File file;

        FileEntry(String name, File file) {
            this.name = name;
            this.file = file;
        }

        @Input
        public String getName() {
            return this.name;
        }

        @InputFile
        @PathSensitive(value=PathSensitivity.NONE)
        public File getFile() {
            return this.file;
        }
    }
}

