/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testclusters;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class MockApmServer {
    private static final Logger logger = Logging.getLogger(MockApmServer.class);
    private int port;
    private static volatile HttpServer instance;

    public MockApmServer(int port) {
        this.port = port;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        MockApmServer server = new MockApmServer(9999);
        server.start();
    }

    public synchronized int start() throws IOException {
        if (instance != null) {
            String hostname = instance.getAddress().getHostName();
            int port = instance.getAddress().getPort();
            logger.lifecycle("MockApmServer is already running. Reusing on address:port " + hostname + ":" + port);
            return port;
        }
        InetSocketAddress addr = new InetSocketAddress("0.0.0.0", this.port);
        HttpServer server = HttpServer.create(addr, 10);
        server.createContext("/exit", new ExitHandler());
        server.createContext("/", new RootHandler());
        server.start();
        instance = server;
        logger.lifecycle("MockApmServer started on port " + server.getAddress().getPort());
        return server.getAddress().getPort();
    }

    public int getPort() {
        return this.port;
    }

    public synchronized void stop() {
        logger.lifecycle("stopping apm server");
        instance.stop(1);
        instance = null;
    }

    static class ExitHandler
    implements HttpHandler {
        private static final int STOP_TIME = 3;

        ExitHandler() {
        }

        @Override
        public void handle(HttpExchange t) {
            try {
                InputStream body = t.getRequestBody();
                String response = "{}";
                t.sendResponseHeaders(200, response.length());
                OutputStream os = t.getResponseBody();
                os.write(response.getBytes());
                os.close();
                instance.stop(3);
                instance = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class RootHandler
    implements HttpHandler {
        RootHandler() {
        }

        @Override
        public void handle(HttpExchange t) {
            try {
                int lengthRead;
                InputStream body = t.getRequestBody();
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                byte[] buffer = new byte[8192];
                while ((lengthRead = body.read(buffer)) > 0) {
                    bytes.write(buffer, 0, lengthRead);
                }
                logger.lifecycle("MockApmServer reading JSON objects: " + bytes.toString());
                String response = "{}";
                t.sendResponseHeaders(200, response.length());
                OutputStream os = t.getResponseBody();
                os.write(response.getBytes());
                os.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

