/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testclusters;

import java.util.Collection;
import org.elasticsearch.gradle.testclusters.ElasticsearchCluster;
import org.elasticsearch.gradle.testclusters.ElasticsearchNode;
import org.elasticsearch.gradle.testclusters.TestClustersException;
import org.elasticsearch.gradle.testclusters.TestClustersPlugin;
import org.elasticsearch.gradle.testclusters.TestClustersRegistry;
import org.gradle.api.Task;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.Nested;

public interface TestClustersAware
extends Task {
    @Nested
    public Collection<ElasticsearchCluster> getClusters();

    @ServiceReference(value="testClustersRegistry")
    public Property<TestClustersRegistry> getRegistery();

    @ServiceReference(value="testClusterTasksService")
    public Property<TestClustersPlugin.TaskEventsService> getTasksService();

    default public void useCluster(ElasticsearchCluster cluster) {
        if (!cluster.getPath().equals(this.getProject().getPath())) {
            throw new TestClustersException("Task " + this.getPath() + " can't use test cluster from another project " + cluster);
        }
        cluster.getNodes().all(node -> node.getDistributions().forEach(distro -> this.dependsOn(new Object[]{this.getProject().provider(() -> distro.maybeFreeze())})));
        this.dependsOn(new Object[]{cluster.getPluginAndModuleConfigurations()});
        this.getClusters().add(cluster);
    }

    default public void useCluster(Provider<ElasticsearchCluster> cluster) {
        this.useCluster((ElasticsearchCluster)cluster.get());
    }

    default public void beforeStart() {
        ((TestClustersPlugin.TaskEventsService)this.getTasksService().get()).register(this);
    }

    default public void enableDebug() {
        int debugPort = 5007;
        for (ElasticsearchCluster cluster : this.getClusters()) {
            for (ElasticsearchNode node : cluster.getNodes()) {
                this.getLogger().lifecycle("Running elasticsearch in debug mode, {} expecting running debug server on port {}", new Object[]{node, debugPort});
                node.jvmArgs("-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=" + debugPort);
                ++debugPort;
            }
        }
    }

    default public void enableCliDebug() {
        int cliDebugPort = 5107;
        for (ElasticsearchCluster cluster : this.getClusters()) {
            for (ElasticsearchNode node : cluster.getNodes()) {
                this.getLogger().lifecycle("Running cli launcher in debug mode, {} expecting running debug server on port {}", new Object[]{node, cliDebugPort});
                node.cliJvmArgs("-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=" + cliDebugPort);
                ++cliDebugPort;
            }
        }
    }
}

