/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import org.elasticsearch.gradle.Architecture;
import org.elasticsearch.gradle.ElasticsearchDistributionType;
import org.elasticsearch.gradle.OS;
import org.elasticsearch.gradle.Version;
import org.elasticsearch.gradle.VersionProperties;
import org.elasticsearch.gradle.distribution.ElasticsearchDistributionTypes;
import org.gradle.api.Buildable;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.TaskDependency;

public class ElasticsearchDistribution
implements Buildable,
Iterable<File> {
    public static final Platform CURRENT_PLATFORM = OS.conditional().onLinux(() -> Platform.LINUX).onWindows(() -> Platform.WINDOWS).onMac(() -> Platform.DARWIN).supply();
    private final String name;
    private final Property<Boolean> dockerAvailability;
    final FileCollection configuration;
    private final Property<Architecture> architecture;
    private final Property<String> version;
    private final Property<ElasticsearchDistributionType> type;
    private final Property<Platform> platform;
    private final Property<Boolean> bundledJdk;
    private final Property<Boolean> failIfUnavailable;
    private final Property<Boolean> preferArchive;
    private final ConfigurableFileCollection extracted;
    private boolean frozen = false;

    ElasticsearchDistribution(String name, ObjectFactory objectFactory, Property<Boolean> dockerAvailability, ConfigurableFileCollection fileConfiguration, ConfigurableFileCollection extractedConfiguration) {
        this.name = name;
        this.dockerAvailability = dockerAvailability;
        this.configuration = fileConfiguration;
        this.architecture = objectFactory.property(Architecture.class);
        this.version = objectFactory.property(String.class).convention((Object)VersionProperties.getElasticsearch());
        this.type = objectFactory.property(ElasticsearchDistributionType.class);
        this.type.convention((Object)ElasticsearchDistributionTypes.ARCHIVE);
        this.platform = objectFactory.property(Platform.class);
        this.bundledJdk = objectFactory.property(Boolean.class);
        this.failIfUnavailable = objectFactory.property(Boolean.class).convention((Object)true);
        this.preferArchive = objectFactory.property(Boolean.class).convention((Object)false);
        this.extracted = extractedConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return (String)this.version.get();
    }

    public void setVersion(String version) {
        Version.fromString(version);
        this.version.set((Object)version);
    }

    public Platform getPlatform() {
        return (Platform)((Object)this.platform.getOrNull());
    }

    public void setPlatform(Platform platform) {
        this.platform.set((Object)platform);
    }

    public ElasticsearchDistributionType getType() {
        return (ElasticsearchDistributionType)this.type.get();
    }

    public void setType(ElasticsearchDistributionType type) {
        this.type.set((Object)type);
    }

    public void setType(String type) {
        if (type.equals(ElasticsearchDistributionTypes.ARCHIVE.getName())) {
            this.type.set((Object)ElasticsearchDistributionTypes.ARCHIVE);
        } else if (type.equals(ElasticsearchDistributionTypes.INTEG_TEST_ZIP.getName())) {
            this.type.set((Object)ElasticsearchDistributionTypes.INTEG_TEST_ZIP);
        } else {
            throw new IllegalArgumentException("Cannot set Elasticsearch Distribution type to " + type + ". Type unknown.");
        }
    }

    public boolean getBundledJdk() {
        return (Boolean)this.bundledJdk.getOrElse((Object)true);
    }

    public boolean isDocker() {
        return ((ElasticsearchDistributionType)this.type.get()).isDocker();
    }

    public void setBundledJdk(Boolean bundledJdk) {
        this.bundledJdk.set((Object)bundledJdk);
    }

    public boolean getFailIfUnavailable() {
        return (Boolean)this.failIfUnavailable.get();
    }

    public void setFailIfUnavailable(boolean failIfUnavailable) {
        this.failIfUnavailable.set((Object)failIfUnavailable);
    }

    public boolean getPreferArchive() {
        return (Boolean)this.preferArchive.get();
    }

    public void setPreferArchive(boolean preferArchive) {
        this.preferArchive.set((Object)preferArchive);
    }

    public void setArchitecture(Architecture architecture) {
        this.architecture.set((Object)architecture);
    }

    public Architecture getArchitecture() {
        return (Architecture)((Object)this.architecture.get());
    }

    public String toString() {
        return this.getName() + "_" + this.getType() + "_" + this.getVersion();
    }

    public ElasticsearchDistribution maybeFreeze() {
        if (!this.frozen) {
            this.finalizeValues();
            this.frozen = true;
        }
        return this;
    }

    public String getFilepath() {
        this.maybeFreeze();
        return this.configuration.getSingleFile().toString();
    }

    public ConfigurableFileCollection getExtracted() {
        if (!this.getType().shouldExtract()) {
            throw new UnsupportedOperationException("distribution type [" + this.getType().getName() + "] for elasticsearch distribution [" + this.name + "] cannot be extracted");
        }
        return this.extracted;
    }

    public TaskDependency getBuildDependencies() {
        if (this.skippingDockerDistributionBuild()) {
            return task -> Collections.emptySet();
        }
        this.maybeFreeze();
        return this.getType().shouldExtract() && (Boolean)this.preferArchive.get() == false ? this.extracted.getBuildDependencies() : this.configuration.getBuildDependencies();
    }

    private boolean skippingDockerDistributionBuild() {
        return this.isDocker() && !this.getFailIfUnavailable() && (Boolean)this.dockerAvailability.get() == false;
    }

    @Override
    public Iterator<File> iterator() {
        this.maybeFreeze();
        return this.getType().shouldExtract() ? this.extracted.iterator() : this.configuration.iterator();
    }

    void finalizeValues() {
        if (this.getType() == ElasticsearchDistributionTypes.INTEG_TEST_ZIP) {
            if (this.platform.getOrNull() != null) {
                throw new IllegalArgumentException("platform cannot be set on elasticsearch distribution [" + this.name + "] of type [integ_test_zip]");
            }
            if (this.bundledJdk.getOrNull() != null) {
                throw new IllegalArgumentException("bundledJdk cannot be set on elasticsearch distribution [" + this.name + "] of type [integ_test_zip]");
            }
            return;
        }
        if (!this.isDocker() && !((Boolean)this.failIfUnavailable.get()).booleanValue()) {
            throw new IllegalArgumentException("failIfUnavailable cannot be 'false' on elasticsearch distribution [" + this.name + "] of type [" + this.getType() + "]");
        }
        if (this.getType() == ElasticsearchDistributionTypes.ARCHIVE) {
            if (!this.platform.isPresent()) {
                this.platform.set((Object)CURRENT_PLATFORM);
            }
        } else {
            if (this.platform.isPresent()) {
                throw new IllegalArgumentException("platform cannot be set on elasticsearch distribution [" + this.name + "] of type [" + this.getType() + "]");
            }
            if (this.isDocker() && this.bundledJdk.isPresent()) {
                throw new IllegalArgumentException("bundledJdk cannot be set on elasticsearch distribution [" + this.name + "] of type [docker]");
            }
        }
        if (!this.bundledJdk.isPresent()) {
            this.bundledJdk.set((Object)true);
        }
        this.version.finalizeValue();
        this.platform.finalizeValue();
        this.type.finalizeValue();
        this.bundledJdk.finalizeValue();
    }

    public static enum Platform {
        LINUX,
        WINDOWS,
        DARWIN;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }
    }
}

