/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.ExtraPropertiesExtension;

public class PluginPropertiesExtension {
    private String name;
    private String version;
    private String description;
    private String classname;
    private List<String> extendedPlugins = new ArrayList<String>();
    private boolean hasNativeController;
    private boolean isLicensed = false;
    private boolean requiresKeystore;
    private File licenseFile;
    private File noticeFile;
    private final Project project;
    private CopySpec bundleSpec;

    public PluginPropertiesExtension(Project project) {
        this.project = project;
    }

    public String getName() {
        return this.name == null ? this.project.getName() : this.name;
    }

    public void setName(String name) {
        this.project.setProperty("archivesBaseName", (Object)name);
        this.name = name;
    }

    public String getVersion() {
        return this.version == null ? this.project.getVersion().toString() : this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.project.setDescription(description);
        this.description = description;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public List<String> getExtendedPlugins() {
        return this.extendedPlugins;
    }

    public boolean isHasNativeController() {
        return this.hasNativeController;
    }

    public void setHasNativeController(boolean hasNativeController) {
        this.hasNativeController = hasNativeController;
    }

    public boolean isLicensed() {
        return this.isLicensed;
    }

    public void setLicensed(boolean licensed) {
        this.isLicensed = licensed;
    }

    public boolean isRequiresKeystore() {
        return this.requiresKeystore;
    }

    public void setRequiresKeystore(boolean requiresKeystore) {
        this.requiresKeystore = requiresKeystore;
    }

    public File getLicenseFile() {
        return this.licenseFile;
    }

    public void setLicenseFile(File licenseFile) {
        ExtraPropertiesExtension extraProperties = this.project.getExtensions().getExtraProperties();
        RegularFileProperty regularFileProperty = extraProperties.has("licenseFile") ? (RegularFileProperty)extraProperties.get("licenseFile") : this.project.getObjects().fileProperty();
        regularFileProperty.set(licenseFile);
        this.licenseFile = licenseFile;
    }

    public File getNoticeFile() {
        return this.noticeFile;
    }

    public void setNoticeFile(File noticeFile) {
        ExtraPropertiesExtension extraProperties = this.project.getExtensions().getExtraProperties();
        RegularFileProperty regularFileProperty = extraProperties.has("noticeFile") ? (RegularFileProperty)extraProperties.get("noticeFile") : this.project.getObjects().fileProperty();
        regularFileProperty.set(noticeFile);
        this.noticeFile = noticeFile;
    }

    public Project getProject() {
        return this.project;
    }

    public void setExtendedPlugins(List<String> extendedPlugins) {
        this.extendedPlugins = extendedPlugins;
    }

    public void setBundleSpec(CopySpec bundleSpec) {
        this.bundleSpec = bundleSpec;
    }

    public CopySpec getBundleSpec() {
        return this.bundleSpec;
    }
}

