/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.idea.model.IdeaModel;

public abstract class GradleUtils {
    public static <T> Action<T> noop() {
        return t -> {};
    }

    public static SourceSetContainer getJavaSourceSets(Project project) {
        return ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets();
    }

    public static void maybeConfigure(TaskContainer tasks, String name, Action<? super Task> config) {
        tasks.matching(t -> t.getName().equals(name)).configureEach(t -> config.execute(t));
    }

    public static <T extends Task> void maybeConfigure(TaskContainer tasks, String name, Class<? extends T> type, Action<? super T> config) {
        tasks.withType(type).matching(t -> t.getName().equals(name)).configureEach(task -> config.execute(task));
    }

    public static TaskProvider<?> findByName(TaskContainer tasks, String name) {
        TaskProvider task;
        try {
            task = tasks.named(name);
        }
        catch (UnknownTaskException e) {
            return null;
        }
        return task;
    }

    public static <T extends BuildService<?>> Provider<T> getBuildService(BuildServiceRegistry registry, String name) {
        BuildServiceRegistration registration = (BuildServiceRegistration)registry.getRegistrations().findByName(name);
        if (registration == null) {
            throw new GradleException("Unable to find build service with name '" + name + "'.");
        }
        return registration.getService();
    }

    public static TaskProvider<Test> addTestSourceSet(Project project, String sourceSetName) {
        project.getPluginManager().apply(JavaPlugin.class);
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        SourceSet testSourceSet = (SourceSet)sourceSets.create(sourceSetName);
        TaskProvider testTask = project.getTasks().register(sourceSetName, Test.class);
        testTask.configure(task -> {
            task.setGroup("verification");
            task.setTestClassesDirs(testSourceSet.getOutput().getClassesDirs());
            task.setClasspath(testSourceSet.getRuntimeClasspath());
            task.mustRunAfter(new Object[]{project.getTasks().named("test")});
        });
        Configuration testCompileConfig = project.getConfigurations().getByName(testSourceSet.getCompileClasspathConfigurationName());
        Configuration testRuntimeConfig = project.getConfigurations().getByName(testSourceSet.getRuntimeClasspathConfigurationName());
        testSourceSet.setCompileClasspath((FileCollection)testCompileConfig);
        testSourceSet.setRuntimeClasspath((FileCollection)project.getObjects().fileCollection().from(new Object[]{testSourceSet.getOutput(), testRuntimeConfig}));
        GradleUtils.extendSourceSet(project, "main", sourceSetName);
        GradleUtils.setupIdeForTestSourceSet(project, testSourceSet);
        project.getTasks().named("check").configure(check -> check.dependsOn(new Object[]{testTask}));
        return testTask;
    }

    public static void setupIdeForTestSourceSet(Project project, SourceSet testSourceSet) {
        String runtimeClasspathName = testSourceSet.getRuntimeClasspathConfigurationName();
        Configuration runtimeClasspathConfiguration = project.getConfigurations().getByName(runtimeClasspathName);
        project.getPluginManager().withPlugin("idea", p -> {
            IdeaModel idea = (IdeaModel)project.getExtensions().getByType(IdeaModel.class);
            idea.getModule().setTestSourceDirs(testSourceSet.getJava().getSrcDirs());
            idea.getModule().getScopes().put(testSourceSet.getName(), Map.of("plus", List.of(runtimeClasspathConfiguration)));
        });
        project.getPluginManager().withPlugin("eclipse", p -> {
            EclipseModel eclipse = (EclipseModel)project.getExtensions().getByType(EclipseModel.class);
            ArrayList<SourceSet> eclipseSourceSets = new ArrayList<SourceSet>();
            for (SourceSet old : eclipse.getClasspath().getSourceSets()) {
                eclipseSourceSets.add(old);
            }
            eclipseSourceSets.add(testSourceSet);
            eclipse.getClasspath().setSourceSets((Iterable)project.getExtensions().getByType(SourceSetContainer.class));
            eclipse.getClasspath().getPlusConfigurations().add(runtimeClasspathConfiguration);
        });
    }

    public static void extendSourceSet(Project project, String parentSourceSetName, String childSourceSetName) {
        List<Function> configNameFunctions = Arrays.asList(SourceSet::getCompileOnlyConfigurationName, SourceSet::getImplementationConfigurationName, SourceSet::getRuntimeOnlyConfigurationName);
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        SourceSet parent = (SourceSet)sourceSets.getByName(parentSourceSetName);
        SourceSet child = (SourceSet)sourceSets.getByName(childSourceSetName);
        for (Function configNameFunction : configNameFunctions) {
            String parentConfigName = (String)configNameFunction.apply(parent);
            String childConfigName = (String)configNameFunction.apply(child);
            Configuration parentConfig = project.getConfigurations().getByName(parentConfigName);
            Configuration childConfig = project.getConfigurations().getByName(childConfigName);
            childConfig.extendsFrom(new Configuration[]{parentConfig});
        }
        child.setCompileClasspath((FileCollection)project.getObjects().fileCollection().from(new Object[]{child.getCompileClasspath(), parent.getOutput()}));
        child.setRuntimeClasspath((FileCollection)project.getObjects().fileCollection().from(new Object[]{child.getRuntimeClasspath(), parent.getOutput()}));
    }

    public static void extendSourceSet(Project project, String parentSourceSetName, String childSourceSetName, TaskProvider<Test> test) {
        GradleUtils.extendSourceSet(project, parentSourceSetName, childSourceSetName);
        if (test != null) {
            test.configure(t -> {
                SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
                SourceSet child = (SourceSet)sourceSets.getByName(childSourceSetName);
                t.setClasspath(child.getRuntimeClasspath());
            });
        }
    }

    public static Dependency projectDependency(Project project, String projectPath, String projectConfig) {
        if (project.findProject(projectPath) == null) {
            throw new GradleException("no project [" + projectPath + "], project names: " + project.getRootProject().getAllprojects());
        }
        HashMap<String, String> depConfig = new HashMap<String, String>();
        depConfig.put("path", projectPath);
        depConfig.put("configuration", projectConfig);
        return project.getDependencies().project(depConfig);
    }

    public static String getProjectPathFromTask(String taskPath) {
        int lastDelimiterIndex = taskPath.lastIndexOf(":");
        return lastDelimiterIndex == 0 ? ":" : taskPath.substring(0, lastDelimiterIndex);
    }

    public static boolean isModuleProject(String projectPath) {
        return projectPath.contains("modules:") || projectPath.startsWith(":x-pack:plugin");
    }

    public static void disableTransitiveDependencies(Configuration config) {
        config.getDependencies().all(dep -> {
            if (dep instanceof ModuleDependency && !(dep instanceof ProjectDependency) && !dep.getGroup().startsWith("org.elasticsearch")) {
                ((ModuleDependency)dep).setTransitive(false);
            }
        });
    }

    public static String projectPath(String taskPath) {
        return taskPath.lastIndexOf(58) == 0 ? ":" : taskPath.substring(0, taskPath.lastIndexOf(58));
    }
}

