/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testclusters;

import java.io.File;
import java.util.function.Function;
import javax.inject.Inject;
import org.elasticsearch.gradle.DistributionDownloadPlugin;
import org.elasticsearch.gradle.ReaperPlugin;
import org.elasticsearch.gradle.ReaperService;
import org.elasticsearch.gradle.Version;
import org.elasticsearch.gradle.testclusters.ElasticsearchCluster;
import org.elasticsearch.gradle.testclusters.TestClustersAware;
import org.elasticsearch.gradle.testclusters.TestClustersRegistry;
import org.elasticsearch.gradle.testclusters.TestClustersThrottle;
import org.elasticsearch.gradle.util.GradleUtils;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskState;
import org.gradle.internal.jvm.Jvm;
import org.gradle.process.ExecOperations;

public class TestClustersPlugin
implements Plugin<Project> {
    public static final String EXTENSION_NAME = "testClusters";
    public static final String THROTTLE_SERVICE_NAME = "testClustersThrottle";
    private static final String LIST_TASK_NAME = "listTestClusters";
    private static final String REGISTRY_SERVICE_NAME = "testClustersRegistry";
    private static final Logger logger = Logging.getLogger(TestClustersPlugin.class);
    private final ProviderFactory providerFactory;
    private Provider<File> runtimeJavaProvider;
    private Function<Version, Boolean> isReleasedVersion = v -> true;

    @Inject
    protected FileSystemOperations getFileSystemOperations() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ArchiveOperations getArchiveOperations() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ExecOperations getExecOperations() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileOperations getFileOperations() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public TestClustersPlugin(ProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public void setRuntimeJava(Provider<File> runtimeJava) {
        this.runtimeJavaProvider = runtimeJava;
    }

    public void setIsReleasedVersion(Function<Version, Boolean> isReleasedVersion) {
        this.isReleasedVersion = isReleasedVersion;
    }

    public void apply(Project project) {
        project.getPlugins().apply(DistributionDownloadPlugin.class);
        project.getRootProject().getPluginManager().apply(ReaperPlugin.class);
        Provider reaperServiceProvider = GradleUtils.getBuildService(project.getGradle().getSharedServices(), "reaper");
        this.runtimeJavaProvider = this.providerFactory.provider(() -> System.getenv("RUNTIME_JAVA_HOME") == null ? Jvm.current().getJavaHome() : new File(System.getenv("RUNTIME_JAVA_HOME")));
        NamedDomainObjectContainer<ElasticsearchCluster> container = this.createTestClustersContainerExtension(project, reaperServiceProvider);
        this.createListClustersTask(project, container);
        project.getGradle().getSharedServices().registerIfAbsent(REGISTRY_SERVICE_NAME, TestClustersRegistry.class, GradleUtils.noop());
        project.getGradle().getSharedServices().registerIfAbsent(THROTTLE_SERVICE_NAME, TestClustersThrottle.class, spec -> spec.getMaxParallelUsages().set((Object)Math.max(1, project.getGradle().getStartParameter().getMaxWorkerCount() / 2)));
        project.getRootProject().getPluginManager().apply(TestClustersHookPlugin.class);
    }

    private NamedDomainObjectContainer<ElasticsearchCluster> createTestClustersContainerExtension(Project project, Provider<ReaperService> reaper) {
        NamedDomainObjectContainer container = project.container(ElasticsearchCluster.class, name -> new ElasticsearchCluster(project.getPath(), name, project, reaper, this.getFileSystemOperations(), this.getArchiveOperations(), this.getExecOperations(), this.getFileOperations(), new File(project.getBuildDir(), "testclusters"), this.runtimeJavaProvider, this.isReleasedVersion));
        project.getExtensions().add(EXTENSION_NAME, (Object)container);
        container.configureEach(cluster -> cluster.systemProperty("ingest.geoip.downloader.enabled.default", "false"));
        return container;
    }

    private void createListClustersTask(Project project, NamedDomainObjectContainer<ElasticsearchCluster> container) {
        project.getTasks().register(LIST_TASK_NAME, task -> {
            task.setGroup("ES cluster formation");
            task.setDescription("Lists all ES clusters configured for this project");
            task.doLast(t -> container.forEach(cluster -> logger.lifecycle("   * {}: {}", new Object[]{cluster.getName(), cluster.getNumberOfNodes()})));
        });
    }

    static class TestClustersHookPlugin
    implements Plugin<Project> {
        TestClustersHookPlugin() {
        }

        public void apply(Project project) {
            if (project != project.getRootProject()) {
                throw new IllegalStateException(this.getClass().getName() + " can only be applied to the root project.");
            }
            Provider registryProvider = GradleUtils.getBuildService(project.getGradle().getSharedServices(), TestClustersPlugin.REGISTRY_SERVICE_NAME);
            TestClustersRegistry registry = (TestClustersRegistry)registryProvider.get();
            TestClustersHookPlugin.configureClaimClustersHook(project.getGradle(), registry);
            TestClustersHookPlugin.configureStartClustersHook(project.getGradle(), registry);
            TestClustersHookPlugin.configureStopClustersHook(project.getGradle(), registry);
        }

        private static void configureClaimClustersHook(Gradle gradle, TestClustersRegistry registry) {
            gradle.getTaskGraph().whenReady(taskExecutionGraph -> taskExecutionGraph.getAllTasks().stream().filter(task -> task instanceof TestClustersAware).map(task -> (TestClustersAware)task).flatMap(task -> task.getClusters().stream()).forEach(registry::claimCluster));
        }

        private static void configureStartClustersHook(Gradle gradle, final TestClustersRegistry registry) {
            gradle.addListener((Object)new TaskActionListener(){

                public void beforeActions(Task task) {
                    if (!(task instanceof TestClustersAware)) {
                        return;
                    }
                    TestClustersAware awareTask = (TestClustersAware)task;
                    awareTask.beforeStart();
                    awareTask.getClusters().forEach(registry::maybeStartCluster);
                }

                public void afterActions(Task task) {
                }
            });
        }

        private static void configureStopClustersHook(Gradle gradle, final TestClustersRegistry registry) {
            gradle.addListener((Object)new TaskExecutionListener(){

                public void afterExecute(Task task, TaskState state) {
                    if (!(task instanceof TestClustersAware)) {
                        return;
                    }
                    ((TestClustersAware)task).getClusters().forEach(cluster -> registry.stopCluster((ElasticsearchCluster)cluster, state.getFailure() != null));
                }

                public void beforeExecute(Task task) {
                }
            });
        }
    }
}

