/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testclusters;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import org.elasticsearch.gradle.DistributionDownloadPlugin;
import org.elasticsearch.gradle.ReaperPlugin;
import org.elasticsearch.gradle.ReaperService;
import org.elasticsearch.gradle.Version;
import org.elasticsearch.gradle.testclusters.ElasticsearchCluster;
import org.elasticsearch.gradle.testclusters.TestClustersAware;
import org.elasticsearch.gradle.testclusters.TestClustersRegistry;
import org.elasticsearch.gradle.testclusters.TestClustersThrottle;
import org.elasticsearch.gradle.transform.UnpackTransform;
import org.elasticsearch.gradle.transform.UnzipTransform;
import org.elasticsearch.gradle.util.GradleUtils;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.gradle.internal.jvm.Jvm;
import org.gradle.process.ExecOperations;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFailureResult;
import org.gradle.tooling.events.task.TaskFinishEvent;

public class TestClustersPlugin
implements Plugin<Project> {
    public static final Attribute<Boolean> BUNDLE_ATTRIBUTE = Attribute.of((String)"bundle", Boolean.class);
    public static final String EXTENSION_NAME = "testClusters";
    public static final String THROTTLE_SERVICE_NAME = "testClustersThrottle";
    private static final String LIST_TASK_NAME = "listTestClusters";
    public static final String REGISTRY_SERVICE_NAME = "testClustersRegistry";
    private static final Logger logger = Logging.getLogger(TestClustersPlugin.class);
    public static final String TEST_CLUSTER_TASKS_SERVICE = "testClusterTasksService";
    private final ProviderFactory providerFactory;
    private Provider<File> runtimeJavaProvider;
    private Function<Version, Boolean> isReleasedVersion = v -> true;

    @Inject
    protected FileSystemOperations getFileSystemOperations() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ArchiveOperations getArchiveOperations() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ExecOperations getExecOperations() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileOperations getFileOperations() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public TestClustersPlugin(ProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public void setRuntimeJava(Provider<File> runtimeJava) {
        this.runtimeJavaProvider = runtimeJava;
    }

    public void setIsReleasedVersion(Function<Version, Boolean> isReleasedVersion) {
        this.isReleasedVersion = isReleasedVersion;
    }

    public void apply(Project project) {
        project.getPlugins().apply(DistributionDownloadPlugin.class);
        project.getRootProject().getPluginManager().apply(ReaperPlugin.class);
        Provider reaperServiceProvider = GradleUtils.getBuildService(project.getGradle().getSharedServices(), "reaper");
        this.runtimeJavaProvider = this.providerFactory.provider(() -> System.getenv("RUNTIME_JAVA_HOME") == null ? Jvm.current().getJavaHome() : new File(System.getenv("RUNTIME_JAVA_HOME")));
        Provider testClustersRegistryProvider = project.getGradle().getSharedServices().registerIfAbsent(REGISTRY_SERVICE_NAME, TestClustersRegistry.class, GradleUtils.noop());
        NamedDomainObjectContainer<ElasticsearchCluster> container = this.createTestClustersContainerExtension(project, (Provider<TestClustersRegistry>)testClustersRegistryProvider, reaperServiceProvider);
        this.createListClustersTask(project, container);
        Provider testClustersThrottleProvider = project.getGradle().getSharedServices().registerIfAbsent(THROTTLE_SERVICE_NAME, TestClustersThrottle.class, spec -> spec.getMaxParallelUsages().set((Object)Math.max(1, project.getGradle().getStartParameter().getMaxWorkerCount() / 2)));
        project.getTasks().withType(TestClustersAware.class).configureEach(task -> task.usesService(testClustersThrottleProvider));
        project.getRootProject().getPluginManager().apply(TestClustersHookPlugin.class);
        this.configureArtifactTransforms(project);
    }

    private void configureArtifactTransforms(Project project) {
        project.getDependencies().getAttributesSchema().attribute(BUNDLE_ATTRIBUTE);
        project.getDependencies().getArtifactTypes().maybeCreate("zip");
        project.getDependencies().registerTransform(UnzipTransform.class, transformSpec -> {
            transformSpec.getFrom().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"zip").attribute(BUNDLE_ATTRIBUTE, (Object)true);
            transformSpec.getTo().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"directory").attribute(BUNDLE_ATTRIBUTE, (Object)true);
            ((UnpackTransform.Parameters)transformSpec.getParameters()).setAsFiletreeOutput(true);
        });
    }

    private NamedDomainObjectContainer<ElasticsearchCluster> createTestClustersContainerExtension(Project project, Provider<TestClustersRegistry> testClustersRegistryProvider, Provider<ReaperService> reaper) {
        NamedDomainObjectContainer container = project.container(ElasticsearchCluster.class, name -> new ElasticsearchCluster(project.getPath(), name, project, reaper, testClustersRegistryProvider, this.getFileSystemOperations(), this.getArchiveOperations(), this.getExecOperations(), this.getFileOperations(), new File(project.getBuildDir(), "testclusters"), this.runtimeJavaProvider, this.isReleasedVersion));
        project.getExtensions().add(EXTENSION_NAME, (Object)container);
        container.configureEach(cluster -> cluster.systemProperty("ingest.geoip.downloader.enabled.default", "false"));
        return container;
    }

    private void createListClustersTask(Project project, NamedDomainObjectContainer<ElasticsearchCluster> container) {
        project.getTasks().register(LIST_TASK_NAME, task -> {
            task.setGroup("ES cluster formation");
            task.setDescription("Lists all ES clusters configured for this project");
            task.doLast(t -> container.forEach(cluster -> logger.lifecycle("   * {}: {}", new Object[]{cluster.getName(), cluster.getNumberOfNodes()})));
        });
    }

    static abstract class TestClustersHookPlugin
    implements Plugin<Project> {
        @Inject
        public abstract BuildEventsListenerRegistry getEventsListenerRegistry();

        @Inject
        public TestClustersHookPlugin() {
        }

        public void apply(Project project) {
            if (project != project.getRootProject()) {
                throw new IllegalStateException(this.getClass().getName() + " can only be applied to the root project.");
            }
            Provider registryProvider = GradleUtils.getBuildService(project.getGradle().getSharedServices(), TestClustersPlugin.REGISTRY_SERVICE_NAME);
            Provider testClusterTasksService = project.getGradle().getSharedServices().registerIfAbsent(TestClustersPlugin.TEST_CLUSTER_TASKS_SERVICE, TaskEventsService.class, spec -> ((TaskEventsService.Params)spec.getParameters()).getRegistry().set(registryProvider));
            TestClustersRegistry registry = (TestClustersRegistry)registryProvider.get();
            TestClustersHookPlugin.configureClaimClustersHook(project.getGradle(), registry);
            this.configureStartClustersHook(project.getGradle());
            this.getEventsListenerRegistry().onTaskCompletion(testClusterTasksService);
        }

        private static void configureClaimClustersHook(Gradle gradle, TestClustersRegistry registry) {
            gradle.getTaskGraph().whenReady(taskExecutionGraph -> taskExecutionGraph.getAllTasks().stream().filter(task -> task instanceof TestClustersAware).map(task -> (TestClustersAware)task).flatMap(task -> task.getClusters().stream()).forEach(registry::claimCluster));
        }

        private void configureStartClustersHook(Gradle gradle) {
            gradle.getTaskGraph().whenReady(taskExecutionGraph -> taskExecutionGraph.getAllTasks().stream().filter(task -> task instanceof TestClustersAware).map(task -> (TestClustersAware)task).forEach(awareTask -> awareTask.doFirst(task -> {
                awareTask.beforeStart();
                awareTask.getClusters().forEach(((TestClustersRegistry)awareTask.getRegistry().get())::maybeStartCluster);
            })));
        }
    }

    public static abstract class TaskEventsService
    implements BuildService<Params>,
    OperationCompletionListener {
        Map<String, TestClustersAware> tasksMap = new HashMap<String, TestClustersAware>();

        public void register(TestClustersAware task) {
            this.tasksMap.put(task.getPath(), task);
        }

        public void onFinish(FinishEvent finishEvent) {
            TestClustersAware task;
            TaskFinishEvent taskFinishEvent;
            String taskPath;
            if (finishEvent instanceof TaskFinishEvent && this.tasksMap.containsKey(taskPath = (taskFinishEvent = (TaskFinishEvent)finishEvent).getDescriptor().getTaskPath()) && (task = this.tasksMap.get(taskPath)).getDidWork()) {
                task.getClusters().forEach(cluster -> ((TestClustersRegistry)((Params)this.getParameters()).getRegistry().get()).stopCluster((ElasticsearchCluster)cluster, taskFinishEvent.getResult() instanceof TaskFailureResult));
            }
        }

        static interface Params
        extends BuildServiceParameters {
            public Property<TestClustersRegistry> getRegistry();
        }
    }
}

