/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.metrics.JsonMetrics;

public class MetricsElasticsearchModule
extends Module {
    public static final Version VERSION = new Version(1, 0, 0, "", "metrics-elasticsearch-reporter", "metrics-elasticsearch-reporter");
    private final TimeUnit rateUnit;
    private final TimeUnit durationUnit;
    private final String timestampFieldname;

    public MetricsElasticsearchModule(TimeUnit rateUnit, TimeUnit durationUnit, String timestampFieldname) {
        this.rateUnit = rateUnit;
        this.durationUnit = durationUnit;
        this.timestampFieldname = timestampFieldname;
    }

    public String getModuleName() {
        return "metrics-elasticsearch-serialization";
    }

    public Version version() {
        return VERSION;
    }

    public void setupModule(Module.SetupContext context) {
        context.addSerializers((Serializers)new SimpleSerializers(Arrays.asList(new JsonSerializer[]{new GaugeSerializer(this.timestampFieldname), new CounterSerializer(this.timestampFieldname), new HistogramSerializer(this.timestampFieldname), new MeterSerializer(this.rateUnit, this.timestampFieldname), new TimerSerializer(this.rateUnit, this.durationUnit, this.timestampFieldname), new BulkIndexOperationHeaderSerializer(this.timestampFieldname)})));
    }

    private static String calculateRateUnit(TimeUnit unit, String name) {
        String s = unit.toString().toLowerCase(Locale.US);
        return name + '/' + s.substring(0, s.length() - 1);
    }

    public static class BulkIndexOperationHeader {
        public String index;
        public String type;

        public BulkIndexOperationHeader(String index, String type) {
            this.index = index;
            this.type = type;
        }
    }

    private static class BulkIndexOperationHeaderSerializer
    extends StdSerializer<BulkIndexOperationHeader> {
        public BulkIndexOperationHeaderSerializer(String timestampFieldname) {
            super(BulkIndexOperationHeader.class);
        }

        public void serialize(BulkIndexOperationHeader bulkIndexOperationHeader, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            json.writeObjectFieldStart("index");
            if (bulkIndexOperationHeader.index != null) {
                json.writeStringField("_index", bulkIndexOperationHeader.index);
            }
            if (bulkIndexOperationHeader.type != null) {
                json.writeStringField("_type", bulkIndexOperationHeader.type);
            }
            json.writeEndObject();
            json.writeEndObject();
        }
    }

    private static class TimerSerializer
    extends StdSerializer<JsonMetrics.JsonTimer> {
        private final String rateUnit;
        private final double rateFactor;
        private final String durationUnit;
        private final double durationFactor;
        private final String timestampFieldname;

        private TimerSerializer(TimeUnit rateUnit, TimeUnit durationUnit, String timestampFieldname) {
            super(JsonMetrics.JsonTimer.class);
            this.timestampFieldname = timestampFieldname;
            this.rateUnit = MetricsElasticsearchModule.calculateRateUnit(rateUnit, "calls");
            this.rateFactor = rateUnit.toSeconds(1L);
            this.durationUnit = durationUnit.toString().toLowerCase(Locale.US);
            this.durationFactor = 1.0 / (double)durationUnit.toNanos(1L);
        }

        public void serialize(JsonMetrics.JsonTimer jsonTimer, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            json.writeStringField("name", jsonTimer.name());
            json.writeObjectField(this.timestampFieldname, (Object)jsonTimer.timestampAsDate());
            Timer timer = (Timer)jsonTimer.value();
            Snapshot snapshot = timer.getSnapshot();
            json.writeNumberField("count", timer.getCount());
            json.writeNumberField("max", (double)snapshot.getMax() * this.durationFactor);
            json.writeNumberField("mean", snapshot.getMean() * this.durationFactor);
            json.writeNumberField("min", (double)snapshot.getMin() * this.durationFactor);
            json.writeNumberField("p50", snapshot.getMedian() * this.durationFactor);
            json.writeNumberField("p75", snapshot.get75thPercentile() * this.durationFactor);
            json.writeNumberField("p95", snapshot.get95thPercentile() * this.durationFactor);
            json.writeNumberField("p98", snapshot.get98thPercentile() * this.durationFactor);
            json.writeNumberField("p99", snapshot.get99thPercentile() * this.durationFactor);
            json.writeNumberField("p999", snapshot.get999thPercentile() * this.durationFactor);
            json.writeNumberField("stddev", snapshot.getStdDev() * this.durationFactor);
            json.writeNumberField("m15_rate", timer.getOneMinuteRate() * this.rateFactor);
            json.writeNumberField("m1_rate", timer.getFifteenMinuteRate() * this.rateFactor);
            json.writeNumberField("m5_rate", timer.getFiveMinuteRate() * this.rateFactor);
            json.writeNumberField("mean_rate", timer.getMeanRate() * this.rateFactor);
            json.writeStringField("duration_units", this.durationUnit);
            json.writeStringField("rate_units", this.rateUnit);
            json.writeEndObject();
        }
    }

    private static class MeterSerializer
    extends StdSerializer<JsonMetrics.JsonMeter> {
        private final String rateUnit;
        private final double rateFactor;
        private final String timestampFieldname;

        public MeterSerializer(TimeUnit rateUnit, String timestampFieldname) {
            super(JsonMetrics.JsonMeter.class);
            this.timestampFieldname = timestampFieldname;
            this.rateFactor = rateUnit.toSeconds(1L);
            this.rateUnit = MetricsElasticsearchModule.calculateRateUnit(rateUnit, "events");
        }

        public void serialize(JsonMetrics.JsonMeter jsonMeter, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            json.writeStringField("name", jsonMeter.name());
            json.writeObjectField(this.timestampFieldname, (Object)jsonMeter.timestampAsDate());
            Meter meter = (Meter)jsonMeter.value();
            json.writeNumberField("count", meter.getCount());
            json.writeNumberField("m15_rate", meter.getOneMinuteRate() * this.rateFactor);
            json.writeNumberField("m1_rate", meter.getFifteenMinuteRate() * this.rateFactor);
            json.writeNumberField("m5_rate", meter.getFiveMinuteRate() * this.rateFactor);
            json.writeNumberField("mean_rate", meter.getMeanRate() * this.rateFactor);
            json.writeStringField("units", this.rateUnit);
            json.writeEndObject();
        }
    }

    private static class HistogramSerializer
    extends StdSerializer<JsonMetrics.JsonHistogram> {
        private final String timestampFieldname;

        private HistogramSerializer(String timestampFieldname) {
            super(JsonMetrics.JsonHistogram.class);
            this.timestampFieldname = timestampFieldname;
        }

        public void serialize(JsonMetrics.JsonHistogram jsonHistogram, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            json.writeStringField("name", jsonHistogram.name());
            json.writeObjectField(this.timestampFieldname, (Object)jsonHistogram.timestampAsDate());
            Histogram histogram = (Histogram)jsonHistogram.value();
            Snapshot snapshot = histogram.getSnapshot();
            json.writeNumberField("count", histogram.getCount());
            json.writeNumberField("max", snapshot.getMax());
            json.writeNumberField("mean", snapshot.getMean());
            json.writeNumberField("min", snapshot.getMin());
            json.writeNumberField("p50", snapshot.getMedian());
            json.writeNumberField("p75", snapshot.get75thPercentile());
            json.writeNumberField("p95", snapshot.get95thPercentile());
            json.writeNumberField("p98", snapshot.get98thPercentile());
            json.writeNumberField("p99", snapshot.get99thPercentile());
            json.writeNumberField("p999", snapshot.get999thPercentile());
            json.writeNumberField("stddev", snapshot.getStdDev());
            json.writeEndObject();
        }
    }

    private static class CounterSerializer
    extends StdSerializer<JsonMetrics.JsonCounter> {
        private final String timestampFieldname;

        private CounterSerializer(String timestampFieldname) {
            super(JsonMetrics.JsonCounter.class);
            this.timestampFieldname = timestampFieldname;
        }

        public void serialize(JsonMetrics.JsonCounter counter, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            json.writeStringField("name", counter.name());
            json.writeObjectField(this.timestampFieldname, (Object)counter.timestampAsDate());
            json.writeNumberField("count", ((Counter)counter.value()).getCount());
            json.writeEndObject();
        }
    }

    private static class GaugeSerializer
    extends StdSerializer<JsonMetrics.JsonGauge> {
        private final String timestampFieldname;

        private GaugeSerializer(String timestampFieldname) {
            super(JsonMetrics.JsonGauge.class);
            this.timestampFieldname = timestampFieldname;
        }

        public void serialize(JsonMetrics.JsonGauge gauge, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            json.writeStringField("name", gauge.name());
            json.writeObjectField(this.timestampFieldname, (Object)gauge.timestampAsDate());
            try {
                Object value = ((Gauge)gauge.value()).getValue();
                json.writeObjectField("value", value);
            }
            catch (RuntimeException e) {
                json.writeObjectField("error", (Object)e.toString());
            }
            json.writeEndObject();
        }
    }
}

