/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.mocksocket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.PrivilegedActionException;

public class MockSocket
extends Socket {
    public MockSocket() {
    }

    public MockSocket(Proxy proxy) {
        super(proxy);
    }

    public MockSocket(String host, int port) throws IOException {
        super(host, port);
    }

    public MockSocket(InetAddress address, int port) throws IOException {
        super(address, port);
    }

    public MockSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        super(host, port, localAddr, localPort);
    }

    public MockSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        super(address, port, localAddr, localPort);
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        try {
            AccessController.doPrivileged(() -> {
                MockSocket.super.connect(endpoint, timeout);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        try {
            AccessController.doPrivileged(() -> {
                MockSocket.super.bind(bindpoint);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }
}

