/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex.remote;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.elasticsearch.Version;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;

final class RemoteRequestBuilders {
    private RemoteRequestBuilders() {
    }

    static String initialSearchPath(SearchRequest searchRequest) {
        StringBuilder path = new StringBuilder("/");
        RemoteRequestBuilders.addIndexesOrTypes(path, "Index", searchRequest.indices());
        RemoteRequestBuilders.addIndexesOrTypes(path, "Type", searchRequest.types());
        path.append("_search");
        return path.toString();
    }

    static Map<String, String> initialSearchParams(SearchRequest searchRequest, Version remoteVersion) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (searchRequest.scroll() != null) {
            params.put("scroll", searchRequest.scroll().keepAlive().toString());
        }
        params.put("size", Integer.toString(searchRequest.source().size()));
        if (searchRequest.source().version() == null || searchRequest.source().version().booleanValue()) {
            params.put("version", null);
        }
        if (searchRequest.source().sorts() != null) {
            boolean useScan = false;
            if (remoteVersion.before(Version.V_2_1_0)) {
                for (SortBuilder sort : searchRequest.source().sorts()) {
                    FieldSortBuilder f;
                    if (!(sort instanceof FieldSortBuilder) || !(f = (FieldSortBuilder)sort).getFieldName().equals("_doc")) continue;
                    useScan = true;
                    break;
                }
            }
            if (useScan) {
                params.put("search_type", "scan");
            } else {
                StringBuilder sorts = new StringBuilder(RemoteRequestBuilders.sortToUri((SortBuilder)searchRequest.source().sorts().get(0)));
                for (int i = 1; i < searchRequest.source().sorts().size(); ++i) {
                    sorts.append(',').append(RemoteRequestBuilders.sortToUri((SortBuilder)searchRequest.source().sorts().get(i)));
                }
                params.put("sort", sorts.toString());
            }
        }
        if (remoteVersion.before(Version.V_2_0_0)) {
            searchRequest.source().storedField("_parent").storedField("_routing").storedField("_ttl");
        }
        if (searchRequest.source().storedFields() != null && !searchRequest.source().storedFields().fieldNames().isEmpty()) {
            StringBuilder fields = new StringBuilder((String)searchRequest.source().storedFields().fieldNames().get(0));
            for (int i = 1; i < searchRequest.source().storedFields().fieldNames().size(); ++i) {
                fields.append(',').append((String)searchRequest.source().storedFields().fieldNames().get(i));
            }
            String storedFieldsParamName = remoteVersion.before(Version.V_5_0_0_alpha4) ? "fields" : "stored_fields";
            params.put(storedFieldsParamName, fields.toString());
        }
        return params;
    }

    /*
     * Exception decompiling
     */
    static HttpEntity initialSearchEntity(SearchRequest searchRequest, BytesReference query) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void addIndexesOrTypes(StringBuilder path, String name, String[] indicesOrTypes) {
        if (indicesOrTypes == null || indicesOrTypes.length == 0) {
            return;
        }
        for (String indexOrType : indicesOrTypes) {
            RemoteRequestBuilders.checkIndexOrType(name, indexOrType);
        }
        path.append(Strings.arrayToCommaDelimitedString((Object[])indicesOrTypes)).append('/');
    }

    private static void checkIndexOrType(String name, String indexOrType) {
        if (indexOrType.indexOf(44) >= 0) {
            throw new IllegalArgumentException(name + " containing [,] not supported but got [" + indexOrType + "]");
        }
        if (indexOrType.indexOf(47) >= 0) {
            throw new IllegalArgumentException(name + " containing [/] not supported but got [" + indexOrType + "]");
        }
    }

    private static String sortToUri(SortBuilder<?> sort) {
        if (sort instanceof FieldSortBuilder) {
            FieldSortBuilder f = (FieldSortBuilder)sort;
            return f.getFieldName() + ":" + f.order();
        }
        throw new IllegalArgumentException("Unsupported sort [" + sort + "]");
    }

    static String scrollPath() {
        return "/_search/scroll";
    }

    static Map<String, String> scrollParams(TimeValue keepAlive) {
        return Collections.singletonMap("scroll", keepAlive.toString());
    }

    static HttpEntity scrollEntity(String scroll) {
        return new StringEntity(scroll, ContentType.TEXT_PLAIN);
    }
}

