/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.HashMap;
import java.util.function.Consumer;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.bulk.byscroll.DeleteByQueryRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.reindex.AbstractBulkByQueryRestHandler;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;

public class RestDeleteByQueryAction
extends AbstractBulkByQueryRestHandler<DeleteByQueryRequest, DeleteByQueryAction> {
    public RestDeleteByQueryAction(Settings settings, RestController controller) {
        super(settings, DeleteByQueryAction.INSTANCE);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_delete_by_query", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_delete_by_query", (RestHandler)this);
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return this.doPrepareRequest(request, client, false, false);
    }

    @Override
    protected DeleteByQueryRequest buildRequest(RestRequest request) throws IOException {
        if (!request.hasContent()) {
            throw new ElasticsearchException("_delete_by_query requires a request body", new Object[0]);
        }
        DeleteByQueryRequest internal = new DeleteByQueryRequest(new SearchRequest());
        HashMap<String, Consumer<Object>> consumers = new HashMap<String, Consumer<Object>>();
        consumers.put("conflicts", o -> internal.setConflicts((String)o));
        this.parseInternalRequest(internal, request, consumers);
        return internal;
    }
}

