/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.Retry;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.ClientScrollableHitSource;
import org.elasticsearch.index.reindex.ReindexSslConfig;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.index.reindex.WorkerBulkByScrollTaskState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.UpdateScript;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class AbstractAsyncBulkByScrollAction<Request extends AbstractBulkByScrollRequest<Request>, Action extends TransportAction<Request, ?>> {
    protected final Logger logger;
    protected final BulkByScrollTask task;
    protected final WorkerBulkByScrollTaskState worker;
    protected final ThreadPool threadPool;
    protected final ScriptService scriptService;
    protected final ReindexSslConfig sslConfig;
    protected final Request mainRequest;
    private final AtomicLong startTime = new AtomicLong(-1L);
    private final Set<String> destinationIndices = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ParentTaskAssigningClient searchClient;
    private final ParentTaskAssigningClient bulkClient;
    private final ActionListener<BulkByScrollResponse> listener;
    private final Retry bulkRetry;
    private final ScrollableHitSource scrollSource;
    private final BiFunction<RequestWrapper<?>, ScrollableHitSource.Hit, RequestWrapper<?>> scriptApplier;
    private int lastBatchSize;
    private final AtomicInteger totalBatchSizeInSingleScrollResponse = new AtomicInteger();

    AbstractAsyncBulkByScrollAction(BulkByScrollTask task, boolean needsSourceDocumentVersions, boolean needsSourceDocumentSeqNoAndPrimaryTerm, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, Request mainRequest, ActionListener<BulkByScrollResponse> listener, @Nullable ScriptService scriptService, @Nullable ReindexSslConfig sslConfig) {
        this(task, needsSourceDocumentVersions, needsSourceDocumentSeqNoAndPrimaryTerm, logger, client, client, threadPool, mainRequest, listener, scriptService, sslConfig);
    }

    AbstractAsyncBulkByScrollAction(BulkByScrollTask task, boolean needsSourceDocumentVersions, boolean needsSourceDocumentSeqNoAndPrimaryTerm, Logger logger, ParentTaskAssigningClient searchClient, ParentTaskAssigningClient bulkClient, ThreadPool threadPool, Request mainRequest, ActionListener<BulkByScrollResponse> listener, @Nullable ScriptService scriptService, @Nullable ReindexSslConfig sslConfig) {
        this.task = task;
        this.scriptService = scriptService;
        this.sslConfig = sslConfig;
        if (!task.isWorker()) {
            throw new IllegalArgumentException("Given task [" + task.getId() + "] must have a child worker");
        }
        this.worker = task.getWorkerState();
        this.logger = logger;
        this.searchClient = searchClient;
        this.bulkClient = bulkClient;
        this.threadPool = threadPool;
        this.mainRequest = mainRequest;
        this.listener = listener;
        BackoffPolicy backoffPolicy = this.buildBackoffPolicy();
        this.bulkRetry = new Retry(BackoffPolicy.wrap((BackoffPolicy)backoffPolicy, () -> ((WorkerBulkByScrollTaskState)this.worker).countBulkRetry()), (Scheduler)threadPool);
        this.scrollSource = this.buildScrollableResultSource(backoffPolicy);
        this.scriptApplier = Objects.requireNonNull(this.buildScriptApplier(), "script applier must not be null");
        SearchSourceBuilder sourceBuilder = mainRequest.getSearchRequest().source();
        List sorts = sourceBuilder.sorts();
        if (sorts == null || sorts.isEmpty()) {
            sourceBuilder.sort((SortBuilder)SortBuilders.fieldSort((String)"_doc"));
        }
        sourceBuilder.version(Boolean.valueOf(needsSourceDocumentVersions));
        sourceBuilder.seqNoAndPrimaryTerm(Boolean.valueOf(needsSourceDocumentSeqNoAndPrimaryTerm));
    }

    public BiFunction<RequestWrapper<?>, ScrollableHitSource.Hit, RequestWrapper<?>> buildScriptApplier() {
        return (request, searchHit) -> request;
    }

    protected abstract RequestWrapper<?> buildRequest(ScrollableHitSource.Hit var1);

    protected RequestWrapper<?> copyMetadata(RequestWrapper<?> request, ScrollableHitSource.Hit doc) {
        this.copyRouting(request, doc.getRouting());
        return request;
    }

    protected void copyRouting(RequestWrapper<?> request, String routing) {
        request.setRouting(routing);
    }

    protected boolean accept(ScrollableHitSource.Hit doc) {
        if (doc.getSource() == null) {
            throw new IllegalArgumentException("[" + doc.getIndex() + "][" + doc.getType() + "][" + doc.getId() + "] didn't store _source");
        }
        return true;
    }

    private BulkRequest buildBulk(Iterable<? extends ScrollableHitSource.Hit> docs) {
        BulkRequest bulkRequest = new BulkRequest();
        for (ScrollableHitSource.Hit hit : docs) {
            RequestWrapper<?> request;
            if (!this.accept(hit) || (request = this.scriptApplier.apply(this.copyMetadata(this.buildRequest(hit), hit), hit)) == null) continue;
            bulkRequest.add(request.self());
        }
        return bulkRequest;
    }

    protected ScrollableHitSource buildScrollableResultSource(BackoffPolicy backoffPolicy) {
        return new ClientScrollableHitSource(this.logger, backoffPolicy, this.threadPool, () -> ((WorkerBulkByScrollTaskState)this.worker).countSearchRetry(), this::onScrollResponse, this::finishHim, this.searchClient, this.mainRequest.getSearchRequest());
    }

    protected BulkByScrollResponse buildResponse(TimeValue took, List<BulkItemResponse.Failure> indexingFailures, List<ScrollableHitSource.SearchFailure> searchFailures, boolean timedOut) {
        return new BulkByScrollResponse(took, this.task.getStatus(), indexingFailures, searchFailures, timedOut);
    }

    public void start() {
        this.logger.debug("[{}]: starting", (Object)this.task.getId());
        if (this.task.isCancelled()) {
            this.logger.debug("[{}]: finishing early because the task was cancelled", (Object)this.task.getId());
            this.finishHim(null);
            return;
        }
        try {
            this.startTime.set(System.nanoTime());
            this.scrollSource.start();
        }
        catch (Exception e) {
            this.finishHim(e);
        }
    }

    void onScrollResponse(ScrollableHitSource.AsyncResponse asyncResponse) {
        this.onScrollResponse(new ScrollConsumableHitsResponse(asyncResponse));
    }

    void onScrollResponse(ScrollConsumableHitsResponse asyncResponse) {
        this.onScrollResponse(System.nanoTime(), this.lastBatchSize, asyncResponse);
    }

    void onScrollResponse(long lastBatchStartTimeNS, int lastBatchSize, final ScrollConsumableHitsResponse asyncResponse) {
        ScrollableHitSource.Response response = asyncResponse.response();
        this.logger.debug("[{}]: got scroll response with [{}] hits", (Object)this.task.getId(), (Object)asyncResponse.remainingHits());
        if (this.task.isCancelled()) {
            this.logger.debug("[{}]: finishing early because the task was cancelled", (Object)this.task.getId());
            this.finishHim(null);
            return;
        }
        if (response.getFailures().size() > 0 || response.isTimedOut()) {
            this.refreshAndFinish(Collections.emptyList(), response.getFailures(), response.isTimedOut());
            return;
        }
        long total = response.getTotalHits();
        if (this.mainRequest.getMaxDocs() > 0) {
            total = Math.min(total, (long)this.mainRequest.getMaxDocs());
        }
        this.worker.setTotal(total);
        AbstractRunnable prepareBulkRequestRunnable = new AbstractRunnable(){

            protected void doRun() throws Exception {
                AbstractAsyncBulkByScrollAction.this.prepareBulkRequest(System.nanoTime(), asyncResponse);
            }

            public void onFailure(Exception e) {
                AbstractAsyncBulkByScrollAction.this.finishHim(e);
            }
        };
        prepareBulkRequestRunnable = (AbstractRunnable)this.threadPool.getThreadContext().preserveContext((Runnable)prepareBulkRequestRunnable);
        this.worker.delayPrepareBulkRequest(this.threadPool, lastBatchStartTimeNS, lastBatchSize, prepareBulkRequestRunnable);
    }

    void prepareBulkRequest(long thisBatchStartTimeNS, ScrollConsumableHitsResponse asyncResponse) {
        long remainingDocsToProcess;
        this.logger.debug("[{}]: preparing bulk request", (Object)this.task.getId());
        if (this.task.isCancelled()) {
            this.logger.debug("[{}]: finishing early because the task was cancelled", (Object)this.task.getId());
            this.finishHim(null);
            return;
        }
        if (!asyncResponse.hasRemainingHits()) {
            this.refreshAndFinish(Collections.emptyList(), Collections.emptyList(), false);
            return;
        }
        this.worker.countBatch();
        List<? extends ScrollableHitSource.Hit> hits = this.mainRequest.getMaxDocs() != -1 ? ((remainingDocsToProcess = Math.max(0L, (long)this.mainRequest.getMaxDocs() - this.worker.getSuccessfullyProcessed())) < (long)asyncResponse.remainingHits() ? asyncResponse.consumeHits((int)remainingDocsToProcess) : asyncResponse.consumeRemainingHits()) : asyncResponse.consumeRemainingHits();
        BulkRequest request = this.buildBulk(hits);
        if (request.requests().isEmpty()) {
            this.notifyDone(thisBatchStartTimeNS, asyncResponse, 0);
            return;
        }
        request.timeout(this.mainRequest.getTimeout());
        request.waitForActiveShards(this.mainRequest.getWaitForActiveShards());
        this.sendBulkRequest(request, () -> this.notifyDone(thisBatchStartTimeNS, asyncResponse, request.requests().size()));
    }

    void sendBulkRequest(BulkRequest request, final Runnable onSuccess) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}]: sending [{}] entry, [{}] bulk request", (Object)this.task.getId(), (Object)request.requests().size(), (Object)new ByteSizeValue(request.estimatedSizeInBytes()));
        }
        if (this.task.isCancelled()) {
            this.logger.debug("[{}]: finishing early because the task was cancelled", (Object)this.task.getId());
            this.finishHim(null);
            return;
        }
        this.bulkRetry.withBackoff((arg_0, arg_1) -> ((ParentTaskAssigningClient)this.bulkClient).bulk(arg_0, arg_1), request, (ActionListener)new ActionListener<BulkResponse>(){

            public void onResponse(BulkResponse response) {
                AbstractAsyncBulkByScrollAction.this.onBulkResponse(response, onSuccess);
            }

            public void onFailure(Exception e) {
                AbstractAsyncBulkByScrollAction.this.finishHim(e);
            }
        });
    }

    void onBulkResponse(BulkResponse response, Runnable onSuccess) {
        try {
            ArrayList<BulkItemResponse.Failure> failures = new ArrayList<BulkItemResponse.Failure>();
            HashSet<String> destinationIndicesThisBatch = new HashSet<String>();
            for (BulkItemResponse item : response) {
                if (item.isFailed()) {
                    this.recordFailure(item.getFailure(), failures);
                    continue;
                }
                switch (item.getOpType()) {
                    case CREATE: 
                    case INDEX: {
                        if (item.getResponse().getResult() == DocWriteResponse.Result.CREATED) {
                            this.worker.countCreated();
                            break;
                        }
                        this.worker.countUpdated();
                        break;
                    }
                    case UPDATE: {
                        this.worker.countUpdated();
                        break;
                    }
                    case DELETE: {
                        this.worker.countDeleted();
                    }
                }
                destinationIndicesThisBatch.add(item.getIndex());
            }
            if (this.task.isCancelled()) {
                this.logger.debug("[{}]: Finishing early because the task was cancelled", (Object)this.task.getId());
                this.finishHim(null);
                return;
            }
            this.addDestinationIndices(destinationIndicesThisBatch);
            if (!failures.isEmpty()) {
                this.refreshAndFinish(Collections.unmodifiableList(failures), Collections.emptyList(), false);
                return;
            }
            if (this.mainRequest.getMaxDocs() != -1 && this.worker.getSuccessfullyProcessed() >= (long)this.mainRequest.getMaxDocs()) {
                this.refreshAndFinish(Collections.emptyList(), Collections.emptyList(), false);
                return;
            }
            onSuccess.run();
        }
        catch (Exception t) {
            this.finishHim(t);
        }
    }

    void notifyDone(long thisBatchStartTimeNS, ScrollConsumableHitsResponse asyncResponse, int batchSize) {
        if (this.task.isCancelled()) {
            this.logger.debug("[{}]: finishing early because the task was cancelled", (Object)this.task.getId());
            this.finishHim(null);
            return;
        }
        this.lastBatchSize = batchSize;
        this.totalBatchSizeInSingleScrollResponse.addAndGet(batchSize);
        if (!asyncResponse.hasRemainingHits()) {
            int totalBatchSize = this.totalBatchSizeInSingleScrollResponse.getAndSet(0);
            asyncResponse.done(this.worker.throttleWaitTime(thisBatchStartTimeNS, System.nanoTime(), totalBatchSize));
        } else {
            this.onScrollResponse(asyncResponse);
        }
    }

    private void recordFailure(BulkItemResponse.Failure failure, List<BulkItemResponse.Failure> failures) {
        if (failure.getStatus() == RestStatus.CONFLICT) {
            this.worker.countVersionConflict();
            if (!this.mainRequest.isAbortOnVersionConflict()) {
                return;
            }
        }
        failures.add(failure);
    }

    void refreshAndFinish(final List<BulkItemResponse.Failure> indexingFailures, final List<ScrollableHitSource.SearchFailure> searchFailures, final boolean timedOut) {
        if (this.task.isCancelled() || !this.mainRequest.isRefresh() || this.destinationIndices.isEmpty()) {
            this.finishHim(null, indexingFailures, searchFailures, timedOut);
            return;
        }
        RefreshRequest refresh = new RefreshRequest(new String[0]);
        refresh.indices(this.destinationIndices.toArray(new String[this.destinationIndices.size()]));
        this.logger.debug("[{}]: refreshing", (Object)this.task.getId());
        this.bulkClient.admin().indices().refresh(refresh, (ActionListener)new ActionListener<RefreshResponse>(){

            public void onResponse(RefreshResponse response) {
                AbstractAsyncBulkByScrollAction.this.finishHim(null, indexingFailures, searchFailures, timedOut);
            }

            public void onFailure(Exception e) {
                AbstractAsyncBulkByScrollAction.this.finishHim(e);
            }
        });
    }

    protected void finishHim(Exception failure) {
        this.logger.debug(() -> new ParameterizedMessage("[{}]: finishing with a catastrophic failure", (Object)this.task.getId()), (Throwable)failure);
        this.finishHim(failure, Collections.emptyList(), Collections.emptyList(), false);
    }

    protected void finishHim(Exception failure, List<BulkItemResponse.Failure> indexingFailures, List<ScrollableHitSource.SearchFailure> searchFailures, boolean timedOut) {
        this.logger.debug("[{}]: finishing without any catastrophic failures", (Object)this.task.getId());
        this.scrollSource.close(() -> {
            if (failure == null) {
                BulkByScrollResponse response = this.buildResponse(TimeValue.timeValueNanos((long)(System.nanoTime() - this.startTime.get())), indexingFailures, searchFailures, timedOut);
                this.listener.onResponse((Object)response);
            } else {
                this.listener.onFailure(failure);
            }
        });
    }

    BackoffPolicy buildBackoffPolicy() {
        return BackoffPolicy.exponentialBackoff((TimeValue)this.mainRequest.getRetryBackoffInitialTime(), (int)this.mainRequest.getMaxRetries());
    }

    void addDestinationIndices(Collection<String> indices) {
        this.destinationIndices.addAll(indices);
    }

    void setScroll(String scroll) {
        this.scrollSource.setScroll(scroll);
    }

    public static RequestWrapper<IndexRequest> wrap(IndexRequest request) {
        return new IndexRequestWrapper(request);
    }

    public static RequestWrapper<DeleteRequest> wrap(DeleteRequest request) {
        return new DeleteRequestWrapper(request);
    }

    public static interface RequestWrapper<Self extends DocWriteRequest<Self>> {
        public void setIndex(String var1);

        public String getIndex();

        public void setType(String var1);

        public String getType();

        public void setId(String var1);

        public String getId();

        public void setVersion(long var1);

        public long getVersion();

        public void setVersionType(VersionType var1);

        public void setRouting(String var1);

        public String getRouting();

        public void setSource(Map<String, Object> var1);

        public Map<String, Object> getSource();

        public Self self();
    }

    static class ScrollConsumableHitsResponse {
        private final ScrollableHitSource.AsyncResponse asyncResponse;
        private final List<? extends ScrollableHitSource.Hit> hits;
        private int consumedOffset = 0;

        ScrollConsumableHitsResponse(ScrollableHitSource.AsyncResponse asyncResponse) {
            this.asyncResponse = asyncResponse;
            this.hits = asyncResponse.response().getHits();
        }

        ScrollableHitSource.Response response() {
            return this.asyncResponse.response();
        }

        List<? extends ScrollableHitSource.Hit> consumeRemainingHits() {
            return this.consumeHits(this.remainingHits());
        }

        List<? extends ScrollableHitSource.Hit> consumeHits(int numberOfHits) {
            if (numberOfHits < 0) {
                throw new IllegalArgumentException("Invalid number of hits to consume [" + numberOfHits + "]");
            }
            if (numberOfHits > this.remainingHits()) {
                throw new IllegalArgumentException("Unable to provide [" + numberOfHits + "] hits as there are only [" + this.remainingHits() + "] hits available");
            }
            int start = this.consumedOffset;
            this.consumedOffset += numberOfHits;
            return this.hits.subList(start, this.consumedOffset);
        }

        boolean hasRemainingHits() {
            return this.remainingHits() > 0;
        }

        int remainingHits() {
            return this.hits.size() - this.consumedOffset;
        }

        void done(TimeValue extraKeepAlive) {
            this.asyncResponse.done(extraKeepAlive);
        }
    }

    public static class IndexRequestWrapper
    implements RequestWrapper<IndexRequest> {
        private final IndexRequest request;

        IndexRequestWrapper(IndexRequest request) {
            this.request = Objects.requireNonNull(request, "Wrapped IndexRequest can not be null");
        }

        @Override
        public void setIndex(String index) {
            this.request.index(index);
        }

        @Override
        public String getIndex() {
            return this.request.index();
        }

        @Override
        public void setType(String type) {
            this.request.type(type);
        }

        @Override
        public String getType() {
            return this.request.type();
        }

        @Override
        public void setId(String id) {
            this.request.id(id);
        }

        @Override
        public String getId() {
            return this.request.id();
        }

        @Override
        public void setVersion(long version) {
            this.request.version(version);
        }

        @Override
        public long getVersion() {
            return this.request.version();
        }

        @Override
        public void setVersionType(VersionType versionType) {
            this.request.versionType(versionType);
        }

        @Override
        public void setRouting(String routing) {
            this.request.routing(routing);
        }

        @Override
        public String getRouting() {
            return this.request.routing();
        }

        @Override
        public Map<String, Object> getSource() {
            return this.request.sourceAsMap();
        }

        @Override
        public void setSource(Map<String, Object> source) {
            this.request.source(source);
        }

        @Override
        public IndexRequest self() {
            return this.request;
        }
    }

    public static class DeleteRequestWrapper
    implements RequestWrapper<DeleteRequest> {
        private final DeleteRequest request;

        DeleteRequestWrapper(DeleteRequest request) {
            this.request = Objects.requireNonNull(request, "Wrapped DeleteRequest can not be null");
        }

        @Override
        public void setIndex(String index) {
            this.request.index(index);
        }

        @Override
        public String getIndex() {
            return this.request.index();
        }

        @Override
        public void setType(String type) {
            this.request.type(type);
        }

        @Override
        public String getType() {
            return this.request.type();
        }

        @Override
        public void setId(String id) {
            this.request.id(id);
        }

        @Override
        public String getId() {
            return this.request.id();
        }

        @Override
        public void setVersion(long version) {
            this.request.version(version);
        }

        @Override
        public long getVersion() {
            return this.request.version();
        }

        @Override
        public void setVersionType(VersionType versionType) {
            this.request.versionType(versionType);
        }

        @Override
        public void setRouting(String routing) {
            this.request.routing(routing);
        }

        @Override
        public String getRouting() {
            return this.request.routing();
        }

        @Override
        public Map<String, Object> getSource() {
            throw new UnsupportedOperationException("unable to get source from action request [" + this.request.getClass() + "]");
        }

        @Override
        public void setSource(Map<String, Object> source) {
            throw new UnsupportedOperationException("unable to set [source] on action request [" + this.request.getClass() + "]");
        }

        @Override
        public DeleteRequest self() {
            return this.request;
        }
    }

    public static enum OpType {
        NOOP("noop"),
        INDEX("index"),
        DELETE("delete");

        private final String id;

        private OpType(String id) {
            this.id = id;
        }

        public static OpType fromString(String opType) {
            String lowerOpType;
            switch (lowerOpType = opType.toLowerCase(Locale.ROOT)) {
                case "noop": {
                    return NOOP;
                }
                case "index": {
                    return INDEX;
                }
                case "delete": {
                    return DELETE;
                }
            }
            throw new IllegalArgumentException("Operation type [" + lowerOpType + "] not allowed, only " + Arrays.toString((Object[])OpType.values()) + " are allowed");
        }

        public String toString() {
            return this.id.toLowerCase(Locale.ROOT);
        }
    }

    public static abstract class ScriptApplier
    implements BiFunction<RequestWrapper<?>, ScrollableHitSource.Hit, RequestWrapper<?>> {
        private final WorkerBulkByScrollTaskState taskWorker;
        private final ScriptService scriptService;
        private final Script script;
        private final Map<String, Object> params;

        public ScriptApplier(WorkerBulkByScrollTaskState taskWorker, ScriptService scriptService, Script script, Map<String, Object> params) {
            this.taskWorker = taskWorker;
            this.scriptService = scriptService;
            this.script = script;
            this.params = params;
        }

        @Override
        public RequestWrapper<?> apply(RequestWrapper<?> request, ScrollableHitSource.Hit doc) {
            OpType newOpType;
            if (this.script == null) {
                return request;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("_index", doc.getIndex());
            context.put("_type", doc.getType());
            context.put("_id", doc.getId());
            Long oldVersion = doc.getVersion();
            context.put("_version", oldVersion);
            String oldRouting = doc.getRouting();
            context.put("_routing", oldRouting);
            context.put("_source", request.getSource());
            OpType oldOpType = OpType.INDEX;
            context.put("op", oldOpType.toString());
            UpdateScript.Factory factory = (UpdateScript.Factory)this.scriptService.compile(this.script, UpdateScript.CONTEXT);
            UpdateScript updateScript = factory.newInstance(this.params, context);
            updateScript.execute();
            String newOp = (String)context.remove("op");
            if (newOp == null) {
                throw new IllegalArgumentException("Script cleared operation type");
            }
            request.setSource((Map)context.remove("_source"));
            Object newValue = context.remove("_index");
            if (!doc.getIndex().equals(newValue)) {
                this.scriptChangedIndex(request, newValue);
            }
            newValue = context.remove("_type");
            if (!doc.getType().equals(newValue)) {
                this.scriptChangedType(request, newValue);
            }
            newValue = context.remove("_id");
            if (!doc.getId().equals(newValue)) {
                this.scriptChangedId(request, newValue);
            }
            if (!Objects.equals(oldVersion, newValue = context.remove("_version"))) {
                this.scriptChangedVersion(request, newValue);
            }
            if (!Objects.equals(oldRouting, newValue = context.remove("_routing"))) {
                this.scriptChangedRouting(request, newValue);
            }
            if ((newOpType = OpType.fromString(newOp)) != oldOpType) {
                return this.scriptChangedOpType(request, oldOpType, newOpType);
            }
            if (!context.isEmpty()) {
                throw new IllegalArgumentException("Invalid fields added to context [" + String.join((CharSequence)",", context.keySet()) + ']');
            }
            return request;
        }

        protected RequestWrapper<?> scriptChangedOpType(RequestWrapper<?> request, OpType oldOpType, OpType newOpType) {
            switch (newOpType) {
                case NOOP: {
                    this.taskWorker.countNoop();
                    return null;
                }
                case DELETE: {
                    RequestWrapper<DeleteRequest> delete = AbstractAsyncBulkByScrollAction.wrap(new DeleteRequest(request.getIndex(), request.getType(), request.getId()));
                    delete.setVersion(request.getVersion());
                    delete.setVersionType(VersionType.INTERNAL);
                    delete.setRouting(request.getRouting());
                    return delete;
                }
            }
            throw new IllegalArgumentException("Unsupported operation type change from [" + (Object)((Object)oldOpType) + "] to [" + (Object)((Object)newOpType) + "]");
        }

        protected abstract void scriptChangedIndex(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedType(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedId(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedVersion(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedRouting(RequestWrapper<?> var1, Object var2);
    }
}

