/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.reindex.AbstractBaseReindexRestHandler;
import org.elasticsearch.index.reindex.ReindexAction;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;

public class RestReindexAction
extends AbstractBaseReindexRestHandler<ReindexRequest, ReindexAction> {
    public RestReindexAction(Settings settings, RestController controller) {
        super(settings, ReindexAction.INSTANCE);
        controller.registerHandler(RestRequest.Method.POST, "/_reindex", (RestHandler)this);
    }

    public String getName() {
        return "reindex_action";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return this.doPrepareRequest(request, client, true, true);
    }

    @Override
    protected ReindexRequest buildRequest(RestRequest request) throws IOException {
        ReindexRequest internal;
        if (request.hasParam("pipeline")) {
            throw new IllegalArgumentException("_reindex doesn't support [pipeline] as a query parameter. Specify it in the [dest] object instead.");
        }
        try (XContentParser parser = request.contentParser();){
            internal = ReindexRequest.fromXContent((XContentParser)parser);
        }
        if (request.hasParam("scroll")) {
            internal.setScroll(TimeValue.parseTimeValue((String)request.param("scroll"), (String)"scroll"));
        }
        return internal;
    }
}

