/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.netty4.Netty4HttpRequest;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.http.netty4.cors.Netty4CorsHandler;
import org.elasticsearch.http.netty4.pipelining.HttpPipelinedRequest;
import org.elasticsearch.rest.AbstractRestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.netty4.Netty4Utils;

final class Netty4HttpChannel
extends AbstractRestChannel {
    private final Netty4HttpServerTransport transport;
    private final Channel channel;
    private final FullHttpRequest nettyRequest;
    private final HttpPipelinedRequest pipelinedRequest;
    private final ThreadContext threadContext;
    private static final HttpResponseStatus TOO_MANY_REQUESTS = new HttpResponseStatus(429, "Too Many Requests");
    private static Map<RestStatus, HttpResponseStatus> MAP;

    Netty4HttpChannel(Netty4HttpServerTransport transport, Netty4HttpRequest request, HttpPipelinedRequest pipelinedRequest, boolean detailedErrorsEnabled, ThreadContext threadContext) {
        super((RestRequest)request, detailedErrorsEnabled);
        this.transport = transport;
        this.channel = request.getChannel();
        this.nettyRequest = request.request();
        this.pipelinedRequest = pipelinedRequest;
        this.threadContext = threadContext;
    }

    protected BytesStreamOutput newBytesOutput() {
        return new ReleasableBytesStreamOutput(this.transport.bigArrays);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(RestResponse response) {
        ByteBuf buffer = Netty4Utils.toByteBuf(response.content());
        FullHttpResponse resp = HttpMethod.HEAD.equals((Object)this.nettyRequest.method()) ? this.newResponse(Unpooled.EMPTY_BUFFER) : this.newResponse(buffer);
        resp.setStatus(Netty4HttpChannel.getStatus(response.status()));
        Netty4CorsHandler.setCorsResponseHeaders((HttpRequest)this.nettyRequest, (HttpResponse)resp, this.transport.getCorsConfig());
        String opaque = this.nettyRequest.headers().get("X-Opaque-Id");
        if (opaque != null) {
            this.setHeaderField((HttpResponse)resp, "X-Opaque-Id", opaque);
        }
        this.addCustomHeaders((HttpResponse)resp, response.getHeaders());
        this.addCustomHeaders((HttpResponse)resp, this.threadContext.getResponseHeaders());
        BytesReference content = response.content();
        boolean releaseContent = content instanceof Releasable;
        boolean releaseBytesStreamOutput = this.bytesOutputOrNull() instanceof ReleasableBytesStreamOutput;
        try {
            this.setHeaderField((HttpResponse)resp, HttpHeaderNames.CONTENT_TYPE.toString(), response.contentType(), false);
            this.setHeaderField((HttpResponse)resp, HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(buffer.readableBytes()), false);
            this.addCookies((HttpResponse)resp);
            ChannelPromise promise = this.channel.newPromise();
            if (releaseContent) {
                promise.addListener(f -> ((Releasable)content).close());
            }
            if (releaseBytesStreamOutput) {
                promise.addListener(f -> this.bytesOutputOrNull().close());
            }
            if (this.isCloseConnection()) {
                promise.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
            Object msg = this.pipelinedRequest != null ? this.pipelinedRequest.createHttpResponse(resp, promise) : resp;
            this.channel.writeAndFlush(msg, promise);
            releaseContent = false;
            releaseBytesStreamOutput = false;
        }
        finally {
            if (releaseContent) {
                ((Releasable)content).close();
            }
            if (releaseBytesStreamOutput) {
                this.bytesOutputOrNull().close();
            }
            if (this.pipelinedRequest != null) {
                this.pipelinedRequest.release();
            }
        }
    }

    private void setHeaderField(HttpResponse resp, String headerField, String value) {
        this.setHeaderField(resp, headerField, value, true);
    }

    private void setHeaderField(HttpResponse resp, String headerField, String value, boolean override) {
        if (override || !resp.headers().contains(headerField)) {
            resp.headers().add(headerField, (Object)value);
        }
    }

    private void addCookies(HttpResponse resp) {
        Set cookies;
        String cookieString;
        if (this.transport.resetCookies && (cookieString = this.nettyRequest.headers().get("Cookie")) != null && !(cookies = ServerCookieDecoder.STRICT.decode(cookieString)).isEmpty()) {
            resp.headers().set((CharSequence)HttpHeaderNames.SET_COOKIE, (Iterable)ServerCookieEncoder.STRICT.encode((Collection)cookies));
        }
    }

    private void addCustomHeaders(HttpResponse response, Map<String, List<String>> customHeaders) {
        if (customHeaders != null) {
            for (Map.Entry<String, List<String>> headerEntry : customHeaders.entrySet()) {
                for (String headerValue : headerEntry.getValue()) {
                    this.setHeaderField(response, headerEntry.getKey(), headerValue);
                }
            }
        }
    }

    private boolean isHttp10() {
        return this.nettyRequest.protocolVersion().equals((Object)HttpVersion.HTTP_1_0);
    }

    private boolean isCloseConnection() {
        boolean http10 = this.isHttp10();
        return HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)this.nettyRequest.headers().get((CharSequence)HttpHeaderNames.CONNECTION)) || http10 && !HttpHeaderValues.KEEP_ALIVE.contentEqualsIgnoreCase((CharSequence)this.nettyRequest.headers().get((CharSequence)HttpHeaderNames.CONNECTION));
    }

    private FullHttpResponse newResponse(ByteBuf buffer) {
        DefaultFullHttpResponse response;
        boolean http10 = this.isHttp10();
        boolean close = this.isCloseConnection();
        HttpResponseStatus status = HttpResponseStatus.OK;
        if (http10) {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_0, status, buffer);
            if (!close) {
                response.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)"Keep-Alive");
            }
        } else {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, buffer);
        }
        return response;
    }

    private static HttpResponseStatus getStatus(RestStatus status) {
        return MAP.getOrDefault(status, HttpResponseStatus.INTERNAL_SERVER_ERROR);
    }

    static {
        EnumMap<RestStatus, HttpResponseStatus> map = new EnumMap<RestStatus, HttpResponseStatus>(RestStatus.class);
        map.put(RestStatus.CONTINUE, HttpResponseStatus.CONTINUE);
        map.put(RestStatus.SWITCHING_PROTOCOLS, HttpResponseStatus.SWITCHING_PROTOCOLS);
        map.put(RestStatus.OK, HttpResponseStatus.OK);
        map.put(RestStatus.CREATED, HttpResponseStatus.CREATED);
        map.put(RestStatus.ACCEPTED, HttpResponseStatus.ACCEPTED);
        map.put(RestStatus.NON_AUTHORITATIVE_INFORMATION, HttpResponseStatus.NON_AUTHORITATIVE_INFORMATION);
        map.put(RestStatus.NO_CONTENT, HttpResponseStatus.NO_CONTENT);
        map.put(RestStatus.RESET_CONTENT, HttpResponseStatus.RESET_CONTENT);
        map.put(RestStatus.PARTIAL_CONTENT, HttpResponseStatus.PARTIAL_CONTENT);
        map.put(RestStatus.MULTI_STATUS, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        map.put(RestStatus.MULTIPLE_CHOICES, HttpResponseStatus.MULTIPLE_CHOICES);
        map.put(RestStatus.MOVED_PERMANENTLY, HttpResponseStatus.MOVED_PERMANENTLY);
        map.put(RestStatus.FOUND, HttpResponseStatus.FOUND);
        map.put(RestStatus.SEE_OTHER, HttpResponseStatus.SEE_OTHER);
        map.put(RestStatus.NOT_MODIFIED, HttpResponseStatus.NOT_MODIFIED);
        map.put(RestStatus.USE_PROXY, HttpResponseStatus.USE_PROXY);
        map.put(RestStatus.TEMPORARY_REDIRECT, HttpResponseStatus.TEMPORARY_REDIRECT);
        map.put(RestStatus.BAD_REQUEST, HttpResponseStatus.BAD_REQUEST);
        map.put(RestStatus.UNAUTHORIZED, HttpResponseStatus.UNAUTHORIZED);
        map.put(RestStatus.PAYMENT_REQUIRED, HttpResponseStatus.PAYMENT_REQUIRED);
        map.put(RestStatus.FORBIDDEN, HttpResponseStatus.FORBIDDEN);
        map.put(RestStatus.NOT_FOUND, HttpResponseStatus.NOT_FOUND);
        map.put(RestStatus.METHOD_NOT_ALLOWED, HttpResponseStatus.METHOD_NOT_ALLOWED);
        map.put(RestStatus.NOT_ACCEPTABLE, HttpResponseStatus.NOT_ACCEPTABLE);
        map.put(RestStatus.PROXY_AUTHENTICATION, HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED);
        map.put(RestStatus.REQUEST_TIMEOUT, HttpResponseStatus.REQUEST_TIMEOUT);
        map.put(RestStatus.CONFLICT, HttpResponseStatus.CONFLICT);
        map.put(RestStatus.GONE, HttpResponseStatus.GONE);
        map.put(RestStatus.LENGTH_REQUIRED, HttpResponseStatus.LENGTH_REQUIRED);
        map.put(RestStatus.PRECONDITION_FAILED, HttpResponseStatus.PRECONDITION_FAILED);
        map.put(RestStatus.REQUEST_ENTITY_TOO_LARGE, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
        map.put(RestStatus.REQUEST_URI_TOO_LONG, HttpResponseStatus.REQUEST_URI_TOO_LONG);
        map.put(RestStatus.UNSUPPORTED_MEDIA_TYPE, HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE);
        map.put(RestStatus.REQUESTED_RANGE_NOT_SATISFIED, HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE);
        map.put(RestStatus.EXPECTATION_FAILED, HttpResponseStatus.EXPECTATION_FAILED);
        map.put(RestStatus.UNPROCESSABLE_ENTITY, HttpResponseStatus.BAD_REQUEST);
        map.put(RestStatus.LOCKED, HttpResponseStatus.BAD_REQUEST);
        map.put(RestStatus.FAILED_DEPENDENCY, HttpResponseStatus.BAD_REQUEST);
        map.put(RestStatus.TOO_MANY_REQUESTS, TOO_MANY_REQUESTS);
        map.put(RestStatus.INTERNAL_SERVER_ERROR, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        map.put(RestStatus.NOT_IMPLEMENTED, HttpResponseStatus.NOT_IMPLEMENTED);
        map.put(RestStatus.BAD_GATEWAY, HttpResponseStatus.BAD_GATEWAY);
        map.put(RestStatus.SERVICE_UNAVAILABLE, HttpResponseStatus.SERVICE_UNAVAILABLE);
        map.put(RestStatus.GATEWAY_TIMEOUT, HttpResponseStatus.GATEWAY_TIMEOUT);
        map.put(RestStatus.HTTP_VERSION_NOT_SUPPORTED, HttpResponseStatus.HTTP_VERSION_NOT_SUPPORTED);
        MAP = Collections.unmodifiableMap(map);
    }
}

