/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.concurrent.CompletableContext;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class Netty4TcpChannel
implements TcpChannel {
    private final Channel channel;
    private final String profile;
    private final CompletableContext<Void> connectContext;
    private final CompletableContext<Void> closeContext = new CompletableContext();

    Netty4TcpChannel(Channel channel, String profile, @Nullable ChannelFuture connectFuture) {
        this.channel = channel;
        this.profile = profile;
        this.connectContext = new CompletableContext();
        this.channel.closeFuture().addListener(f -> {
            if (f.isSuccess()) {
                this.closeContext.complete(null);
            } else {
                Throwable cause = f.cause();
                if (cause instanceof Error) {
                    ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
                    this.closeContext.completeExceptionally(new Exception(cause));
                } else {
                    this.closeContext.completeExceptionally((Exception)cause);
                }
            }
        });
        connectFuture.addListener(f -> {
            if (f.isSuccess()) {
                this.connectContext.complete(null);
            } else {
                Throwable cause = f.cause();
                if (cause instanceof Error) {
                    ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
                    this.connectContext.completeExceptionally(new Exception(cause));
                } else {
                    this.connectContext.completeExceptionally((Exception)cause);
                }
            }
        });
    }

    public void close() {
        this.channel.close();
    }

    public String getProfile() {
        return this.profile;
    }

    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.addListener(ActionListener.toBiConsumer(listener));
    }

    public void addConnectListener(ActionListener<Void> listener) {
        this.connectContext.addListener(ActionListener.toBiConsumer(listener));
    }

    public void setSoLinger(int value) throws IOException {
        if (this.channel.isOpen()) {
            try {
                this.channel.config().setOption(ChannelOption.SO_LINGER, (Object)value);
            }
            catch (ChannelException e) {
                throw new IOException(e);
            }
        }
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    public void sendMessage(BytesReference reference, ActionListener<Void> listener) {
        ChannelPromise writePromise = this.channel.newPromise();
        writePromise.addListener(f -> {
            if (f.isSuccess()) {
                listener.onResponse(null);
            } else {
                Throwable cause = f.cause();
                ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
                if (cause instanceof Error) {
                    listener.onFailure(new Exception(cause));
                } else {
                    listener.onFailure((Exception)cause);
                }
            }
        });
        this.channel.writeAndFlush((Object)Netty4Utils.toByteBuf(reference), writePromise);
        if (this.channel.eventLoop().isShutdown()) {
            listener.onFailure((Exception)new TransportException("Cannot send message, event loop is shutting down."));
        }
    }

    public Channel getNettyChannel() {
        return this.channel;
    }

    public String toString() {
        return "Netty4TcpChannel{localAddress=" + this.getLocalAddress() + ", remoteAddress=" + this.channel.remoteAddress() + '}';
    }
}

