/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.transport.Transports;

public final class Netty4WriteThrottlingHandler
extends ChannelDuplexHandler {
    public static final int MAX_BYTES_PER_WRITE = 262144;
    private final Queue<WriteOperation> queuedWrites = new ArrayDeque<WriteOperation>();
    private final ThreadContext threadContext;
    private WriteOperation currentWrite;

    public Netty4WriteThrottlingHandler(ThreadContext threadContext) {
        this.threadContext = threadContext;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        assert (msg instanceof ByteBuf);
        assert (Transports.assertDefaultThreadContext((ThreadContext)this.threadContext));
        assert (Transports.assertTransportThread());
        ByteBuf buf = (ByteBuf)msg;
        if (ctx.channel().isWritable() && this.currentWrite == null && this.queuedWrites.isEmpty()) {
            if (buf.readableBytes() > 262144) {
                this.writeInSlices(ctx, promise, buf);
            } else {
                ctx.write(msg, promise);
            }
        } else {
            this.queueWrite(buf, promise);
        }
    }

    private void writeInSlices(ChannelHandlerContext ctx, ChannelPromise promise, ByteBuf buf) {
        do {
            int bufferSize;
            int readableBytes;
            if ((readableBytes = buf.readableBytes()) == (bufferSize = Math.min(readableBytes, 262144))) {
                ctx.write((Object)buf).addListener(Netty4WriteThrottlingHandler.forwardResultListener(ctx, promise));
                return;
            }
            int readerIndex = buf.readerIndex();
            ByteBuf writeBuffer = buf.retainedSlice(readerIndex, bufferSize);
            buf.readerIndex(readerIndex + bufferSize);
            ctx.write((Object)writeBuffer).addListener(Netty4WriteThrottlingHandler.forwardFailureListener(ctx, promise));
        } while (ctx.channel().isWritable());
        this.queueWrite(buf, promise);
    }

    private void queueWrite(ByteBuf buf, ChannelPromise promise) {
        boolean queued = this.queuedWrites.offer(new WriteOperation(buf, promise));
        assert (queued);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        if (ctx.channel().isWritable()) {
            this.doFlush(ctx);
        }
        ctx.fireChannelWritabilityChanged();
    }

    public void flush(ChannelHandlerContext ctx) {
        if (!this.doFlush(ctx)) {
            ctx.flush();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.doFlush(ctx);
        super.channelInactive(ctx);
    }

    private boolean doFlush(ChannelHandlerContext ctx) {
        assert (ctx.executor().inEventLoop());
        Channel channel = ctx.channel();
        if (!channel.isActive()) {
            this.failQueuedWrites();
            return false;
        }
        while (channel.isWritable()) {
            ByteBuf writeBuffer;
            boolean sliced;
            if (this.currentWrite == null) {
                this.currentWrite = this.queuedWrites.poll();
            }
            if (this.currentWrite == null) break;
            WriteOperation write = this.currentWrite;
            int readableBytes = write.buf.readableBytes();
            int bufferSize = Math.min(readableBytes, 262144);
            int readerIndex = write.buf.readerIndex();
            boolean bl = sliced = readableBytes != bufferSize;
            if (sliced) {
                writeBuffer = write.buf.retainedSlice(readerIndex, bufferSize);
                write.buf.readerIndex(readerIndex + bufferSize);
            } else {
                writeBuffer = write.buf;
            }
            ChannelFuture writeFuture = ctx.write((Object)writeBuffer);
            if (!sliced) {
                this.currentWrite = null;
                writeFuture.addListener(Netty4WriteThrottlingHandler.forwardResultListener(ctx, write.promise));
                continue;
            }
            writeFuture.addListener(Netty4WriteThrottlingHandler.forwardFailureListener(ctx, write.promise));
        }
        ctx.flush();
        if (!channel.isActive()) {
            this.failQueuedWrites();
        }
        return true;
    }

    private static GenericFutureListener<Future<Void>> forwardFailureListener(ChannelHandlerContext ctx, ChannelPromise promise) {
        return future -> {
            assert (ctx.executor().inEventLoop());
            if (!future.isSuccess()) {
                promise.tryFailure(future.cause());
            }
        };
    }

    private static GenericFutureListener<Future<Void>> forwardResultListener(ChannelHandlerContext ctx, ChannelPromise promise) {
        return future -> {
            assert (ctx.executor().inEventLoop());
            if (future.isSuccess()) {
                promise.trySuccess();
            } else {
                promise.tryFailure(future.cause());
            }
        };
    }

    private void failQueuedWrites() {
        WriteOperation queuedWrite;
        if (this.currentWrite != null) {
            WriteOperation current = this.currentWrite;
            this.currentWrite = null;
            current.failAsClosedChannel();
        }
        while ((queuedWrite = this.queuedWrites.poll()) != null) {
            queuedWrite.failAsClosedChannel();
        }
    }

    private record WriteOperation(ByteBuf buf, ChannelPromise promise) {
        void failAsClosedChannel() {
            this.promise.tryFailure((Throwable)new ClosedChannelException());
            this.buf.release();
        }
    }
}

