/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.NettyRuntime;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.transport.netty4.NettyAllocator;

public class Netty4Utils {
    private static final AtomicBoolean isAvailableProcessorsSet = new AtomicBoolean();

    public static void setAvailableProcessors(int availableProcessors) {
        boolean set = Booleans.parseBoolean((String)System.getProperty("es.set.netty.runtime.available.processors", "true"));
        if (!set) {
            return;
        }
        if (isAvailableProcessorsSet.compareAndSet(false, true)) {
            NettyRuntime.setAvailableProcessors((int)availableProcessors);
        } else if (availableProcessors != NettyRuntime.availableProcessors()) {
            String message = String.format(Locale.ROOT, "available processors value [%d] did not match current value [%d]", availableProcessors, NettyRuntime.availableProcessors());
            throw new IllegalStateException(message);
        }
    }

    public static ByteBuf toByteBuf(BytesReference reference) {
        if (reference.length() == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        BytesRefIterator iterator = reference.iterator();
        ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>(3);
        try {
            BytesRef slice;
            while ((slice = iterator.next()) != null) {
                buffers.add(Unpooled.wrappedBuffer((byte[])slice.bytes, (int)slice.offset, (int)slice.length));
            }
            if (buffers.size() == 1) {
                return (ByteBuf)buffers.get(0);
            }
            CompositeByteBuf composite = Unpooled.compositeBuffer((int)buffers.size());
            composite.addComponents(true, buffers);
            return composite;
        }
        catch (IOException ex) {
            throw new AssertionError("no IO happens here", ex);
        }
    }

    public static BytesReference toBytesReference(ByteBuf buffer) {
        int readableBytes = buffer.readableBytes();
        if (readableBytes == 0) {
            return BytesArray.EMPTY;
        }
        if (buffer.hasArray()) {
            return new BytesArray(buffer.array(), buffer.arrayOffset() + buffer.readerIndex(), readableBytes);
        }
        ByteBuffer[] byteBuffers = buffer.nioBuffers();
        return BytesReference.fromByteBuffers((ByteBuffer[])byteBuffers);
    }

    public static Recycler<BytesRef> createRecycler(Settings settings) {
        Netty4Utils.setAvailableProcessors(EsExecutors.allocatedProcessors((Settings)settings));
        return NettyAllocator.getRecycler();
    }
}

