/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import java.io.IOException;
import java.nio.CharBuffer;
import java.util.Locale;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.WriteRequestBuilder;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.security.action.user.ChangePasswordRequest;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.support.Validation;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.security.xcontent.XContentUtils;
import org.elasticsearch.xpack.security.action.user.TransportChangePasswordAction;

public class ChangePasswordRequestBuilder
extends ActionRequestBuilder<ChangePasswordRequest, ActionResponse.Empty>
implements WriteRequestBuilder<ChangePasswordRequestBuilder> {
    public ChangePasswordRequestBuilder(ElasticsearchClient client) {
        super(client, TransportChangePasswordAction.TYPE, (ActionRequest)new ChangePasswordRequest());
    }

    public ChangePasswordRequestBuilder username(String username) {
        ((ChangePasswordRequest)this.request).username(username);
        return this;
    }

    public static char[] validateAndHashPassword(SecureString password, Hasher hasher) {
        Validation.Error error = Validation.Users.validatePassword((SecureString)password);
        if (error != null) {
            throw ChangePasswordRequestBuilder.validationException(error.toString());
        }
        return hasher.hash(password);
    }

    public ChangePasswordRequestBuilder password(char[] password, Hasher hasher) {
        try (SecureString secureString = new SecureString(password);){
            char[] hash = ChangePasswordRequestBuilder.validateAndHashPassword(secureString, hasher);
            if (((ChangePasswordRequest)this.request).passwordHash() != null) {
                throw ChangePasswordRequestBuilder.validationException("password_hash has already been set");
            }
            ((ChangePasswordRequest)this.request).passwordHash(hash);
        }
        return this;
    }

    public ChangePasswordRequestBuilder passwordHash(char[] passwordHashChars, Hasher configuredHasher) {
        Hasher resolvedHasher = Hasher.resolveFromHash((char[])passwordHashChars);
        if (!resolvedHasher.equals((Object)configuredHasher) && !Hasher.getAvailableAlgoStoredHash().contains(resolvedHasher.name().toLowerCase(Locale.ROOT))) {
            throw new IllegalArgumentException("The provided password hash is not a hash or it could not be resolved to a supported hash algorithm. The supported password hash algorithms are " + Hasher.getAvailableAlgoStoredHash().toString());
        }
        if (((ChangePasswordRequest)this.request).passwordHash() != null) {
            throw ChangePasswordRequestBuilder.validationException("password_hash has already been set");
        }
        ((ChangePasswordRequest)this.request).passwordHash(passwordHashChars);
        return this;
    }

    public ChangePasswordRequestBuilder source(BytesReference source, XContentType xContentType, Hasher hasher) throws IOException {
        try (XContentParser parser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)LoggingDeprecationHandler.XCONTENT_PARSER_CONFIG, (BytesReference)source, (XContentType)xContentType);){
            XContentParser.Token token;
            XContentUtils.verifyObject((XContentParser)parser);
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (User.Fields.PASSWORD.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        String password = parser.text();
                        char[] passwordChars = password.toCharArray();
                        this.password(passwordChars, hasher);
                        assert (CharBuffer.wrap(passwordChars).chars().noneMatch(i -> (char)i != '\u0000')) : "expected password to clear the char[] but it did not!";
                        continue;
                    }
                    throw new ElasticsearchParseException("expected field [{}] to be of type string, but found [{}] instead", new Object[]{currentFieldName, token});
                }
                if (User.Fields.PASSWORD_HASH.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        char[] passwordHashChars = parser.text().toCharArray();
                        this.passwordHash(passwordHashChars, hasher);
                        continue;
                    }
                    throw new ElasticsearchParseException("expected field [{}] to be of type string, but found [{}] instead", new Object[]{currentFieldName, token});
                }
                throw new ElasticsearchParseException("failed to parse change password request. unexpected field [{}]", new Object[]{currentFieldName});
            }
        }
        return this;
    }

    private static ValidationException validationException(String message) {
        ValidationException validationException = new ValidationException();
        validationException.addValidationError(message);
        return validationException;
    }
}

