/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.util.Map;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.support.BearerToken;
import org.elasticsearch.xpack.security.authc.Authenticator;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.UserToken;
import org.elasticsearch.xpack.security.metric.InstrumentedSecurityActionListener;
import org.elasticsearch.xpack.security.metric.SecurityMetricType;
import org.elasticsearch.xpack.security.metric.SecurityMetrics;

class OAuth2TokenAuthenticator
implements Authenticator {
    public static final String ATTRIBUTE_AUTHC_FAILURE_REASON = "es.security.token_authc_failure_reason";
    private static final Logger logger = LogManager.getLogger(OAuth2TokenAuthenticator.class);
    private final SecurityMetrics<BearerToken> authenticationMetrics;
    private final TokenService tokenService;

    OAuth2TokenAuthenticator(TokenService tokenService, MeterRegistry meterRegistry) {
        this(tokenService, meterRegistry, System::nanoTime);
    }

    OAuth2TokenAuthenticator(TokenService tokenService, MeterRegistry meterRegistry, LongSupplier nanoTimeSupplier) {
        this.authenticationMetrics = new SecurityMetrics<BearerToken>(SecurityMetricType.AUTHC_OAUTH2_TOKEN, meterRegistry, this::buildMetricAttributes, nanoTimeSupplier);
        this.tokenService = tokenService;
    }

    @Override
    public String name() {
        return "oauth2 token";
    }

    @Override
    public AuthenticationToken extractCredentials(Authenticator.Context context) {
        SecureString bearerString = context.getBearerString();
        return bearerString == null ? null : new BearerToken(bearerString);
    }

    @Override
    public void authenticate(Authenticator.Context context, ActionListener<AuthenticationResult<Authentication>> listener) {
        AuthenticationToken authenticationToken = context.getMostRecentAuthenticationToken();
        if (!(authenticationToken instanceof BearerToken)) {
            listener.onResponse((Object)AuthenticationResult.notHandled());
            return;
        }
        BearerToken bearerToken = (BearerToken)authenticationToken;
        this.doAuthenticate(context, bearerToken, InstrumentedSecurityActionListener.wrapForAuthc(this.authenticationMetrics, bearerToken, listener));
    }

    private void doAuthenticate(Authenticator.Context context, BearerToken bearerToken, ActionListener<AuthenticationResult<Authentication>> listener) {
        this.tokenService.tryAuthenticateToken(bearerToken.credentials(), (ActionListener<UserToken>)ActionListener.wrap(userToken -> {
            if (userToken != null) {
                listener.onResponse((Object)AuthenticationResult.success((Object)userToken.getAuthentication()));
            } else {
                listener.onResponse((Object)AuthenticationResult.unsuccessful((String)"invalid token", null));
            }
        }, e -> {
            logger.debug(() -> "Failed to validate token authentication for request [" + context.getRequest() + "]", (Throwable)e);
            if (e instanceof ElasticsearchSecurityException && !TokenService.isExpiredTokenException((ElasticsearchSecurityException)((Object)((Object)e)))) {
                context.getRequest().tamperedRequest();
            }
            listener.onFailure(e);
        }));
    }

    private Map<String, Object> buildMetricAttributes(BearerToken token, String failureReason) {
        if (failureReason != null) {
            return Map.of(ATTRIBUTE_AUTHC_FAILURE_REASON, failureReason);
        }
        return Map.of();
    }
}

