/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.controls.AuthorizationIdentityRequestControl;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.CharArrays;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.ActiveDirectorySessionFactorySettings;
import org.elasticsearch.xpack.core.security.authc.ldap.PoolingSessionFactorySettings;
import org.elasticsearch.xpack.core.security.authc.ldap.support.LdapSearchScope;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.ldap.ActiveDirectoryGroupsResolver;
import org.elasticsearch.xpack.security.authc.ldap.PoolingSessionFactory;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapMetadataResolver;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;

class ActiveDirectorySessionFactory
extends PoolingSessionFactory {
    private static final String NETBIOS_NAME_FILTER_TEMPLATE = "(netbiosname={0})";
    final DefaultADAuthenticator defaultADAuthenticator;
    final DownLevelADAuthenticator downLevelADAuthenticator;
    final UpnADAuthenticator upnADAuthenticator;

    ActiveDirectorySessionFactory(RealmConfig config, SSLService sslService, ThreadPool threadPool) throws LDAPException {
        super(config, sslService, new ActiveDirectoryGroupsResolver(config), (Setting.AffixSetting<Boolean>)ActiveDirectorySessionFactorySettings.POOL_ENABLED, config.hasSetting(PoolingSessionFactorySettings.BIND_DN) ? ActiveDirectorySessionFactory.getBindDN(config) : null, () -> {
            String healthCheckDn;
            if (config.hasSetting(PoolingSessionFactorySettings.BIND_DN) && (healthCheckDn = (String)config.getSetting(PoolingSessionFactorySettings.BIND_DN)).isEmpty() && healthCheckDn.indexOf(61) > 0) {
                return healthCheckDn;
            }
            return (String)config.getSetting(ActiveDirectorySessionFactorySettings.AD_USER_SEARCH_BASEDN_SETTING, () -> (String)config.getSetting(ActiveDirectorySessionFactorySettings.AD_DOMAIN_NAME_SETTING));
        }, threadPool);
        String domainName = (String)config.getSetting(ActiveDirectorySessionFactorySettings.AD_DOMAIN_NAME_SETTING);
        String domainDN = ActiveDirectorySessionFactory.buildDnFromDomain(domainName);
        int ldapPort = (Integer)config.getSetting(ActiveDirectorySessionFactorySettings.AD_LDAP_PORT_SETTING);
        int ldapsPort = (Integer)config.getSetting(ActiveDirectorySessionFactorySettings.AD_LDAPS_PORT_SETTING);
        int gcLdapPort = (Integer)config.getSetting(ActiveDirectorySessionFactorySettings.AD_GC_LDAP_PORT_SETTING);
        int gcLdapsPort = (Integer)config.getSetting(ActiveDirectorySessionFactorySettings.AD_GC_LDAPS_PORT_SETTING);
        this.defaultADAuthenticator = new DefaultADAuthenticator(config, this.timeout, this.ignoreReferralErrors, this.logger, this.groupResolver, this.metadataResolver, domainDN, threadPool, this::getBindRequest);
        this.downLevelADAuthenticator = new DownLevelADAuthenticator(config, this.timeout, this.ignoreReferralErrors, this.logger, this.groupResolver, this.metadataResolver, domainDN, sslService, threadPool, ldapPort, ldapsPort, gcLdapPort, gcLdapsPort, this::getBindRequest);
        this.upnADAuthenticator = new UpnADAuthenticator(config, this.timeout, this.ignoreReferralErrors, this.logger, this.groupResolver, this.metadataResolver, domainDN, threadPool, this::getBindRequest);
    }

    @Override
    protected List<String> getDefaultLdapUrls(RealmConfig config) {
        return Collections.singletonList("ldap://" + (String)config.getSetting(ActiveDirectorySessionFactorySettings.AD_DOMAIN_NAME_SETTING) + ":" + config.getSetting(ActiveDirectorySessionFactorySettings.AD_LDAP_PORT_SETTING));
    }

    @Override
    public boolean supportsUnauthenticatedSession() {
        return true;
    }

    @Override
    void getSessionWithPool(LDAPConnectionPool connectionPool, String user, SecureString password, ActionListener<LdapSession> listener) {
        this.getADAuthenticator(user).authenticate(connectionPool, user, password, this.threadPool, listener);
    }

    @Override
    void getSessionWithoutPool(String username, SecureString password, ActionListener<LdapSession> listener) {
        try {
            LDAPConnection connection = (LDAPConnection)LdapUtils.privilegedConnect(() -> ((ServerSet)this.serverSet).getConnection());
            this.getADAuthenticator(username).authenticate(connection, username, password, (ActionListener<LdapSession>)ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> {
                IOUtils.closeWhileHandlingException((Closeable)connection);
                listener.onFailure(e);
            }));
        }
        catch (LDAPException e2) {
            listener.onFailure((Exception)((Object)e2));
        }
    }

    @Override
    void getUnauthenticatedSessionWithPool(LDAPConnectionPool connectionPool, String user, ActionListener<LdapSession> listener) {
        this.getADAuthenticator(user).searchForDN((LDAPInterface)connectionPool, user, null, Math.toIntExact(this.timeout.seconds()), (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
            if (entry == null) {
                listener.onResponse(null);
            } else {
                String dn = entry.getDN();
                listener.onResponse((Object)new LdapSession(this.logger, this.config, (LDAPInterface)connectionPool, dn, this.groupResolver, this.metadataResolver, this.timeout, null));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    void getUnauthenticatedSessionWithoutPool(final String user, final ActionListener<LdapSession> listener) {
        if (!this.config.hasSetting(PoolingSessionFactorySettings.BIND_DN)) {
            listener.onResponse(null);
            return;
        }
        try {
            final LDAPConnection connection = (LDAPConnection)LdapUtils.privilegedConnect(() -> ((ServerSet)this.serverSet).getConnection());
            LdapUtils.maybeForkThenBind(connection, (BindRequest)this.getBindRequest(), true, this.threadPool, new AbstractRunnable(){

                public void onFailure(Exception e) {
                    IOUtils.closeWhileHandlingException((Closeable)connection);
                    listener.onFailure(e);
                }

                protected void doRun() throws Exception {
                    ActiveDirectorySessionFactory.this.getADAuthenticator(user).searchForDN((LDAPInterface)connection, user, null, Math.toIntExact(ActiveDirectorySessionFactory.this.timeout.getSeconds()), (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
                        if (entry == null) {
                            IOUtils.close((Closeable)connection);
                            listener.onResponse(null);
                        } else {
                            listener.onResponse((Object)new LdapSession(ActiveDirectorySessionFactory.this.logger, ActiveDirectorySessionFactory.this.config, (LDAPInterface)connection, entry.getDN(), ActiveDirectorySessionFactory.this.groupResolver, ActiveDirectorySessionFactory.this.metadataResolver, ActiveDirectorySessionFactory.this.timeout, null));
                        }
                    }, e -> {
                        IOUtils.closeWhileHandlingException((Closeable)connection);
                        listener.onFailure(e);
                    }));
                }
            });
        }
        catch (LDAPException e) {
            listener.onFailure((Exception)((Object)e));
        }
    }

    static String buildDnFromDomain(String domain) {
        return "DC=" + domain.replace(".", ",DC=");
    }

    static String getBindDN(RealmConfig config) {
        Object bindDN = (String)config.getSetting(PoolingSessionFactorySettings.BIND_DN);
        if (!((String)bindDN).isEmpty() && ((String)bindDN).indexOf(92) < 0 && ((String)bindDN).indexOf(64) < 0 && ((String)bindDN).indexOf(61) < 0) {
            bindDN = (String)bindDN + "@" + (String)config.getSetting(ActiveDirectorySessionFactorySettings.AD_DOMAIN_NAME_SETTING);
        }
        return bindDN;
    }

    ServerSet getServerSet() {
        return this.serverSet;
    }

    ADAuthenticator getADAuthenticator(String username) {
        if (username.indexOf(92) > 0) {
            return this.downLevelADAuthenticator;
        }
        if (username.indexOf(64) > 0) {
            return this.upnADAuthenticator;
        }
        return this.defaultADAuthenticator;
    }

    static class DefaultADAuthenticator
    extends ADAuthenticator {
        final String domainName;

        DefaultADAuthenticator(RealmConfig realm, TimeValue timeout, boolean ignoreReferralErrors, Logger logger, LdapSession.GroupsResolver groupsResolver, LdapMetadataResolver metadataResolver, String domainDN, ThreadPool threadPool, Supplier<SimpleBindRequest> bindRequestSupplier) {
            super(realm, timeout, ignoreReferralErrors, logger, groupsResolver, metadataResolver, domainDN, (Setting.AffixSetting<String>)ActiveDirectorySessionFactorySettings.AD_USER_SEARCH_FILTER_SETTING, "(&(objectClass=user)(|(sAMAccountName={0})(userPrincipalName={0}@" + DefaultADAuthenticator.domainName(realm) + ")))", threadPool, bindRequestSupplier);
            this.domainName = DefaultADAuthenticator.domainName(realm);
        }

        private static String domainName(RealmConfig realm) {
            return (String)realm.getSetting(ActiveDirectorySessionFactorySettings.AD_DOMAIN_NAME_SETTING);
        }

        @Override
        void searchForDN(LDAPInterface connection, String username, SecureString password, int timeLimitSeconds, ActionListener<SearchResultEntry> listener) {
            try {
                LdapUtils.searchForEntry(connection, this.userSearchDN, this.userSearchScope.scope(), LdapUtils.createFilter(this.userSearchFilter, username), timeLimitSeconds, this.ignoreReferralErrors, listener, LdapUtils.attributesToSearchFor(this.groupsResolver.attributes()));
            }
            catch (LDAPException e) {
                listener.onFailure((Exception)((Object)e));
            }
        }

        @Override
        String bindUsername(String username) {
            return username + "@" + this.domainName;
        }
    }

    static class DownLevelADAuthenticator
    extends ADAuthenticator {
        static final String DOWN_LEVEL_FILTER = "(&(objectClass=user)(sAMAccountName={0}))";
        Cache<String, String> domainNameCache = CacheBuilder.builder().setMaximumWeight(100L).build();
        final String domainDN;
        final SSLService sslService;
        final RealmConfig config;
        private final int ldapPort;
        private final int ldapsPort;
        private final int gcLdapPort;
        private final int gcLdapsPort;

        DownLevelADAuthenticator(RealmConfig config, TimeValue timeout, boolean ignoreReferralErrors, Logger logger, LdapSession.GroupsResolver groupsResolver, LdapMetadataResolver metadataResolver, String domainDN, SSLService sslService, ThreadPool threadPool, int ldapPort, int ldapsPort, int gcLdapPort, int gcLdapsPort, Supplier<SimpleBindRequest> bindRequestSupplier) {
            super(config, timeout, ignoreReferralErrors, logger, groupsResolver, metadataResolver, domainDN, (Setting.AffixSetting<String>)ActiveDirectorySessionFactorySettings.AD_DOWN_LEVEL_USER_SEARCH_FILTER_SETTING, DOWN_LEVEL_FILTER, threadPool, bindRequestSupplier);
            this.domainDN = domainDN;
            this.sslService = sslService;
            this.config = config;
            this.ldapPort = ldapPort;
            this.ldapsPort = ldapsPort;
            this.gcLdapPort = gcLdapPort;
            this.gcLdapsPort = gcLdapsPort;
        }

        @Override
        void searchForDN(LDAPInterface connection, String username, SecureString password, int timeLimitSeconds, ActionListener<SearchResultEntry> listener) {
            String[] parts = username.split("\\\\");
            assert (parts.length == 2);
            String netBiosDomainName = parts[0];
            String accountName = parts[1];
            this.netBiosDomainNameToDn(connection, netBiosDomainName, username, password, timeLimitSeconds, (ActionListener<String>)ActionListener.wrap(domainDN -> {
                if (domainDN == null) {
                    listener.onResponse(null);
                } else {
                    LdapUtils.searchForEntry(connection, domainDN, LdapSearchScope.SUB_TREE.scope(), LdapUtils.createFilter(this.userSearchFilter, accountName), timeLimitSeconds, this.ignoreReferralErrors, listener, LdapUtils.attributesToSearchFor(this.groupsResolver.attributes()));
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void netBiosDomainNameToDn(LDAPInterface ldapInterface, final String netBiosDomainName, String username, SecureString password, final int timeLimitSeconds, ActionListener<String> listener) {
            LDAPConnection ldapConnection = null;
            try {
                final Filter filter = LdapUtils.createFilter(ActiveDirectorySessionFactory.NETBIOS_NAME_FILTER_TEMPLATE, netBiosDomainName);
                String cachedName = (String)this.domainNameCache.get((Object)netBiosDomainName);
                if (cachedName != null) {
                    listener.onResponse((Object)cachedName);
                } else if (!this.usingGlobalCatalog(ldapInterface)) {
                    LdapUtils.search(ldapInterface, "CN=Configuration," + this.domainDN, LdapSearchScope.SUB_TREE.scope(), filter, timeLimitSeconds, this.ignoreReferralErrors, (ActionListener<List<SearchResultEntry>>)ActionListener.wrap(results -> DownLevelADAuthenticator.handleSearchResults(results, netBiosDomainName, this.domainNameCache, listener), arg_0 -> listener.onFailure(arg_0)), "ncname");
                } else {
                    ldapConnection = ldapInterface instanceof LDAPConnection ? (LDAPConnection)ldapInterface : (LDAPConnection)LdapUtils.privilegedConnect(() -> ((LDAPConnectionPool)((LDAPConnectionPool)ldapInterface)).getConnection());
                    LDAPConnection finalLdapConnection = ldapConnection;
                    final LDAPConnection searchConnection = (LDAPConnection)LdapUtils.privilegedConnect(() -> new LDAPConnection(finalLdapConnection.getSocketFactory(), ActiveDirectorySessionFactory.connectionOptions(this.config, this.sslService, this.logger), finalLdapConnection.getConnectedAddress(), finalLdapConnection.getSSLSession() != null ? this.ldapsPort : this.ldapPort));
                    byte[] passwordBytes = CharArrays.toUtf8Bytes((char[])password.getChars());
                    SimpleBindRequest bindRequest = (SimpleBindRequest)this.bindRequestSupplier.get();
                    boolean bindAsAuthenticatingUser = bindRequest.getBindDN().isEmpty();
                    SimpleBindRequest bind = bindAsAuthenticatingUser ? new SimpleBindRequest(username, passwordBytes) : bindRequest;
                    ActionRunnable<String> body = new ActionRunnable<String>(listener){

                        protected void doRun() throws Exception {
                            LdapUtils.search(searchConnection, "CN=Configuration," + domainDN, LdapSearchScope.SUB_TREE.scope(), filter, timeLimitSeconds, ignoreReferralErrors, (ActionListener<List<SearchResultEntry>>)ActionListener.wrap(results -> {
                                IOUtils.close((Closeable)searchConnection);
                                DownLevelADAuthenticator.handleSearchResults(results, netBiosDomainName, domainNameCache, (ActionListener<String>)this.listener);
                            }, e -> {
                                IOUtils.closeWhileHandlingException((Closeable)searchConnection);
                                this.listener.onFailure(e);
                            }), "ncname");
                        }

                        public void onFailure(Exception e) {
                            IOUtils.closeWhileHandlingException((Closeable)searchConnection);
                            this.listener.onFailure(e);
                        }
                    };
                    LdapUtils.maybeForkThenBind(searchConnection, (BindRequest)bind, !bindAsAuthenticatingUser, this.threadPool, (AbstractRunnable)body);
                }
                if (!(ldapInterface instanceof LDAPConnectionPool) || ldapConnection == null) return;
            }
            catch (LDAPException e) {
                listener.onFailure((Exception)((Object)e));
                return;
            }
            finally {
                if (ldapInterface instanceof LDAPConnectionPool && ldapConnection != null) {
                    ((LDAPConnectionPool)ldapInterface).releaseConnection(ldapConnection);
                }
            }
            ((LDAPConnectionPool)ldapInterface).releaseConnection(ldapConnection);
            return;
        }

        static void handleSearchResults(List<SearchResultEntry> results, String netBiosDomainName, Cache<String, String> domainNameCache, ActionListener<String> listener) {
            Optional<SearchResultEntry> entry = results.stream().filter(r -> r.hasAttribute("ncname")).findFirst();
            if (entry.isPresent()) {
                String value = entry.get().getAttributeValue("ncname");
                try {
                    domainNameCache.computeIfAbsent((Object)netBiosDomainName, s -> value);
                }
                catch (ExecutionException e) {
                    throw new AssertionError("failed to load constant non-null value", e);
                }
                listener.onResponse((Object)value);
            } else {
                listener.onResponse(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean usingGlobalCatalog(LDAPInterface ldap) throws LDAPException {
            boolean bl;
            block4: {
                if (ldap instanceof LDAPConnection) {
                    return this.usingGlobalCatalog((LDAPConnection)ldap);
                }
                LDAPConnectionPool pool = (LDAPConnectionPool)ldap;
                LDAPConnection connection = null;
                try {
                    connection = (LDAPConnection)LdapUtils.privilegedConnect(() -> ((LDAPConnectionPool)pool).getConnection());
                    bl = this.usingGlobalCatalog(connection);
                    if (connection == null) break block4;
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        pool.releaseConnection(connection);
                    }
                    throw throwable;
                }
                pool.releaseConnection(connection);
            }
            return bl;
        }

        private boolean usingGlobalCatalog(LDAPConnection ldapConnection) {
            return ldapConnection.getConnectedPort() == this.gcLdapPort || ldapConnection.getConnectedPort() == this.gcLdapsPort;
        }
    }

    static class UpnADAuthenticator
    extends ADAuthenticator {
        static final String UPN_USER_FILTER = "(&(objectClass=user)(userPrincipalName={1}))";
        private final DeprecationLogger deprecationLogger;

        UpnADAuthenticator(RealmConfig config, TimeValue timeout, boolean ignoreReferralErrors, Logger logger, LdapSession.GroupsResolver groupsResolver, LdapMetadataResolver metadataResolver, String domainDN, ThreadPool threadPool, Supplier<SimpleBindRequest> bindRequestSupplier) {
            super(config, timeout, ignoreReferralErrors, logger, groupsResolver, metadataResolver, domainDN, (Setting.AffixSetting<String>)ActiveDirectorySessionFactorySettings.AD_UPN_USER_SEARCH_FILTER_SETTING, UPN_USER_FILTER, threadPool, bindRequestSupplier);
            this.deprecationLogger = DeprecationLogger.getLogger((String)this.logger.getName());
            if (this.userSearchFilter.contains("{0}")) {
                this.deprecationLogger.warn(DeprecationCategory.SECURITY, "ldap_settings", "The use of the account name variable {0} in the setting [" + RealmSettings.getFullSettingKey((RealmConfig)config, (Setting.AffixSetting)ActiveDirectorySessionFactorySettings.AD_UPN_USER_SEARCH_FILTER_SETTING) + "] has been deprecated and will be removed in a future version!", new Object[0]);
            }
        }

        @Override
        void searchForDN(LDAPInterface connection, String username, SecureString password, int timeLimitSeconds, ActionListener<SearchResultEntry> listener) {
            String[] parts = username.split("@");
            assert (parts.length == 2) : "there should have only been two values for " + username + " after splitting on '@'";
            String accountName = parts[0];
            try {
                Filter filter = LdapUtils.createFilter(this.userSearchFilter, accountName, username);
                LdapUtils.searchForEntry(connection, this.userSearchDN, LdapSearchScope.SUB_TREE.scope(), filter, timeLimitSeconds, this.ignoreReferralErrors, listener, LdapUtils.attributesToSearchFor(this.groupsResolver.attributes()));
            }
            catch (LDAPException e) {
                listener.onFailure((Exception)((Object)e));
            }
        }
    }

    static abstract class ADAuthenticator {
        private final RealmConfig realm;
        final TimeValue timeout;
        final boolean ignoreReferralErrors;
        final Logger logger;
        final LdapSession.GroupsResolver groupsResolver;
        final LdapMetadataResolver metadataResolver;
        final String userSearchDN;
        final LdapSearchScope userSearchScope;
        final String userSearchFilter;
        final Supplier<SimpleBindRequest> bindRequestSupplier;
        final ThreadPool threadPool;

        ADAuthenticator(RealmConfig realm, TimeValue timeout, boolean ignoreReferralErrors, Logger logger, LdapSession.GroupsResolver groupsResolver, LdapMetadataResolver metadataResolver, String domainDN, Setting.AffixSetting<String> userSearchFilterSetting, String defaultUserSearchFilter, ThreadPool threadPool, Supplier<SimpleBindRequest> bindRequestSupplier) {
            this.realm = realm;
            this.timeout = timeout;
            this.ignoreReferralErrors = ignoreReferralErrors;
            this.logger = logger;
            this.groupsResolver = groupsResolver;
            this.metadataResolver = metadataResolver;
            this.bindRequestSupplier = bindRequestSupplier;
            this.threadPool = threadPool;
            this.userSearchDN = (String)realm.getSetting(ActiveDirectorySessionFactorySettings.AD_USER_SEARCH_BASEDN_SETTING, () -> domainDN);
            this.userSearchScope = LdapSearchScope.resolve((String)((String)realm.getSetting(ActiveDirectorySessionFactorySettings.AD_USER_SEARCH_SCOPE_SETTING)), (LdapSearchScope)LdapSearchScope.SUB_TREE);
            this.userSearchFilter = (String)realm.getSetting(userSearchFilterSetting, () -> defaultUserSearchFilter);
        }

        final void authenticate(final LDAPConnection connection, final String username, final SecureString password, ActionListener<LdapSession> listener) {
            byte[] passwordBytes = CharArrays.toUtf8Bytes((char[])password.getChars());
            SimpleBindRequest userBind = new SimpleBindRequest(this.bindUsername(username), passwordBytes, new Control[]{new AuthorizationIdentityRequestControl()});
            LdapUtils.maybeForkThenBind(connection, (BindRequest)userBind, false, this.threadPool, (AbstractRunnable)new ActionRunnable<LdapSession>(listener){

                protected void doRun() throws Exception {
                    ActionRunnable<LdapSession> searchRunnable = new ActionRunnable<LdapSession>(this.listener){

                        protected void doRun() throws Exception {
                            this.searchForDN((LDAPInterface)connection, username, password, Math.toIntExact(timeout.seconds()), (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
                                if (entry == null) {
                                    this.listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("search for user [" + username + "] by principal name yielded no results", new Object[0])));
                                } else {
                                    this.listener.onResponse((Object)new LdapSession(logger, realm, (LDAPInterface)connection, entry.getDN(), groupsResolver, metadataResolver, timeout, null));
                                }
                            }, e -> this.listener.onFailure(e)));
                        }
                    };
                    SimpleBindRequest bind = bindRequestSupplier.get();
                    if (bind.getBindDN().isEmpty()) {
                        searchRunnable.run();
                    } else {
                        LdapUtils.maybeForkThenBind(connection, (BindRequest)bind, true, threadPool, (AbstractRunnable)searchRunnable);
                    }
                }
            });
        }

        final void authenticate(final LDAPConnectionPool pool, final String username, final SecureString password, ThreadPool threadPool, ActionListener<LdapSession> listener) {
            byte[] passwordBytes = CharArrays.toUtf8Bytes((char[])password.getChars());
            SimpleBindRequest bind = new SimpleBindRequest(this.bindUsername(username), passwordBytes);
            LdapUtils.maybeForkThenBindAndRevert(pool, (BindRequest)bind, threadPool, (AbstractRunnable)new ActionRunnable<LdapSession>(listener){

                protected void doRun() throws Exception {
                    this.searchForDN((LDAPInterface)pool, username, password, Math.toIntExact(timeout.seconds()), (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
                        if (entry == null) {
                            this.listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("search for user [" + username + "] by principal name yielded no results", new Object[0])));
                        } else {
                            this.listener.onResponse((Object)new LdapSession(logger, realm, (LDAPInterface)pool, entry.getDN(), groupsResolver, metadataResolver, timeout, null));
                        }
                    }, e -> this.listener.onFailure(e)));
                }
            });
        }

        String bindUsername(String username) {
            return username;
        }

        final String getUserSearchFilter() {
            return this.userSearchFilter;
        }

        abstract void searchForDN(LDAPInterface var1, String var2, SecureString var3, int var4, ActionListener<SearchResultEntry> var5);
    }
}

