/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap.support;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.ldap.support.LdapMetadataResolverSettings;
import org.elasticsearch.xpack.security.authc.ldap.ActiveDirectorySIDUtil;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;

public class LdapMetadataResolver {
    private final String[] attributeNames;
    private final boolean ignoreReferralErrors;
    private final String fullNameAttributeName;
    private final String emailAttributeName;
    private final String[] allAttributeNamesToResolve;

    public LdapMetadataResolver(RealmConfig realmConfig, boolean ignoreReferralErrors) {
        this((String)realmConfig.getSetting(LdapMetadataResolverSettings.FULL_NAME_SETTING), (String)realmConfig.getSetting(LdapMetadataResolverSettings.EMAIL_SETTING), (Collection)realmConfig.getSetting(LdapMetadataResolverSettings.ADDITIONAL_METADATA_SETTING), ignoreReferralErrors);
    }

    LdapMetadataResolver(String fullNameAttributeName, String emailAttributeName, Collection<String> attributeNames, boolean ignoreReferralErrors) {
        this.fullNameAttributeName = fullNameAttributeName;
        this.emailAttributeName = emailAttributeName;
        this.attributeNames = attributeNames.toArray(new String[attributeNames.size()]);
        this.ignoreReferralErrors = ignoreReferralErrors;
        this.allAttributeNamesToResolve = (String[])Stream.concat(Stream.of(this.attributeNames), Stream.of(this.fullNameAttributeName, this.emailAttributeName)).distinct().toArray(String[]::new);
    }

    public String[] attributeNames() {
        return this.attributeNames;
    }

    public void resolve(LDAPInterface connection, String userDn, TimeValue timeout, Logger logger, Collection<Attribute> attributes, ActionListener<LdapMetadataResult> listener) {
        if (Strings.isEmpty((CharSequence)this.fullNameAttributeName) && Strings.isEmpty((CharSequence)this.emailAttributeName) && this.attributeNames.length == 0) {
            listener.onResponse((Object)LdapMetadataResult.EMPTY);
        } else if (attributes != null) {
            listener.onResponse((Object)this.toLdapMetadataResult(name -> LdapMetadataResolver.findAttribute(attributes, name)));
        } else {
            LdapUtils.searchForEntry(connection, userDn, SearchScope.BASE, LdapUtils.OBJECT_CLASS_PRESENCE_FILTER, Math.toIntExact(timeout.seconds()), this.ignoreReferralErrors, (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
                if (entry == null) {
                    listener.onResponse((Object)LdapMetadataResult.EMPTY);
                } else {
                    listener.onResponse((Object)this.toLdapMetadataResult(arg_0 -> ((SearchResultEntry)entry).getAttribute(arg_0)));
                }
            }, arg_0 -> listener.onFailure(arg_0)), this.allAttributeNamesToResolve);
        }
    }

    private static Attribute findAttribute(Collection<Attribute> attributes, String name) {
        return attributes.stream().filter(attr -> attr.getName().equals(name)).findFirst().orElse(null);
    }

    private static Object parseLdapAttributeValue(Attribute attr) {
        String[] values = attr.getValues();
        if (attr.getName().equals("tokenGroups")) {
            return values.length == 1 ? ActiveDirectorySIDUtil.convertToString(attr.getValueByteArrays()[0]) : Arrays.stream(attr.getValueByteArrays()).map(ActiveDirectorySIDUtil::convertToString).collect(Collectors.toList());
        }
        return values.length == 1 ? values[0] : List.of(values);
    }

    private LdapMetadataResult toLdapMetadataResult(Function<String, Attribute> attributes) {
        Attribute emailAttribute = attributes.apply(this.emailAttributeName);
        Attribute fullNameAttribute = attributes.apply(this.fullNameAttributeName);
        Map<String, Object> metaData = Arrays.stream(this.attributeNames).map(attributes).filter(Objects::nonNull).collect(Collectors.toUnmodifiableMap(Attribute::getName, LdapMetadataResolver::parseLdapAttributeValue));
        return new LdapMetadataResult(fullNameAttribute == null ? null : LdapMetadataResolver.parseLdapAttributeValue(fullNameAttribute).toString(), emailAttribute == null ? null : LdapMetadataResolver.parseLdapAttributeValue(emailAttribute).toString(), metaData);
    }

    public static class LdapMetadataResult {
        public static LdapMetadataResult EMPTY = new LdapMetadataResult(null, null, Map.of());
        private final String fullName;
        private final String email;
        private final Map<String, Object> metaData;

        public LdapMetadataResult(@Nullable String fullName, @Nullable String email, Map<String, Object> metaData) {
            this.fullName = fullName;
            this.email = email;
            this.metaData = metaData;
        }

        @Nullable
        public String getFullName() {
            return this.fullName;
        }

        @Nullable
        public String getEmail() {
            return this.email;
        }

        public Map<String, Object> getMetaData() {
            return this.metaData;
        }
    }
}

