/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.sniff;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;

public class HostsSniffer {
    private static final Log logger = LogFactory.getLog(HostsSniffer.class);
    private final RestClient restClient;
    private final Map<String, String> sniffRequestParams;
    private final Scheme scheme;
    private final JsonFactory jsonFactory = new JsonFactory();

    protected HostsSniffer(RestClient restClient, long sniffRequestTimeoutMillis, Scheme scheme) {
        this.restClient = restClient;
        this.sniffRequestParams = Collections.singletonMap("timeout", sniffRequestTimeoutMillis + "ms");
        this.scheme = scheme;
    }

    public List<HttpHost> sniffHosts() throws IOException {
        try (Response response = this.restClient.performRequest("get", "/_nodes/http", this.sniffRequestParams, null, new Header[0]);){
            List<HttpHost> list = this.readHosts(response.getEntity());
            return list;
        }
    }

    private List<HttpHost> readHosts(HttpEntity entity) throws IOException {
        try (InputStream inputStream = entity.getContent();){
            JsonParser parser = this.jsonFactory.createParser(inputStream);
            if (parser.nextToken() != JsonToken.START_OBJECT) {
                throw new IOException("expected data to start with an object");
            }
            ArrayList<HttpHost> hosts = new ArrayList<HttpHost>();
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                if (parser.getCurrentToken() != JsonToken.START_OBJECT) continue;
                if ("nodes".equals(parser.getCurrentName())) {
                    while (parser.nextToken() != JsonToken.END_OBJECT) {
                        JsonToken token = parser.nextToken();
                        assert (token == JsonToken.START_OBJECT);
                        String nodeId = parser.getCurrentName();
                        HttpHost sniffedHost = HostsSniffer.readHost(nodeId, parser, this.scheme);
                        if (sniffedHost == null) continue;
                        logger.trace((Object)("adding node [" + nodeId + "]"));
                        hosts.add(sniffedHost);
                    }
                    continue;
                }
                parser.skipChildren();
            }
            ArrayList<HttpHost> arrayList = hosts;
            return arrayList;
        }
    }

    private static HttpHost readHost(String nodeId, JsonParser parser, Scheme scheme) throws IOException {
        HttpHost httpHost = null;
        String fieldName = null;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            if (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                fieldName = parser.getCurrentName();
                continue;
            }
            if (parser.getCurrentToken() != JsonToken.START_OBJECT) continue;
            if ("http".equals(fieldName)) {
                while (parser.nextToken() != JsonToken.END_OBJECT) {
                    if (parser.getCurrentToken() == JsonToken.VALUE_STRING && "publish_address".equals(parser.getCurrentName())) {
                        URI boundAddressAsURI = URI.create((Object)((Object)scheme) + "://" + parser.getValueAsString());
                        httpHost = new HttpHost(boundAddressAsURI.getHost(), boundAddressAsURI.getPort(), boundAddressAsURI.getScheme());
                        continue;
                    }
                    if (parser.getCurrentToken() != JsonToken.START_OBJECT) continue;
                    parser.skipChildren();
                }
                continue;
            }
            parser.skipChildren();
        }
        if (httpHost == null) {
            logger.debug((Object)("skipping node [" + nodeId + "] with http disabled"));
            return null;
        }
        return httpHost;
    }

    public static Builder builder(RestClient restClient) {
        return new Builder(restClient);
    }

    public static class Builder {
        public static final long DEFAULT_SNIFF_REQUEST_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
        private final RestClient restClient;
        private long sniffRequestTimeoutMillis = DEFAULT_SNIFF_REQUEST_TIMEOUT;
        private Scheme scheme;

        private Builder(RestClient restClient) {
            Objects.requireNonNull(restClient, "restClient cannot be null");
            this.restClient = restClient;
        }

        public Builder setSniffRequestTimeoutMillis(int sniffRequestTimeoutMillis) {
            if (sniffRequestTimeoutMillis <= 0) {
                throw new IllegalArgumentException("sniffRequestTimeoutMillis must be greater than 0");
            }
            this.sniffRequestTimeoutMillis = sniffRequestTimeoutMillis;
            return this;
        }

        public Builder setScheme(Scheme scheme) {
            Objects.requireNonNull(scheme, "scheme cannot be null");
            this.scheme = scheme;
            return this;
        }

        public HostsSniffer build() {
            return new HostsSniffer(this.restClient, this.sniffRequestTimeoutMillis, this.scheme);
        }
    }

    public static enum Scheme {
        HTTP("http"),
        HTTPS("https");

        private final String name;

        private Scheme(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

