/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.sniff;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.sniff.HostsSniffer;

public final class Sniffer
implements Closeable {
    private static final Log logger = LogFactory.getLog(Sniffer.class);
    private final Task task;

    private Sniffer(RestClient restClient, HostsSniffer hostsSniffer, long sniffInterval, long sniffAfterFailureDelay) {
        this.task = new Task(hostsSniffer, restClient, sniffInterval, sniffAfterFailureDelay);
    }

    public void sniffOnFailure(HttpHost failedHost) {
        this.task.sniffOnFailure(failedHost);
    }

    @Override
    public void close() throws IOException {
        this.task.shutdown();
    }

    public static Builder builder(RestClient restClient, HostsSniffer hostsSniffer) {
        return new Builder(restClient, hostsSniffer);
    }

    public static final class Builder {
        public static final long DEFAULT_SNIFF_INTERVAL = TimeUnit.MINUTES.toMillis(5L);
        public static final long DEFAULT_SNIFF_AFTER_FAILURE_DELAY = TimeUnit.MINUTES.toMillis(1L);
        private final RestClient restClient;
        private final HostsSniffer hostsSniffer;
        private long sniffIntervalMillis = DEFAULT_SNIFF_INTERVAL;
        private long sniffAfterFailureDelayMillis = DEFAULT_SNIFF_AFTER_FAILURE_DELAY;

        private Builder(RestClient restClient, HostsSniffer hostsSniffer) {
            Objects.requireNonNull(restClient, "restClient cannot be null");
            this.restClient = restClient;
            Objects.requireNonNull(hostsSniffer, "hostsSniffer cannot be null");
            this.hostsSniffer = hostsSniffer;
        }

        public Builder setSniffIntervalMillis(int sniffIntervalMillis) {
            if (sniffIntervalMillis <= 0) {
                throw new IllegalArgumentException("sniffIntervalMillis must be greater than 0");
            }
            this.sniffIntervalMillis = sniffIntervalMillis;
            return this;
        }

        public Builder setSniffAfterFailureDelayMillis(int sniffAfterFailureDelayMillis) {
            if (sniffAfterFailureDelayMillis <= 0) {
                throw new IllegalArgumentException("sniffAfterFailureDelayMillis must be greater than 0");
            }
            this.sniffAfterFailureDelayMillis = sniffAfterFailureDelayMillis;
            return this;
        }

        public Sniffer build() {
            return new Sniffer(this.restClient, this.hostsSniffer, this.sniffIntervalMillis, this.sniffAfterFailureDelayMillis);
        }
    }

    private static class Task
    implements Runnable {
        private final HostsSniffer hostsSniffer;
        private final RestClient restClient;
        private final long sniffIntervalMillis;
        private final long sniffAfterFailureDelayMillis;
        private final ScheduledExecutorService scheduledExecutorService;
        private final AtomicBoolean running = new AtomicBoolean(false);
        private ScheduledFuture<?> scheduledFuture;

        private Task(HostsSniffer hostsSniffer, RestClient restClient, long sniffIntervalMillis, long sniffAfterFailureDelayMillis) {
            this.hostsSniffer = hostsSniffer;
            this.restClient = restClient;
            this.sniffIntervalMillis = sniffIntervalMillis;
            this.sniffAfterFailureDelayMillis = sniffAfterFailureDelayMillis;
            this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
            this.scheduleNextRun(0L);
        }

        synchronized void scheduleNextRun(long delayMillis) {
            if (!this.scheduledExecutorService.isShutdown()) {
                try {
                    if (this.scheduledFuture != null) {
                        this.scheduledFuture.cancel(false);
                    }
                    logger.debug((Object)("scheduling next sniff in " + delayMillis + " ms"));
                    this.scheduledFuture = this.scheduledExecutorService.schedule(this, delayMillis, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    logger.error((Object)"error while scheduling next sniffer task", (Throwable)e);
                }
            }
        }

        @Override
        public void run() {
            this.sniff(null, this.sniffIntervalMillis);
        }

        void sniffOnFailure(HttpHost failedHost) {
            this.sniff(failedHost, this.sniffAfterFailureDelayMillis);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sniff(HttpHost excludeHost, long nextSniffDelayMillis) {
            if (this.running.compareAndSet(false, true)) {
                try {
                    List<HttpHost> sniffedHosts = this.hostsSniffer.sniffHosts();
                    logger.debug((Object)("sniffed hosts: " + sniffedHosts));
                    if (excludeHost != null) {
                        sniffedHosts.remove(excludeHost);
                    }
                    if (sniffedHosts.isEmpty()) {
                        logger.warn((Object)"no hosts to set, hosts will be updated at the next sniffing round");
                    } else {
                        this.restClient.setHosts(sniffedHosts.toArray(new HttpHost[sniffedHosts.size()]));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"error while sniffing nodes", (Throwable)e);
                }
                finally {
                    this.scheduleNextRun(nextSniffDelayMillis);
                    this.running.set(false);
                }
            }
        }

        synchronized void shutdown() {
            this.scheduledExecutorService.shutdown();
            try {
                if (this.scheduledExecutorService.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                    return;
                }
                this.scheduledExecutorService.shutdownNow();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

