/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk.byscroll;

import org.elasticsearch.action.bulk.byscroll.AbstractBulkByScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.test.ESTestCase;

public abstract class AbstractBulkByScrollRequestTestCase<R extends AbstractBulkByScrollRequest<R>>
extends ESTestCase {
    public void testForSlice() {
        R original = this.newRequest();
        original.setAbortOnVersionConflict(AbstractBulkByScrollRequestTestCase.randomBoolean());
        original.setRefresh(AbstractBulkByScrollRequestTestCase.randomBoolean());
        original.setTimeout(TimeValue.parseTimeValue((String)AbstractBulkByScrollRequestTestCase.randomPositiveTimeValue(), (String)"timeout"));
        original.setWaitForActiveShards(AbstractBulkByScrollRequestTestCase.randomFrom(ActiveShardCount.ALL, ActiveShardCount.NONE, ActiveShardCount.ONE, ActiveShardCount.DEFAULT));
        original.setRetryBackoffInitialTime(TimeValue.parseTimeValue((String)AbstractBulkByScrollRequestTestCase.randomPositiveTimeValue(), (String)"retry_backoff_initial_time"));
        original.setMaxRetries(AbstractBulkByScrollRequestTestCase.between(0, 1000));
        original.setSlices(AbstractBulkByScrollRequestTestCase.between(2, 1000));
        original.setRequestsPerSecond(AbstractBulkByScrollRequestTestCase.randomBoolean() ? Float.POSITIVE_INFINITY : AbstractBulkByScrollRequestTestCase.randomValueOtherThanMany(r -> r.floatValue() < 0.0f, ESTestCase::randomFloat).floatValue());
        original.setSize(AbstractBulkByScrollRequestTestCase.randomBoolean() ? -1 : AbstractBulkByScrollRequestTestCase.between(0, Integer.MAX_VALUE));
        TaskId slicingTask = new TaskId(AbstractBulkByScrollRequestTestCase.randomAsciiOfLength(5), AbstractBulkByScrollRequestTestCase.randomLong());
        SearchRequest sliceRequest = new SearchRequest();
        AbstractBulkByScrollRequest forSliced = original.forSlice(slicingTask, sliceRequest);
        AbstractBulkByScrollRequestTestCase.assertEquals((Object)original.isAbortOnVersionConflict(), (Object)forSliced.isAbortOnVersionConflict());
        AbstractBulkByScrollRequestTestCase.assertEquals((Object)original.isRefresh(), (Object)forSliced.isRefresh());
        AbstractBulkByScrollRequestTestCase.assertEquals((Object)original.getTimeout(), (Object)forSliced.getTimeout());
        AbstractBulkByScrollRequestTestCase.assertEquals((Object)original.getWaitForActiveShards(), (Object)forSliced.getWaitForActiveShards());
        AbstractBulkByScrollRequestTestCase.assertEquals((Object)original.getRetryBackoffInitialTime(), (Object)forSliced.getRetryBackoffInitialTime());
        AbstractBulkByScrollRequestTestCase.assertEquals((long)original.getMaxRetries(), (long)forSliced.getMaxRetries());
        AbstractBulkByScrollRequestTestCase.assertEquals((String)"only the parent task should store results", (Object)false, (Object)forSliced.getShouldStoreResult());
        AbstractBulkByScrollRequestTestCase.assertEquals((String)"slice requests always have a single worker", (long)1L, (long)forSliced.getSlices());
        AbstractBulkByScrollRequestTestCase.assertEquals((String)"requests_per_second is split between all workers", (float)(original.getRequestsPerSecond() / (float)original.getSlices()), (float)forSliced.getRequestsPerSecond(), (float)Float.MIN_NORMAL);
        AbstractBulkByScrollRequestTestCase.assertEquals((String)"size is split evenly between all workers", (long)(original.getSize() == -1 ? -1L : (long)(original.getSize() / original.getSlices())), (long)forSliced.getSize());
        AbstractBulkByScrollRequestTestCase.assertEquals((Object)slicingTask, (Object)forSliced.getParentTask());
        this.extraForSliceAssertions(original, forSliced);
    }

    protected abstract R newRequest();

    protected abstract void extraRandomizationForSlice(R var1);

    protected abstract void extraForSliceAssertions(R var1, R var2);
}

