/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import com.carrotsearch.randomizedtesting.RandomizedRunner;
import com.carrotsearch.randomizedtesting.RandomizedTest;
import java.io.FilePermission;
import java.io.InputStream;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.lucene.util.LuceneTestCase;
import org.elasticsearch.SecureSM;
import org.elasticsearch.bootstrap.Bootstrap;
import org.elasticsearch.bootstrap.BootstrapInfo;
import org.elasticsearch.bootstrap.ESPolicy;
import org.elasticsearch.bootstrap.JarHell;
import org.elasticsearch.bootstrap.Security;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.PathUtils;
import org.junit.Assert;

public class BootstrapForTesting {
    @SuppressForbidden(reason="accesses fully qualified URLs to configure security")
    static Map<String, Policy> getPluginPermissions() throws Exception {
        ArrayList<URL> pluginPolicies = Collections.list(BootstrapForTesting.class.getClassLoader().getResources("plugin-security.policy"));
        if (pluginPolicies.isEmpty()) {
            return Collections.emptyMap();
        }
        HashSet<URL> codebases = new HashSet<URL>(Arrays.asList(BootstrapForTesting.parseClassPathWithSymlinks()));
        HashSet<URL> excluded = new HashSet<URL>(Arrays.asList(Bootstrap.class.getProtectionDomain().getCodeSource().getLocation(), BootstrapForTesting.class.getProtectionDomain().getCodeSource().getLocation(), LuceneTestCase.class.getProtectionDomain().getCodeSource().getLocation(), RandomizedRunner.class.getProtectionDomain().getCodeSource().getLocation(), Assert.class.getProtectionDomain().getCodeSource().getLocation()));
        codebases.removeAll(excluded);
        final ArrayList<Policy> policies = new ArrayList<Policy>();
        for (URL policyFile : pluginPolicies) {
            policies.add(Security.readPolicy((URL)policyFile, (URL[])codebases.toArray(new URL[codebases.size()])));
        }
        HashMap<String, 2> map = new HashMap<String, 2>();
        for (URL url : codebases) {
            map.put(url.getFile(), new Policy(){

                @Override
                public boolean implies(ProtectionDomain domain, Permission permission) {
                    for (Policy p : policies) {
                        if (!p.implies(domain, permission)) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        return Collections.unmodifiableMap(map);
    }

    @SuppressForbidden(reason="does evil stuff with paths and urls because devs and jenkins do evil stuff with paths and urls")
    static URL[] parseClassPathWithSymlinks() throws Exception {
        URL[] raw = JarHell.parseClassPath();
        for (int i = 0; i < raw.length; ++i) {
            raw[i] = PathUtils.get((URI)raw[i].toURI()).toRealPath(new LinkOption[0]).toUri().toURL();
        }
        return raw;
    }

    public static void ensureInitialized() {
    }

    static {
        Path javaTmpDir = PathUtils.get((String)Objects.requireNonNull(System.getProperty("java.io.tmpdir"), "please set ${java.io.tmpdir} in pom.xml"), (String[])new String[0]);
        try {
            Security.ensureDirectoryExists((Path)javaTmpDir);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to create test temp directory", e);
        }
        Bootstrap.initializeNatives((Path)javaTmpDir, (boolean)true, (boolean)true, (boolean)true);
        Bootstrap.initializeProbes();
        BootstrapInfo.getSystemProperties();
        try {
            JarHell.checkJarHell();
        }
        catch (Exception e) {
            throw new RuntimeException("found jar hell in test classpath", e);
        }
        if (RandomizedTest.systemPropertyAsBoolean((String)"tests.security.manager", (boolean)true)) {
            try {
                boolean testsCoverage;
                Permissions perms = new Permissions();
                Security.addClasspathPermissions((Permissions)perms);
                for (URL url : JarHell.parseClassPath()) {
                    Path path = PathUtils.get((URI)url.toURI());
                    String filename = path.getFileName().toString();
                    if (!filename.contains("jython") || !filename.endsWith(".jar")) continue;
                    perms.add(new FilePermission(path.getParent().toString(), "read,readlink"));
                    perms.add(new FilePermission(path.getParent().resolve("Lib").toString(), "read,readlink"));
                }
                Security.addPath((Permissions)perms, (String)"java.io.tmpdir", (Path)javaTmpDir, (String)"read,readlink,write,delete");
                if (Strings.hasLength((String)System.getProperty("tests.config"))) {
                    perms.add(new FilePermission(System.getProperty("tests.config"), "read,readlink"));
                }
                if (testsCoverage = Booleans.parseBoolean((String)System.getProperty("tests.coverage"), (boolean)false)) {
                    Path coverageDir = PathUtils.get((String)System.getProperty("tests.coverage.dir"), (String[])new String[0]);
                    perms.add(new FilePermission(coverageDir.resolve("jacoco.exec").toString(), "read,write"));
                    perms.add(new FilePermission(coverageDir.resolve("jacoco-it.exec").toString(), "read,write"));
                }
                if (System.getProperty("tests.gradle") == null) {
                    perms.add(new RuntimePermission("setIO"));
                }
                perms.add(new SocketPermission("localhost:0", "listen,resolve"));
                perms.add(new SocketPermission("localhost:1024-", "listen,resolve"));
                Policy testFramework = Security.readPolicy((URL)Bootstrap.class.getResource("test-framework.policy"), (URL[])JarHell.parseClassPath());
                ESPolicy esPolicy = new ESPolicy((PermissionCollection)perms, BootstrapForTesting.getPluginPermissions(), true);
                Policy.setPolicy(new Policy((Policy)esPolicy, testFramework){
                    final /* synthetic */ Policy val$esPolicy;
                    final /* synthetic */ Policy val$testFramework;
                    {
                        this.val$esPolicy = policy;
                        this.val$testFramework = policy2;
                    }

                    @Override
                    public boolean implies(ProtectionDomain domain, Permission permission) {
                        return this.val$esPolicy.implies(domain, permission) || this.val$testFramework.implies(domain, permission);
                    }
                });
                System.setSecurityManager((SecurityManager)SecureSM.createTestSecureSM());
                Security.selfTest();
                for (URL url : Collections.list(BootstrapForTesting.class.getClassLoader().getResources("plugin-descriptor.properties"))) {
                    Properties properties = new Properties();
                    try (InputStream stream = url.openStream();){
                        properties.load(stream);
                    }
                    String clazz = properties.getProperty("classname");
                    if (clazz == null) continue;
                    Class.forName(clazz);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("unable to install test security manager", e);
            }
        }
    }
}

