/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.elasticsearch.client.Response;
import org.elasticsearch.test.rest.ESRestTestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class HeadBodyIsEmptyIntegTestCase
extends ESRestTestCase {
    public void testHeadRoot() throws IOException {
        this.headTestCase("/", Collections.emptyMap(), (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        this.headTestCase("/", Collections.singletonMap("pretty", ""), (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        this.headTestCase("/", Collections.singletonMap("pretty", "true"), (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    private void createTestDoc() throws UnsupportedEncodingException, IOException {
        HeadBodyIsEmptyIntegTestCase.client().performRequest("PUT", "test/test/1", Collections.emptyMap(), (HttpEntity)new StringEntity("{\"test\": \"test\"}"), new Header[0]);
    }

    public void testDocumentExists() throws IOException {
        this.createTestDoc();
        this.headTestCase("test/test/1", Collections.emptyMap(), (Matcher<Integer>)CoreMatchers.equalTo((Object)0));
        this.headTestCase("test/test/1", Collections.singletonMap("pretty", "true"), (Matcher<Integer>)CoreMatchers.equalTo((Object)0));
    }

    public void testIndexExists() throws IOException {
        this.createTestDoc();
        this.headTestCase("test", Collections.emptyMap(), (Matcher<Integer>)CoreMatchers.equalTo((Object)0));
        this.headTestCase("test", Collections.singletonMap("pretty", "true"), (Matcher<Integer>)CoreMatchers.equalTo((Object)0));
    }

    public void testTypeExists() throws IOException {
        this.createTestDoc();
        this.headTestCase("test/test", Collections.emptyMap(), (Matcher<Integer>)CoreMatchers.equalTo((Object)0));
        this.headTestCase("test/test", Collections.singletonMap("pretty", "true"), (Matcher<Integer>)CoreMatchers.equalTo((Object)0));
    }

    private void headTestCase(String url, Map<String, String> params, Matcher<Integer> matcher) throws IOException {
        Response response = HeadBodyIsEmptyIntegTestCase.client().performRequest("HEAD", url, params, new Header[0]);
        HeadBodyIsEmptyIntegTestCase.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        HeadBodyIsEmptyIntegTestCase.assertThat((Object)Integer.valueOf(response.getHeader("Content-Length")), matcher);
        HeadBodyIsEmptyIntegTestCase.assertNull((String)("HEAD requests shouldn't have a response body but " + url + " did"), (Object)response.getEntity());
    }
}

