/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Constants;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.NodeConfigurationSource;
import org.elasticsearch.transport.MockTransportClient;

final class ExternalNode
implements Closeable {
    public static final Settings REQUIRED_SETTINGS = Settings.builder().put(DiscoveryModule.DISCOVERY_TYPE_SETTING.getKey(), "zen").put("transport.type", Randomness.get().nextBoolean() ? "netty3" : "netty4").build();
    private final Path path;
    private final Random random;
    private final NodeConfigurationSource nodeConfigurationSource;
    private Process process;
    private NodeInfo nodeInfo;
    private final String clusterName;
    private TransportClient client;
    private final Logger logger = Loggers.getLogger(this.getClass());
    private Settings externalNodeSettings;

    ExternalNode(Path path, long seed, NodeConfigurationSource nodeConfigurationSource) {
        this(path, null, seed, nodeConfigurationSource);
    }

    ExternalNode(Path path, String clusterName, long seed, NodeConfigurationSource nodeConfigurationSource) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("path must be a directory");
        }
        this.path = path;
        this.clusterName = clusterName;
        this.random = new Random(seed);
        this.nodeConfigurationSource = nodeConfigurationSource;
    }

    synchronized ExternalNode start(Client localNode, Settings defaultSettings, String nodeName, String clusterName, int nodeOrdinal) throws IOException, InterruptedException {
        ExternalNode externalNode = new ExternalNode(this.path, clusterName, this.random.nextLong(), this.nodeConfigurationSource);
        Settings settings = Settings.builder().put(defaultSettings).put(this.nodeConfigurationSource.nodeSettings(nodeOrdinal)).build();
        externalNode.startInternal(localNode, settings, nodeName, clusterName);
        return externalNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="needs java.io.File api to start a process")
    synchronized void startInternal(Client client, Settings settings, String nodeName, String clusterName) throws IOException, InterruptedException {
        if (this.process != null) {
            throw new IllegalStateException("Already started");
        }
        ArrayList<String> params = new ArrayList<String>();
        if (!Constants.WINDOWS) {
            params.add("bin/elasticsearch");
        } else {
            params.add("bin/elasticsearch.bat");
        }
        params.add("-Ecluster.name=" + clusterName);
        params.add("-Enode.name=" + nodeName);
        Settings.Builder externaNodeSettingsBuilder = Settings.builder();
        block14: for (Map.Entry entry : settings.getAsMap().entrySet()) {
            switch ((String)entry.getKey()) {
                case "cluster.name": 
                case "node.name": 
                case "path.home": 
                case "transport.type": 
                case "discovery.type": 
                case "config.ignore_system_properties": {
                    continue block14;
                }
            }
            externaNodeSettingsBuilder.put((String)entry.getKey(), (String)entry.getValue());
        }
        this.externalNodeSettings = externaNodeSettingsBuilder.put(REQUIRED_SETTINGS).build();
        for (Map.Entry entry : this.externalNodeSettings.getAsMap().entrySet()) {
            params.add("-E" + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        params.add("-Epath.home=" + PathUtils.get((String)".", (String[])new String[0]).toAbsolutePath());
        params.add("-Epath.conf=" + this.path + "/config");
        ProcessBuilder builder = new ProcessBuilder(params);
        builder.directory(this.path.toFile());
        builder.inheritIO();
        boolean success = false;
        try {
            this.logger.info("starting external node [{}] with: {}", (Object)nodeName, builder.command());
            this.process = builder.start();
            this.nodeInfo = null;
            if (ExternalNode.waitForNode(client, nodeName)) {
                this.nodeInfo = ExternalNode.nodeInfo(client, nodeName);
                assert (this.nodeInfo != null);
            } else {
                throw new IllegalStateException("Node [" + nodeName + "] didn't join the cluster");
            }
            this.logger.info("external node {} found, version [{}], build {}", (Object)this.nodeInfo.getNode(), (Object)this.nodeInfo.getVersion(), (Object)this.nodeInfo.getBuild());
            success = true;
        }
        finally {
            if (!success) {
                this.stop();
            }
        }
    }

    static boolean waitForNode(Client client, String name) throws InterruptedException {
        return ESTestCase.awaitBusy(() -> {
            NodesInfoResponse nodeInfos = (NodesInfoResponse)client.admin().cluster().prepareNodesInfo(new String[0]).get();
            for (NodeInfo info : nodeInfos.getNodes()) {
                if (!name.equals(info.getNode().getName())) continue;
                return true;
            }
            return false;
        }, 30L, TimeUnit.SECONDS);
    }

    static NodeInfo nodeInfo(Client client, String nodeName) {
        NodesInfoResponse nodeInfos = (NodesInfoResponse)client.admin().cluster().prepareNodesInfo(new String[0]).get();
        for (NodeInfo info : nodeInfos.getNodes()) {
            if (!nodeName.equals(info.getNode().getName())) continue;
            return info;
        }
        return null;
    }

    synchronized TransportAddress getTransportAddress() {
        if (this.nodeInfo == null) {
            throw new IllegalStateException("Node has not started yet");
        }
        return this.nodeInfo.getTransport().getAddress().publishAddress();
    }

    synchronized Client getClient() {
        if (this.nodeInfo == null) {
            throw new IllegalStateException("Node has not started yet");
        }
        if (this.client == null) {
            TransportAddress addr = this.nodeInfo.getTransport().getAddress().publishAddress();
            Settings clientSettings = Settings.builder().put(this.externalNodeSettings).put("client.transport.nodes_sampler_interval", "1s").put("node.name", "transport_client_" + this.nodeInfo.getNode().getName()).put(ClusterName.CLUSTER_NAME_SETTING.getKey(), this.clusterName).put("client.transport.sniff", false).build();
            MockTransportClient client = new MockTransportClient(clientSettings, new Class[0]);
            client.addTransportAddress(addr);
            this.client = client;
        }
        return this.client;
    }

    synchronized void reset(long seed) {
        this.random.setSeed(seed);
    }

    synchronized void stop() throws InterruptedException {
        if (this.running()) {
            try {
                if (this.client != null) {
                    this.client.close();
                }
            }
            finally {
                this.process.destroy();
                this.process.waitFor();
                this.process = null;
                this.nodeInfo = null;
            }
        }
    }

    synchronized boolean running() {
        return this.process != null;
    }

    @Override
    public void close() {
        try {
            this.stop();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    synchronized String getName() {
        if (this.nodeInfo == null) {
            throw new IllegalStateException("Node has not started yet");
        }
        return this.nodeInfo.getNode().getName();
    }
}

