/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;

public class PosixPermissionsResetter
implements AutoCloseable {
    private final PosixFileAttributeView attributeView;
    private final Set<PosixFilePermission> permissions;

    public PosixPermissionsResetter(Path path) throws IOException {
        this.attributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        Assert.assertNotNull((Object)this.attributeView);
        this.permissions = this.attributeView.readAttributes().permissions();
    }

    @Override
    public void close() throws IOException {
        this.attributeView.setPermissions(this.permissions);
    }

    public void setPermissions(Set<PosixFilePermission> newPermissions) throws IOException {
        this.attributeView.setPermissions(newPermissions);
    }

    public Set<PosixFilePermission> getCopyPermissions() {
        return new HashSet<PosixFilePermission>(this.permissions);
    }
}

