/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import com.carrotsearch.randomizedtesting.generators.RandomStrings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Random;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.shard.IndexShardRecoveringException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.test.ESTestCase;

public final class RandomObjects {
    private RandomObjects() {
    }

    public static Tuple<List<Object>, List<Object>> randomStoredFieldValues(Random random, XContentType xContentType) {
        int numValues = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)5);
        ArrayList<Object> originalValues = new ArrayList<Object>();
        ArrayList<Object> expectedParsedValues = new ArrayList<Object>();
        int dataType = RandomNumbers.randomIntBetween((Random)random, (int)0, (int)8);
        block11: for (int i = 0; i < numValues; ++i) {
            switch (dataType) {
                case 0: {
                    long randomLong = random.nextLong();
                    originalValues.add(randomLong);
                    expectedParsedValues.add(randomLong);
                    continue block11;
                }
                case 1: {
                    int randomInt = random.nextInt();
                    originalValues.add(randomInt);
                    expectedParsedValues.add(randomInt);
                    continue block11;
                }
                case 2: {
                    Short randomShort = (short)random.nextInt();
                    originalValues.add(randomShort);
                    expectedParsedValues.add(randomShort.intValue());
                    continue block11;
                }
                case 3: {
                    Byte randomByte = (byte)random.nextInt();
                    originalValues.add(randomByte);
                    expectedParsedValues.add(randomByte.intValue());
                    continue block11;
                }
                case 4: {
                    double randomDouble = random.nextDouble();
                    originalValues.add(randomDouble);
                    expectedParsedValues.add(randomDouble);
                    continue block11;
                }
                case 5: {
                    Float randomFloat = Float.valueOf(random.nextFloat());
                    originalValues.add(randomFloat);
                    if (xContentType == XContentType.CBOR) {
                        expectedParsedValues.add(randomFloat);
                        continue block11;
                    }
                    if (xContentType == XContentType.SMILE) {
                        expectedParsedValues.add(randomFloat.doubleValue());
                        continue block11;
                    }
                    expectedParsedValues.add(Double.parseDouble(randomFloat.toString()));
                    continue block11;
                }
                case 6: {
                    boolean randomBoolean = random.nextBoolean();
                    originalValues.add(randomBoolean);
                    expectedParsedValues.add(randomBoolean);
                    continue block11;
                }
                case 7: {
                    String randomString = random.nextBoolean() ? RandomStrings.randomAsciiOfLengthBetween((Random)random, (int)3, (int)10) : RandomStrings.randomUnicodeOfLengthBetween((Random)random, (int)3, (int)10);
                    originalValues.add(randomString);
                    expectedParsedValues.add(randomString);
                    continue block11;
                }
                case 8: {
                    byte[] randomBytes = RandomStrings.randomUnicodeOfLengthBetween((Random)random, (int)10, (int)50).getBytes(StandardCharsets.UTF_8);
                    BytesArray randomBytesArray = new BytesArray(randomBytes);
                    originalValues.add(randomBytesArray);
                    if (xContentType == XContentType.JSON || xContentType == XContentType.YAML) {
                        expectedParsedValues.add(Base64.getEncoder().encodeToString(randomBytes));
                        continue block11;
                    }
                    expectedParsedValues.add(randomBytesArray);
                    continue block11;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        return Tuple.tuple(originalValues, expectedParsedValues);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BytesReference randomSource(Random random) {
        XContentType xContentType = (XContentType)RandomPicks.randomFrom((Random)random, (Object[])XContentType.values());
        try (XContentBuilder builder = XContentFactory.contentBuilder((XContentType)xContentType);){
            builder.startObject();
            RandomObjects.addFields(random, builder, 0);
            builder.endObject();
            BytesReference bytesReference = builder.bytes();
            return bytesReference;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void addFields(Random random, XContentBuilder builder, int currentDepth) throws IOException {
        int numFields = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)5);
        for (int i = 0; i < numFields; ++i) {
            if (currentDepth < 5 && random.nextBoolean()) {
                if (random.nextBoolean()) {
                    builder.startObject(RandomStrings.randomAsciiOfLengthBetween((Random)random, (int)3, (int)10));
                    RandomObjects.addFields(random, builder, currentDepth + 1);
                    builder.endObject();
                    continue;
                }
                builder.startArray(RandomStrings.randomAsciiOfLengthBetween((Random)random, (int)3, (int)10));
                int numElements = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)5);
                boolean object = random.nextBoolean();
                int dataType = -1;
                if (!object) {
                    dataType = RandomObjects.randomDataType(random);
                }
                for (int j = 0; j < numElements; ++j) {
                    if (object) {
                        builder.startObject();
                        RandomObjects.addFields(random, builder, 5);
                        builder.endObject();
                        continue;
                    }
                    builder.value(RandomObjects.randomFieldValue(random, dataType));
                }
                builder.endArray();
                continue;
            }
            builder.field(RandomStrings.randomAsciiOfLengthBetween((Random)random, (int)3, (int)10), RandomObjects.randomFieldValue(random, RandomObjects.randomDataType(random)));
        }
    }

    private static int randomDataType(Random random) {
        return RandomNumbers.randomIntBetween((Random)random, (int)0, (int)3);
    }

    private static Object randomFieldValue(Random random, int dataType) {
        switch (dataType) {
            case 0: {
                return RandomStrings.randomAsciiOfLengthBetween((Random)random, (int)3, (int)10);
            }
            case 1: {
                return RandomStrings.randomAsciiOfLengthBetween((Random)random, (int)3, (int)10);
            }
            case 2: {
                return random.nextLong();
            }
            case 3: {
                return random.nextDouble();
            }
        }
        throw new UnsupportedOperationException();
    }

    public static ReplicationResponse.ShardInfo randomShardInfo(Random random, boolean failures) {
        int total = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)10);
        if (!failures) {
            return new ReplicationResponse.ShardInfo(total, total, new ReplicationResponse.ShardInfo.Failure[0]);
        }
        int successful = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)total);
        return new ReplicationResponse.ShardInfo(total, successful, RandomObjects.randomShardInfoFailures(random, Math.max(1, total - successful)));
    }

    public static ReplicationResponse.ShardInfo.Failure[] randomShardInfoFailures(Random random, int nbFailures) {
        ArrayList<ReplicationResponse.ShardInfo.Failure> randomFailures = new ArrayList<ReplicationResponse.ShardInfo.Failure>(nbFailures);
        for (int i = 0; i < nbFailures; ++i) {
            randomFailures.add(RandomObjects.randomShardInfoFailure(random));
        }
        return randomFailures.toArray(new ReplicationResponse.ShardInfo.Failure[nbFailures]);
    }

    public static ReplicationResponse.ShardInfo.Failure randomShardInfoFailure(Random random) {
        String index = RandomStrings.randomAsciiOfLength((Random)random, (int)5);
        String indexUuid = RandomStrings.randomAsciiOfLength((Random)random, (int)5);
        int shardId = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)10);
        ShardId shard = new ShardId(index, indexUuid, shardId);
        RestStatus restStatus = ESTestCase.randomFrom(RestStatus.values());
        Exception exception = (Exception)RandomPicks.randomFrom((Random)random, Arrays.asList(new IndexShardRecoveringException(shard), new ElasticsearchException((Throwable)new IllegalArgumentException("Argument is wrong")), new RoutingMissingException(index, RandomStrings.randomAsciiOfLength((Random)random, (int)5), RandomStrings.randomAsciiOfLength((Random)random, (int)5))));
        return new ReplicationResponse.ShardInfo.Failure(shard, RandomStrings.randomAsciiOfLength((Random)random, (int)3), exception, restStatus, random.nextBoolean());
    }
}

