/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;

public final class XContentTestUtils {
    private XContentTestUtils() {
    }

    public static Map<String, Object> convertToMap(ToXContent part) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        part.toXContent(builder, ToXContent.EMPTY_PARAMS);
        builder.endObject();
        return (Map)XContentHelper.convertToMap((BytesReference)builder.bytes(), (boolean)false, (XContentType)builder.contentType()).v2();
    }

    public static String differenceBetweenMapsIgnoringArrayOrder(Map<String, Object> first, Map<String, Object> second) {
        return XContentTestUtils.differenceBetweenMapsIgnoringArrayOrder("", first, second);
    }

    private static String differenceBetweenMapsIgnoringArrayOrder(String path, Map<String, Object> first, Map<String, Object> second) {
        if (first.size() != second.size()) {
            return path + ": sizes of the maps don't match: " + first.size() + " != " + second.size();
        }
        for (String key : first.keySet()) {
            String reason = XContentTestUtils.differenceBetweenObjectsIgnoringArrayOrder(path + "/" + key, first.get(key), second.get(key));
            if (reason == null) continue;
            return reason;
        }
        return null;
    }

    private static String differenceBetweenObjectsIgnoringArrayOrder(String path, Object first, Object second) {
        if (first == null) {
            if (second == null) {
                return null;
            }
            return path + ": first element is null, the second element is not null";
        }
        if (first instanceof List) {
            if (second instanceof List) {
                ArrayList secondList = new ArrayList((List)second);
                List firstList = (List)first;
                if (firstList.size() == secondList.size()) {
                    String reason = path + ": no matches found";
                    for (Object firstObj : firstList) {
                        boolean found = false;
                        for (Object secondObj : secondList) {
                            reason = XContentTestUtils.differenceBetweenObjectsIgnoringArrayOrder(path + "/*", firstObj, secondObj);
                            if (reason != null) continue;
                            secondList.remove(secondObj);
                            found = true;
                            break;
                        }
                        if (found) continue;
                        return reason;
                    }
                    if (secondList.isEmpty()) {
                        return null;
                    }
                    return path + ": the second list is not empty";
                }
                return path + ": sizes of the arrays don't match: " + firstList.size() + " != " + secondList.size();
            }
            return path + ": the second element is not an array";
        }
        if (first instanceof Map) {
            if (second instanceof Map) {
                return XContentTestUtils.differenceBetweenMapsIgnoringArrayOrder(path, (Map)first, (Map)second);
            }
            return path + ": the second element is not a map";
        }
        if (first.equals(second)) {
            return null;
        }
        return path + ": the elements don't match: [" + first + "] != [" + second + "]";
    }
}

