/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.disruption;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.disruption.NetworkDisruption;
import org.elasticsearch.test.transport.MockTransportService;
import org.elasticsearch.transport.TransportService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class NetworkDisruptionIT
extends ESIntegTestCase {
    @Override
    protected Collection<Class<? extends Plugin>> nodePlugins() {
        return Arrays.asList(MockTransportService.TestPlugin.class);
    }

    public void testNetworkPartitionWithNodeShutdown() throws IOException {
        NetworkDisruptionIT.internalCluster().ensureAtLeastNumDataNodes(2);
        String[] nodeNames = NetworkDisruptionIT.internalCluster().getNodeNames();
        NetworkDisruption networkDisruption = new NetworkDisruption(new NetworkDisruption.TwoPartitions(nodeNames[0], nodeNames[1]), new NetworkDisruption.NetworkUnresponsive());
        NetworkDisruptionIT.internalCluster().setDisruptionScheme(networkDisruption);
        networkDisruption.startDisrupting();
        NetworkDisruptionIT.internalCluster().stopRandomNode(InternalTestCluster.nameFilter(nodeNames[0]));
        NetworkDisruptionIT.internalCluster().clearDisruptionScheme();
    }

    public void testNetworkPartitionRemovalRestoresConnections() throws IOException {
        HashSet<String> nodes = new HashSet<String>();
        nodes.addAll(Arrays.asList(NetworkDisruptionIT.internalCluster().getNodeNames()));
        nodes.remove(NetworkDisruptionIT.internalCluster().getMasterName());
        if (nodes.size() <= 2) {
            NetworkDisruptionIT.internalCluster().ensureAtLeastNumDataNodes(3 - nodes.size());
            nodes.addAll(Arrays.asList(NetworkDisruptionIT.internalCluster().getNodeNames()));
            nodes.remove(NetworkDisruptionIT.internalCluster().getMasterName());
        }
        HashSet<String> side1 = new HashSet<String>(NetworkDisruptionIT.randomSubsetOf(NetworkDisruptionIT.randomIntBetween(1, nodes.size() - 1), nodes));
        HashSet<String> side2 = new HashSet<String>(nodes);
        side2.removeAll(side1);
        NetworkDisruptionIT.assertThat((Object)side2.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        NetworkDisruption networkDisruption = new NetworkDisruption(new NetworkDisruption.TwoPartitions((Set<String>)side1, (Set<String>)side2), new NetworkDisruption.NetworkDisconnect());
        NetworkDisruptionIT.internalCluster().setDisruptionScheme(networkDisruption);
        networkDisruption.startDisrupting();
        NetworkDisruptionIT.client(NetworkDisruptionIT.randomFrom(side1)).admin().cluster().prepareNodesInfo(new String[0]).get();
        NetworkDisruptionIT.client(NetworkDisruptionIT.randomFrom(side2)).admin().cluster().prepareNodesInfo(new String[0]).get();
        NetworkDisruptionIT.internalCluster().clearDisruptionScheme();
        for (String nodeA : side1) {
            for (String nodeB : side2) {
                TransportService serviceA = NetworkDisruptionIT.internalCluster().getInstance(TransportService.class, nodeA);
                TransportService serviceB = NetworkDisruptionIT.internalCluster().getInstance(TransportService.class, nodeB);
                NetworkDisruptionIT.assertTrue((String)(nodeA + " is not connected to " + nodeB), (boolean)serviceA.nodeConnected(serviceB.getLocalNode()));
                NetworkDisruptionIT.assertTrue((String)(nodeB + " is not connected to " + nodeA), (boolean)serviceB.nodeConnected(serviceA.getLocalNode()));
            }
        }
    }
}

